/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.openshift.api.model.v6_0.operatorhub.v1alpha1.ResourceInstance;
import io.fabric8.openshift.api.model.v6_0.operatorhub.v1alpha1.ResourceInstanceBuilder;
import io.fabric8.openshift.api.model.v6_0.operatorhub.v1alpha1.ResourceInstanceFluentImpl;
import io.fabric8.openshift.api.model.v6_0.operatorhub.v1alpha1.ResourceList;
import io.fabric8.openshift.api.model.v6_0.operatorhub.v1alpha1.ResourceListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ResourceListFluentImpl<A extends ResourceListFluent<A>>
extends BaseFluent<A>
implements ResourceListFluent<A> {
    private String group;
    private ArrayList<ResourceInstanceBuilder> instances = new ArrayList();
    private String kind;
    private Map<String, Object> additionalProperties;

    public ResourceListFluentImpl() {
    }

    public ResourceListFluentImpl(ResourceList instance) {
        this.withGroup(instance.getGroup());
        this.withInstances(instance.getInstances());
        this.withKind(instance.getKind());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null;
    }

    @Override
    public A addToInstances(Integer index, ResourceInstance item) {
        if (this.instances == null) {
            this.instances = new ArrayList();
        }
        ResourceInstanceBuilder builder = new ResourceInstanceBuilder(item);
        this._visitables.get("instances").add(index >= 0 ? index.intValue() : this._visitables.get("instances").size(), builder);
        this.instances.add(index >= 0 ? index.intValue() : this.instances.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInstances(Integer index, ResourceInstance item) {
        if (this.instances == null) {
            this.instances = new ArrayList();
        }
        ResourceInstanceBuilder builder = new ResourceInstanceBuilder(item);
        if (index < 0 || index >= this._visitables.get("instances").size()) {
            this._visitables.get("instances").add(builder);
        } else {
            this._visitables.get("instances").set(index, builder);
        }
        if (index < 0 || index >= this.instances.size()) {
            this.instances.add(builder);
        } else {
            this.instances.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInstances(ResourceInstance ... items) {
        if (this.instances == null) {
            this.instances = new ArrayList();
        }
        for (ResourceInstance item : items) {
            ResourceInstanceBuilder builder = new ResourceInstanceBuilder(item);
            this._visitables.get("instances").add(builder);
            this.instances.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInstances(Collection<ResourceInstance> items) {
        if (this.instances == null) {
            this.instances = new ArrayList();
        }
        for (ResourceInstance item : items) {
            ResourceInstanceBuilder builder = new ResourceInstanceBuilder(item);
            this._visitables.get("instances").add(builder);
            this.instances.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInstances(ResourceInstance ... items) {
        for (ResourceInstance item : items) {
            ResourceInstanceBuilder builder = new ResourceInstanceBuilder(item);
            this._visitables.get("instances").remove(builder);
            if (this.instances == null) continue;
            this.instances.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInstances(Collection<ResourceInstance> items) {
        for (ResourceInstance item : items) {
            ResourceInstanceBuilder builder = new ResourceInstanceBuilder(item);
            this._visitables.get("instances").remove(builder);
            if (this.instances == null) continue;
            this.instances.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromInstances(Predicate<ResourceInstanceBuilder> predicate) {
        if (this.instances == null) {
            return (A)this;
        }
        Iterator<ResourceInstanceBuilder> each = this.instances.iterator();
        Object visitables = this._visitables.get("instances");
        while (each.hasNext()) {
            ResourceInstanceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ResourceInstance> getInstances() {
        return this.instances != null ? ResourceListFluentImpl.build(this.instances) : null;
    }

    @Override
    public List<ResourceInstance> buildInstances() {
        return this.instances != null ? ResourceListFluentImpl.build(this.instances) : null;
    }

    @Override
    public ResourceInstance buildInstance(Integer index) {
        return this.instances.get(index).build();
    }

    @Override
    public ResourceInstance buildFirstInstance() {
        return this.instances.get(0).build();
    }

    @Override
    public ResourceInstance buildLastInstance() {
        return this.instances.get(this.instances.size() - 1).build();
    }

    @Override
    public ResourceInstance buildMatchingInstance(Predicate<ResourceInstanceBuilder> predicate) {
        for (ResourceInstanceBuilder item : this.instances) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInstance(Predicate<ResourceInstanceBuilder> predicate) {
        for (ResourceInstanceBuilder item : this.instances) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withInstances(List<ResourceInstance> instances) {
        if (this.instances != null) {
            this._visitables.get("instances").removeAll(this.instances);
        }
        if (instances != null) {
            this.instances = new ArrayList();
            for (ResourceInstance item : instances) {
                this.addToInstances(item);
            }
        } else {
            this.instances = null;
        }
        return (A)this;
    }

    @Override
    public A withInstances(ResourceInstance ... instances) {
        if (this.instances != null) {
            this.instances.clear();
        }
        if (instances != null) {
            for (ResourceInstance item : instances) {
                this.addToInstances(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInstances() {
        return this.instances != null && !this.instances.isEmpty();
    }

    @Override
    public A addNewInstance(String name, String namespace) {
        return this.addToInstances(new ResourceInstance(name, namespace));
    }

    @Override
    public ResourceListFluent.InstancesNested<A> addNewInstance() {
        return new InstancesNestedImpl();
    }

    @Override
    public ResourceListFluent.InstancesNested<A> addNewInstanceLike(ResourceInstance item) {
        return new InstancesNestedImpl(-1, item);
    }

    @Override
    public ResourceListFluent.InstancesNested<A> setNewInstanceLike(Integer index, ResourceInstance item) {
        return new InstancesNestedImpl(index, item);
    }

    @Override
    public ResourceListFluent.InstancesNested<A> editInstance(Integer index) {
        if (this.instances.size() <= index) {
            throw new RuntimeException("Can't edit instances. Index exceeds size.");
        }
        return this.setNewInstanceLike(index, this.buildInstance(index));
    }

    @Override
    public ResourceListFluent.InstancesNested<A> editFirstInstance() {
        if (this.instances.size() == 0) {
            throw new RuntimeException("Can't edit first instances. The list is empty.");
        }
        return this.setNewInstanceLike(0, this.buildInstance(0));
    }

    @Override
    public ResourceListFluent.InstancesNested<A> editLastInstance() {
        int index = this.instances.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last instances. The list is empty.");
        }
        return this.setNewInstanceLike(index, this.buildInstance(index));
    }

    @Override
    public ResourceListFluent.InstancesNested<A> editMatchingInstance(Predicate<ResourceInstanceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.instances.size(); ++i) {
            if (!predicate.test(this.instances.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching instances. No match found.");
        }
        return this.setNewInstanceLike(index, this.buildInstance(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceListFluentImpl that = (ResourceListFluentImpl)o;
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.instances != null ? !this.instances.equals(that.instances) : that.instances != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.group, this.instances, this.kind, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group + ",");
        }
        if (this.instances != null && !this.instances.isEmpty()) {
            sb.append("instances:");
            sb.append(this.instances + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class InstancesNestedImpl<N>
    extends ResourceInstanceFluentImpl<ResourceListFluent.InstancesNested<N>>
    implements ResourceListFluent.InstancesNested<N>,
    Nested<N> {
        ResourceInstanceBuilder builder;
        Integer index;

        InstancesNestedImpl(Integer index, ResourceInstance item) {
            this.index = index;
            this.builder = new ResourceInstanceBuilder(this, item);
        }

        InstancesNestedImpl() {
            this.index = -1;
            this.builder = new ResourceInstanceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceListFluentImpl.this.setToInstances(this.index, this.builder.build());
        }

        @Override
        public N endInstance() {
            return this.and();
        }
    }
}

