/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0.operator.v1;

import io.fabric8.kubernetes.api.builder.v6_0.VisitableBuilder;
import io.fabric8.openshift.api.model.v6_0.operator.v1.NetworkSpec;
import io.fabric8.openshift.api.model.v6_0.operator.v1.NetworkSpecFluent;
import io.fabric8.openshift.api.model.v6_0.operator.v1.NetworkSpecFluentImpl;

public class NetworkSpecBuilder
extends NetworkSpecFluentImpl<NetworkSpecBuilder>
implements VisitableBuilder<NetworkSpec, NetworkSpecBuilder> {
    NetworkSpecFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkSpecBuilder() {
        this(false);
    }

    public NetworkSpecBuilder(Boolean validationEnabled) {
        this(new NetworkSpec(), validationEnabled);
    }

    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkSpec(), validationEnabled);
    }

    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent, NetworkSpec instance) {
        this(fluent, instance, false);
    }

    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent, NetworkSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAdditionalNetworks(instance.getAdditionalNetworks());
        fluent.withClusterNetwork(instance.getClusterNetwork());
        fluent.withDefaultNetwork(instance.getDefaultNetwork());
        fluent.withDeployKubeProxy(instance.getDeployKubeProxy());
        fluent.withDisableMultiNetwork(instance.getDisableMultiNetwork());
        fluent.withDisableNetworkDiagnostics(instance.getDisableNetworkDiagnostics());
        fluent.withExportNetworkFlows(instance.getExportNetworkFlows());
        fluent.withKubeProxyConfig(instance.getKubeProxyConfig());
        fluent.withLogLevel(instance.getLogLevel());
        fluent.withManagementState(instance.getManagementState());
        fluent.withMigration(instance.getMigration());
        fluent.withObservedConfig(instance.getObservedConfig());
        fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
        fluent.withServiceNetwork(instance.getServiceNetwork());
        fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
        fluent.withUseMultiNetworkPolicy(instance.getUseMultiNetworkPolicy());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public NetworkSpecBuilder(NetworkSpec instance) {
        this(instance, (Boolean)false);
    }

    public NetworkSpecBuilder(NetworkSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAdditionalNetworks(instance.getAdditionalNetworks());
        this.withClusterNetwork(instance.getClusterNetwork());
        this.withDefaultNetwork(instance.getDefaultNetwork());
        this.withDeployKubeProxy(instance.getDeployKubeProxy());
        this.withDisableMultiNetwork(instance.getDisableMultiNetwork());
        this.withDisableNetworkDiagnostics(instance.getDisableNetworkDiagnostics());
        this.withExportNetworkFlows(instance.getExportNetworkFlows());
        this.withKubeProxyConfig(instance.getKubeProxyConfig());
        this.withLogLevel(instance.getLogLevel());
        this.withManagementState(instance.getManagementState());
        this.withMigration(instance.getMigration());
        this.withObservedConfig(instance.getObservedConfig());
        this.withOperatorLogLevel(instance.getOperatorLogLevel());
        this.withServiceNetwork(instance.getServiceNetwork());
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
        this.withUseMultiNetworkPolicy(instance.getUseMultiNetworkPolicy());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NetworkSpec build() {
        NetworkSpec buildable = new NetworkSpec(this.fluent.getAdditionalNetworks(), this.fluent.getClusterNetwork(), this.fluent.getDefaultNetwork(), this.fluent.getDeployKubeProxy(), this.fluent.getDisableMultiNetwork(), this.fluent.getDisableNetworkDiagnostics(), this.fluent.getExportNetworkFlows(), this.fluent.getKubeProxyConfig(), this.fluent.getLogLevel(), this.fluent.getManagementState(), this.fluent.getMigration(), this.fluent.getObservedConfig(), this.fluent.getOperatorLogLevel(), this.fluent.getServiceNetwork(), this.fluent.getUnsupportedConfigOverrides(), this.fluent.getUseMultiNetworkPolicy());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

