/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0.operator.v1;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.openshift.api.model.v6_0.ConfigMapNameReference;
import io.fabric8.openshift.api.model.v6_0.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.v6_0.ConfigMapNameReferenceFluentImpl;
import io.fabric8.openshift.api.model.v6_0.operator.v1.ClientTLS;
import io.fabric8.openshift.api.model.v6_0.operator.v1.ClientTLSFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClientTLSFluentImpl<A extends ClientTLSFluent<A>>
extends BaseFluent<A>
implements ClientTLSFluent<A> {
    private List<String> allowedSubjectPatterns = new ArrayList<String>();
    private ConfigMapNameReferenceBuilder clientCA;
    private String clientCertificatePolicy;
    private Map<String, Object> additionalProperties;

    public ClientTLSFluentImpl() {
    }

    public ClientTLSFluentImpl(ClientTLS instance) {
        this.withAllowedSubjectPatterns(instance.getAllowedSubjectPatterns());
        this.withClientCA(instance.getClientCA());
        this.withClientCertificatePolicy(instance.getClientCertificatePolicy());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToAllowedSubjectPatterns(Integer index, String item) {
        if (this.allowedSubjectPatterns == null) {
            this.allowedSubjectPatterns = new ArrayList<String>();
        }
        this.allowedSubjectPatterns.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAllowedSubjectPatterns(Integer index, String item) {
        if (this.allowedSubjectPatterns == null) {
            this.allowedSubjectPatterns = new ArrayList<String>();
        }
        this.allowedSubjectPatterns.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAllowedSubjectPatterns(String ... items) {
        if (this.allowedSubjectPatterns == null) {
            this.allowedSubjectPatterns = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedSubjectPatterns.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedSubjectPatterns(Collection<String> items) {
        if (this.allowedSubjectPatterns == null) {
            this.allowedSubjectPatterns = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedSubjectPatterns.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedSubjectPatterns(String ... items) {
        for (String item : items) {
            if (this.allowedSubjectPatterns == null) continue;
            this.allowedSubjectPatterns.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedSubjectPatterns(Collection<String> items) {
        for (String item : items) {
            if (this.allowedSubjectPatterns == null) continue;
            this.allowedSubjectPatterns.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAllowedSubjectPatterns() {
        return this.allowedSubjectPatterns;
    }

    @Override
    public String getAllowedSubjectPattern(Integer index) {
        return this.allowedSubjectPatterns.get(index);
    }

    @Override
    public String getFirstAllowedSubjectPattern() {
        return this.allowedSubjectPatterns.get(0);
    }

    @Override
    public String getLastAllowedSubjectPattern() {
        return this.allowedSubjectPatterns.get(this.allowedSubjectPatterns.size() - 1);
    }

    @Override
    public String getMatchingAllowedSubjectPattern(Predicate<String> predicate) {
        for (String item : this.allowedSubjectPatterns) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedSubjectPattern(Predicate<String> predicate) {
        for (String item : this.allowedSubjectPatterns) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedSubjectPatterns(List<String> allowedSubjectPatterns) {
        if (allowedSubjectPatterns != null) {
            this.allowedSubjectPatterns = new ArrayList<String>();
            for (String item : allowedSubjectPatterns) {
                this.addToAllowedSubjectPatterns(item);
            }
        } else {
            this.allowedSubjectPatterns = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedSubjectPatterns(String ... allowedSubjectPatterns) {
        if (this.allowedSubjectPatterns != null) {
            this.allowedSubjectPatterns.clear();
        }
        if (allowedSubjectPatterns != null) {
            for (String item : allowedSubjectPatterns) {
                this.addToAllowedSubjectPatterns(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedSubjectPatterns() {
        return this.allowedSubjectPatterns != null && !this.allowedSubjectPatterns.isEmpty();
    }

    @Override
    @Deprecated
    public ConfigMapNameReference getClientCA() {
        return this.clientCA != null ? this.clientCA.build() : null;
    }

    @Override
    public ConfigMapNameReference buildClientCA() {
        return this.clientCA != null ? this.clientCA.build() : null;
    }

    @Override
    public A withClientCA(ConfigMapNameReference clientCA) {
        this._visitables.get("clientCA").remove(this.clientCA);
        if (clientCA != null) {
            this.clientCA = new ConfigMapNameReferenceBuilder(clientCA);
            this._visitables.get("clientCA").add(this.clientCA);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClientCA() {
        return this.clientCA != null;
    }

    @Override
    public A withNewClientCA(String name) {
        return this.withClientCA(new ConfigMapNameReference(name));
    }

    @Override
    public ClientTLSFluent.ClientCANested<A> withNewClientCA() {
        return new ClientCANestedImpl();
    }

    @Override
    public ClientTLSFluent.ClientCANested<A> withNewClientCALike(ConfigMapNameReference item) {
        return new ClientCANestedImpl(item);
    }

    @Override
    public ClientTLSFluent.ClientCANested<A> editClientCA() {
        return this.withNewClientCALike(this.getClientCA());
    }

    @Override
    public ClientTLSFluent.ClientCANested<A> editOrNewClientCA() {
        return this.withNewClientCALike(this.getClientCA() != null ? this.getClientCA() : new ConfigMapNameReferenceBuilder().build());
    }

    @Override
    public ClientTLSFluent.ClientCANested<A> editOrNewClientCALike(ConfigMapNameReference item) {
        return this.withNewClientCALike(this.getClientCA() != null ? this.getClientCA() : item);
    }

    @Override
    public String getClientCertificatePolicy() {
        return this.clientCertificatePolicy;
    }

    @Override
    public A withClientCertificatePolicy(String clientCertificatePolicy) {
        this.clientCertificatePolicy = clientCertificatePolicy;
        return (A)this;
    }

    @Override
    public Boolean hasClientCertificatePolicy() {
        return this.clientCertificatePolicy != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientTLSFluentImpl that = (ClientTLSFluentImpl)o;
        if (this.allowedSubjectPatterns != null ? !this.allowedSubjectPatterns.equals(that.allowedSubjectPatterns) : that.allowedSubjectPatterns != null) {
            return false;
        }
        if (this.clientCA != null ? !this.clientCA.equals(that.clientCA) : that.clientCA != null) {
            return false;
        }
        if (this.clientCertificatePolicy != null ? !this.clientCertificatePolicy.equals(that.clientCertificatePolicy) : that.clientCertificatePolicy != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allowedSubjectPatterns, this.clientCA, this.clientCertificatePolicy, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowedSubjectPatterns != null && !this.allowedSubjectPatterns.isEmpty()) {
            sb.append("allowedSubjectPatterns:");
            sb.append(this.allowedSubjectPatterns + ",");
        }
        if (this.clientCA != null) {
            sb.append("clientCA:");
            sb.append(this.clientCA + ",");
        }
        if (this.clientCertificatePolicy != null) {
            sb.append("clientCertificatePolicy:");
            sb.append(this.clientCertificatePolicy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ClientCANestedImpl<N>
    extends ConfigMapNameReferenceFluentImpl<ClientTLSFluent.ClientCANested<N>>
    implements ClientTLSFluent.ClientCANested<N>,
    Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        ClientCANestedImpl(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        ClientCANestedImpl() {
            this.builder = new ConfigMapNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClientTLSFluentImpl.this.withClientCA(this.builder.build());
        }

        @Override
        public N endClientCA() {
            return this.and();
        }
    }
}

