/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0.operator.controlplane.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.openshift.api.model.v6_0.SecretNameReference;
import io.fabric8.openshift.api.model.v6_0.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.v6_0.SecretNameReferenceFluentImpl;
import io.fabric8.openshift.api.model.v6_0.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpec;
import io.fabric8.openshift.api.model.v6_0.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class PodNetworkConnectivityCheckSpecFluentImpl<A extends PodNetworkConnectivityCheckSpecFluent<A>>
extends BaseFluent<A>
implements PodNetworkConnectivityCheckSpecFluent<A> {
    private String sourcePod;
    private String targetEndpoint;
    private SecretNameReferenceBuilder tlsClientCert;
    private Map<String, Object> additionalProperties;

    public PodNetworkConnectivityCheckSpecFluentImpl() {
    }

    public PodNetworkConnectivityCheckSpecFluentImpl(PodNetworkConnectivityCheckSpec instance) {
        this.withSourcePod(instance.getSourcePod());
        this.withTargetEndpoint(instance.getTargetEndpoint());
        this.withTlsClientCert(instance.getTlsClientCert());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getSourcePod() {
        return this.sourcePod;
    }

    @Override
    public A withSourcePod(String sourcePod) {
        this.sourcePod = sourcePod;
        return (A)this;
    }

    @Override
    public Boolean hasSourcePod() {
        return this.sourcePod != null;
    }

    @Override
    public String getTargetEndpoint() {
        return this.targetEndpoint;
    }

    @Override
    public A withTargetEndpoint(String targetEndpoint) {
        this.targetEndpoint = targetEndpoint;
        return (A)this;
    }

    @Override
    public Boolean hasTargetEndpoint() {
        return this.targetEndpoint != null;
    }

    @Override
    @Deprecated
    public SecretNameReference getTlsClientCert() {
        return this.tlsClientCert != null ? this.tlsClientCert.build() : null;
    }

    @Override
    public SecretNameReference buildTlsClientCert() {
        return this.tlsClientCert != null ? this.tlsClientCert.build() : null;
    }

    @Override
    public A withTlsClientCert(SecretNameReference tlsClientCert) {
        this._visitables.get("tlsClientCert").remove(this.tlsClientCert);
        if (tlsClientCert != null) {
            this.tlsClientCert = new SecretNameReferenceBuilder(tlsClientCert);
            this._visitables.get("tlsClientCert").add(this.tlsClientCert);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsClientCert() {
        return this.tlsClientCert != null;
    }

    @Override
    public A withNewTlsClientCert(String name) {
        return this.withTlsClientCert(new SecretNameReference(name));
    }

    @Override
    public PodNetworkConnectivityCheckSpecFluent.TlsClientCertNested<A> withNewTlsClientCert() {
        return new TlsClientCertNestedImpl();
    }

    @Override
    public PodNetworkConnectivityCheckSpecFluent.TlsClientCertNested<A> withNewTlsClientCertLike(SecretNameReference item) {
        return new TlsClientCertNestedImpl(item);
    }

    @Override
    public PodNetworkConnectivityCheckSpecFluent.TlsClientCertNested<A> editTlsClientCert() {
        return this.withNewTlsClientCertLike(this.getTlsClientCert());
    }

    @Override
    public PodNetworkConnectivityCheckSpecFluent.TlsClientCertNested<A> editOrNewTlsClientCert() {
        return this.withNewTlsClientCertLike(this.getTlsClientCert() != null ? this.getTlsClientCert() : new SecretNameReferenceBuilder().build());
    }

    @Override
    public PodNetworkConnectivityCheckSpecFluent.TlsClientCertNested<A> editOrNewTlsClientCertLike(SecretNameReference item) {
        return this.withNewTlsClientCertLike(this.getTlsClientCert() != null ? this.getTlsClientCert() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodNetworkConnectivityCheckSpecFluentImpl that = (PodNetworkConnectivityCheckSpecFluentImpl)o;
        if (this.sourcePod != null ? !this.sourcePod.equals(that.sourcePod) : that.sourcePod != null) {
            return false;
        }
        if (this.targetEndpoint != null ? !this.targetEndpoint.equals(that.targetEndpoint) : that.targetEndpoint != null) {
            return false;
        }
        if (this.tlsClientCert != null ? !this.tlsClientCert.equals(that.tlsClientCert) : that.tlsClientCert != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sourcePod, this.targetEndpoint, this.tlsClientCert, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sourcePod != null) {
            sb.append("sourcePod:");
            sb.append(this.sourcePod + ",");
        }
        if (this.targetEndpoint != null) {
            sb.append("targetEndpoint:");
            sb.append(this.targetEndpoint + ",");
        }
        if (this.tlsClientCert != null) {
            sb.append("tlsClientCert:");
            sb.append(this.tlsClientCert + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class TlsClientCertNestedImpl<N>
    extends SecretNameReferenceFluentImpl<PodNetworkConnectivityCheckSpecFluent.TlsClientCertNested<N>>
    implements PodNetworkConnectivityCheckSpecFluent.TlsClientCertNested<N>,
    Nested<N> {
        SecretNameReferenceBuilder builder;

        TlsClientCertNestedImpl(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        TlsClientCertNestedImpl() {
            this.builder = new SecretNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodNetworkConnectivityCheckSpecFluentImpl.this.withTlsClientCert(this.builder.build());
        }

        @Override
        public N endTlsClientCert() {
            return this.and();
        }
    }
}

