/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.kubernetes.api.model.v6_0.Affinity;
import io.fabric8.kubernetes.api.model.v6_0.ResourceRequirements;
import io.fabric8.kubernetes.api.model.v6_0.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.v6_0.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.v6_0.Toleration;
import io.fabric8.openshift.api.model.v6_0.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigProxy;
import io.fabric8.openshift.api.model.v6_0.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigProxyBuilder;
import io.fabric8.openshift.api.model.v6_0.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigProxyFluentImpl;
import io.fabric8.openshift.api.model.v6_0.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRequests;
import io.fabric8.openshift.api.model.v6_0.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRequestsBuilder;
import io.fabric8.openshift.api.model.v6_0.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRequestsFluentImpl;
import io.fabric8.openshift.api.model.v6_0.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute;
import io.fabric8.openshift.api.model.v6_0.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteBuilder;
import io.fabric8.openshift.api.model.v6_0.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRouteFluentImpl;
import io.fabric8.openshift.api.model.v6_0.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorage;
import io.fabric8.openshift.api.model.v6_0.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageBuilder;
import io.fabric8.openshift.api.model.v6_0.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageFluentImpl;
import io.fabric8.openshift.api.model.v6_0.miscellaneous.imageregistry.operator.v1.ImageRegistrySpec;
import io.fabric8.openshift.api.model.v6_0.miscellaneous.imageregistry.operator.v1.ImageRegistrySpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ImageRegistrySpecFluentImpl<A extends ImageRegistrySpecFluent<A>>
extends BaseFluent<A>
implements ImageRegistrySpecFluent<A> {
    private Affinity affinity;
    private Boolean defaultRoute;
    private Boolean disableRedirect;
    private String httpSecret;
    private String logLevel;
    private Long logging;
    private String managementState;
    private Map<String, String> nodeSelector;
    private Map<String, Object> observedConfig;
    private String operatorLogLevel;
    private ImageRegistryConfigProxyBuilder proxy;
    private Boolean readOnly;
    private Integer replicas;
    private ImageRegistryConfigRequestsBuilder requests;
    private ResourceRequirementsBuilder resources;
    private String rolloutStrategy;
    private ArrayList<ImageRegistryConfigRouteBuilder> routes = new ArrayList();
    private ImageRegistryConfigStorageBuilder storage;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private Map<String, Object> unsupportedConfigOverrides;
    private Map<String, Object> additionalProperties;

    public ImageRegistrySpecFluentImpl() {
    }

    public ImageRegistrySpecFluentImpl(ImageRegistrySpec instance) {
        this.withAffinity(instance.getAffinity());
        this.withDefaultRoute(instance.getDefaultRoute());
        this.withDisableRedirect(instance.getDisableRedirect());
        this.withHttpSecret(instance.getHttpSecret());
        this.withLogLevel(instance.getLogLevel());
        this.withLogging(instance.getLogging());
        this.withManagementState(instance.getManagementState());
        this.withNodeSelector(instance.getNodeSelector());
        this.withObservedConfig(instance.getObservedConfig());
        this.withOperatorLogLevel(instance.getOperatorLogLevel());
        this.withProxy(instance.getProxy());
        this.withReadOnly(instance.getReadOnly());
        this.withReplicas(instance.getReplicas());
        this.withRequests(instance.getRequests());
        this.withResources(instance.getResources());
        this.withRolloutStrategy(instance.getRolloutStrategy());
        this.withRoutes(instance.getRoutes());
        this.withStorage(instance.getStorage());
        this.withTolerations(instance.getTolerations());
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Affinity getAffinity() {
        return this.affinity;
    }

    @Override
    public A withAffinity(Affinity affinity) {
        this.affinity = affinity;
        return (A)this;
    }

    @Override
    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    @Override
    public Boolean getDefaultRoute() {
        return this.defaultRoute;
    }

    @Override
    public A withDefaultRoute(Boolean defaultRoute) {
        this.defaultRoute = defaultRoute;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultRoute() {
        return this.defaultRoute != null;
    }

    @Override
    public Boolean getDisableRedirect() {
        return this.disableRedirect;
    }

    @Override
    public A withDisableRedirect(Boolean disableRedirect) {
        this.disableRedirect = disableRedirect;
        return (A)this;
    }

    @Override
    public Boolean hasDisableRedirect() {
        return this.disableRedirect != null;
    }

    @Override
    public String getHttpSecret() {
        return this.httpSecret;
    }

    @Override
    public A withHttpSecret(String httpSecret) {
        this.httpSecret = httpSecret;
        return (A)this;
    }

    @Override
    public Boolean hasHttpSecret() {
        return this.httpSecret != null;
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    @Override
    public Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    @Override
    public Long getLogging() {
        return this.logging;
    }

    @Override
    public A withLogging(Long logging) {
        this.logging = logging;
        return (A)this;
    }

    @Override
    public Boolean hasLogging() {
        return this.logging != null;
    }

    @Override
    public String getManagementState() {
        return this.managementState;
    }

    @Override
    public A withManagementState(String managementState) {
        this.managementState = managementState;
        return (A)this;
    }

    @Override
    public Boolean hasManagementState() {
        return this.managementState != null;
    }

    @Override
    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    @Override
    public A addToObservedConfig(String key, Object value) {
        if (this.observedConfig == null && key != null && value != null) {
            this.observedConfig = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.observedConfig.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToObservedConfig(Map<String, Object> map) {
        if (this.observedConfig == null && map != null) {
            this.observedConfig = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.observedConfig.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromObservedConfig(String key) {
        if (this.observedConfig == null) {
            return (A)this;
        }
        if (key != null && this.observedConfig != null) {
            this.observedConfig.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromObservedConfig(Map<String, Object> map) {
        if (this.observedConfig == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.observedConfig == null) continue;
                this.observedConfig.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getObservedConfig() {
        return this.observedConfig;
    }

    @Override
    public <K, V> A withObservedConfig(Map<String, Object> observedConfig) {
        this.observedConfig = observedConfig == null ? null : new LinkedHashMap<String, Object>(observedConfig);
        return (A)this;
    }

    @Override
    public Boolean hasObservedConfig() {
        return this.observedConfig != null;
    }

    @Override
    public String getOperatorLogLevel() {
        return this.operatorLogLevel;
    }

    @Override
    public A withOperatorLogLevel(String operatorLogLevel) {
        this.operatorLogLevel = operatorLogLevel;
        return (A)this;
    }

    @Override
    public Boolean hasOperatorLogLevel() {
        return this.operatorLogLevel != null;
    }

    @Override
    @Deprecated
    public ImageRegistryConfigProxy getProxy() {
        return this.proxy != null ? this.proxy.build() : null;
    }

    @Override
    public ImageRegistryConfigProxy buildProxy() {
        return this.proxy != null ? this.proxy.build() : null;
    }

    @Override
    public A withProxy(ImageRegistryConfigProxy proxy) {
        this._visitables.get("proxy").remove(this.proxy);
        if (proxy != null) {
            this.proxy = new ImageRegistryConfigProxyBuilder(proxy);
            this._visitables.get("proxy").add(this.proxy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasProxy() {
        return this.proxy != null;
    }

    @Override
    public A withNewProxy(String http, String https, String noProxy) {
        return this.withProxy(new ImageRegistryConfigProxy(http, https, noProxy));
    }

    @Override
    public ImageRegistrySpecFluent.ProxyNested<A> withNewProxy() {
        return new ProxyNestedImpl();
    }

    @Override
    public ImageRegistrySpecFluent.ProxyNested<A> withNewProxyLike(ImageRegistryConfigProxy item) {
        return new ProxyNestedImpl(item);
    }

    @Override
    public ImageRegistrySpecFluent.ProxyNested<A> editProxy() {
        return this.withNewProxyLike(this.getProxy());
    }

    @Override
    public ImageRegistrySpecFluent.ProxyNested<A> editOrNewProxy() {
        return this.withNewProxyLike(this.getProxy() != null ? this.getProxy() : new ImageRegistryConfigProxyBuilder().build());
    }

    @Override
    public ImageRegistrySpecFluent.ProxyNested<A> editOrNewProxyLike(ImageRegistryConfigProxy item) {
        return this.withNewProxyLike(this.getProxy() != null ? this.getProxy() : item);
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    @Deprecated
    public ImageRegistryConfigRequests getRequests() {
        return this.requests != null ? this.requests.build() : null;
    }

    @Override
    public ImageRegistryConfigRequests buildRequests() {
        return this.requests != null ? this.requests.build() : null;
    }

    @Override
    public A withRequests(ImageRegistryConfigRequests requests) {
        this._visitables.get("requests").remove(this.requests);
        if (requests != null) {
            this.requests = new ImageRegistryConfigRequestsBuilder(requests);
            this._visitables.get("requests").add(this.requests);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRequests() {
        return this.requests != null;
    }

    @Override
    public ImageRegistrySpecFluent.RequestsNested<A> withNewRequests() {
        return new RequestsNestedImpl();
    }

    @Override
    public ImageRegistrySpecFluent.RequestsNested<A> withNewRequestsLike(ImageRegistryConfigRequests item) {
        return new RequestsNestedImpl(item);
    }

    @Override
    public ImageRegistrySpecFluent.RequestsNested<A> editRequests() {
        return this.withNewRequestsLike(this.getRequests());
    }

    @Override
    public ImageRegistrySpecFluent.RequestsNested<A> editOrNewRequests() {
        return this.withNewRequestsLike(this.getRequests() != null ? this.getRequests() : new ImageRegistryConfigRequestsBuilder().build());
    }

    @Override
    public ImageRegistrySpecFluent.RequestsNested<A> editOrNewRequestsLike(ImageRegistryConfigRequests item) {
        return this.withNewRequestsLike(this.getRequests() != null ? this.getRequests() : item);
    }

    @Override
    @Deprecated
    public ResourceRequirements getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this._visitables.get("resources").remove(this.resources);
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public ImageRegistrySpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public ImageRegistrySpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public ImageRegistrySpecFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public ImageRegistrySpecFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourceRequirementsBuilder().build());
    }

    @Override
    public ImageRegistrySpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    public String getRolloutStrategy() {
        return this.rolloutStrategy;
    }

    @Override
    public A withRolloutStrategy(String rolloutStrategy) {
        this.rolloutStrategy = rolloutStrategy;
        return (A)this;
    }

    @Override
    public Boolean hasRolloutStrategy() {
        return this.rolloutStrategy != null;
    }

    @Override
    public A addToRoutes(Integer index, ImageRegistryConfigRoute item) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        ImageRegistryConfigRouteBuilder builder = new ImageRegistryConfigRouteBuilder(item);
        this._visitables.get("routes").add(index >= 0 ? index.intValue() : this._visitables.get("routes").size(), builder);
        this.routes.add(index >= 0 ? index.intValue() : this.routes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRoutes(Integer index, ImageRegistryConfigRoute item) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        ImageRegistryConfigRouteBuilder builder = new ImageRegistryConfigRouteBuilder(item);
        if (index < 0 || index >= this._visitables.get("routes").size()) {
            this._visitables.get("routes").add(builder);
        } else {
            this._visitables.get("routes").set(index, builder);
        }
        if (index < 0 || index >= this.routes.size()) {
            this.routes.add(builder);
        } else {
            this.routes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRoutes(ImageRegistryConfigRoute ... items) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        for (ImageRegistryConfigRoute item : items) {
            ImageRegistryConfigRouteBuilder builder = new ImageRegistryConfigRouteBuilder(item);
            this._visitables.get("routes").add(builder);
            this.routes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRoutes(Collection<ImageRegistryConfigRoute> items) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        for (ImageRegistryConfigRoute item : items) {
            ImageRegistryConfigRouteBuilder builder = new ImageRegistryConfigRouteBuilder(item);
            this._visitables.get("routes").add(builder);
            this.routes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRoutes(ImageRegistryConfigRoute ... items) {
        for (ImageRegistryConfigRoute item : items) {
            ImageRegistryConfigRouteBuilder builder = new ImageRegistryConfigRouteBuilder(item);
            this._visitables.get("routes").remove(builder);
            if (this.routes == null) continue;
            this.routes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRoutes(Collection<ImageRegistryConfigRoute> items) {
        for (ImageRegistryConfigRoute item : items) {
            ImageRegistryConfigRouteBuilder builder = new ImageRegistryConfigRouteBuilder(item);
            this._visitables.get("routes").remove(builder);
            if (this.routes == null) continue;
            this.routes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRoutes(Predicate<ImageRegistryConfigRouteBuilder> predicate) {
        if (this.routes == null) {
            return (A)this;
        }
        Iterator<ImageRegistryConfigRouteBuilder> each = this.routes.iterator();
        Object visitables = this._visitables.get("routes");
        while (each.hasNext()) {
            ImageRegistryConfigRouteBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageRegistryConfigRoute> getRoutes() {
        return this.routes != null ? ImageRegistrySpecFluentImpl.build(this.routes) : null;
    }

    @Override
    public List<ImageRegistryConfigRoute> buildRoutes() {
        return this.routes != null ? ImageRegistrySpecFluentImpl.build(this.routes) : null;
    }

    @Override
    public ImageRegistryConfigRoute buildRoute(Integer index) {
        return this.routes.get(index).build();
    }

    @Override
    public ImageRegistryConfigRoute buildFirstRoute() {
        return this.routes.get(0).build();
    }

    @Override
    public ImageRegistryConfigRoute buildLastRoute() {
        return this.routes.get(this.routes.size() - 1).build();
    }

    @Override
    public ImageRegistryConfigRoute buildMatchingRoute(Predicate<ImageRegistryConfigRouteBuilder> predicate) {
        for (ImageRegistryConfigRouteBuilder item : this.routes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRoute(Predicate<ImageRegistryConfigRouteBuilder> predicate) {
        for (ImageRegistryConfigRouteBuilder item : this.routes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRoutes(List<ImageRegistryConfigRoute> routes) {
        if (this.routes != null) {
            this._visitables.get("routes").removeAll(this.routes);
        }
        if (routes != null) {
            this.routes = new ArrayList();
            for (ImageRegistryConfigRoute item : routes) {
                this.addToRoutes(item);
            }
        } else {
            this.routes = null;
        }
        return (A)this;
    }

    @Override
    public A withRoutes(ImageRegistryConfigRoute ... routes) {
        if (this.routes != null) {
            this.routes.clear();
        }
        if (routes != null) {
            for (ImageRegistryConfigRoute item : routes) {
                this.addToRoutes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoutes() {
        return this.routes != null && !this.routes.isEmpty();
    }

    @Override
    public A addNewRoute(String hostname, String name, String secretName) {
        return this.addToRoutes(new ImageRegistryConfigRoute(hostname, name, secretName));
    }

    @Override
    public ImageRegistrySpecFluent.RoutesNested<A> addNewRoute() {
        return new RoutesNestedImpl();
    }

    @Override
    public ImageRegistrySpecFluent.RoutesNested<A> addNewRouteLike(ImageRegistryConfigRoute item) {
        return new RoutesNestedImpl(-1, item);
    }

    @Override
    public ImageRegistrySpecFluent.RoutesNested<A> setNewRouteLike(Integer index, ImageRegistryConfigRoute item) {
        return new RoutesNestedImpl(index, item);
    }

    @Override
    public ImageRegistrySpecFluent.RoutesNested<A> editRoute(Integer index) {
        if (this.routes.size() <= index) {
            throw new RuntimeException("Can't edit routes. Index exceeds size.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    @Override
    public ImageRegistrySpecFluent.RoutesNested<A> editFirstRoute() {
        if (this.routes.size() == 0) {
            throw new RuntimeException("Can't edit first routes. The list is empty.");
        }
        return this.setNewRouteLike(0, this.buildRoute(0));
    }

    @Override
    public ImageRegistrySpecFluent.RoutesNested<A> editLastRoute() {
        int index = this.routes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last routes. The list is empty.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    @Override
    public ImageRegistrySpecFluent.RoutesNested<A> editMatchingRoute(Predicate<ImageRegistryConfigRouteBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.routes.size(); ++i) {
            if (!predicate.test(this.routes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching routes. No match found.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    @Override
    @Deprecated
    public ImageRegistryConfigStorage getStorage() {
        return this.storage != null ? this.storage.build() : null;
    }

    @Override
    public ImageRegistryConfigStorage buildStorage() {
        return this.storage != null ? this.storage.build() : null;
    }

    @Override
    public A withStorage(ImageRegistryConfigStorage storage) {
        this._visitables.get("storage").remove(this.storage);
        if (storage != null) {
            this.storage = new ImageRegistryConfigStorageBuilder(storage);
            this._visitables.get("storage").add(this.storage);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStorage() {
        return this.storage != null;
    }

    @Override
    public ImageRegistrySpecFluent.StorageNested<A> withNewStorage() {
        return new StorageNestedImpl();
    }

    @Override
    public ImageRegistrySpecFluent.StorageNested<A> withNewStorageLike(ImageRegistryConfigStorage item) {
        return new StorageNestedImpl(item);
    }

    @Override
    public ImageRegistrySpecFluent.StorageNested<A> editStorage() {
        return this.withNewStorageLike(this.getStorage());
    }

    @Override
    public ImageRegistrySpecFluent.StorageNested<A> editOrNewStorage() {
        return this.withNewStorageLike(this.getStorage() != null ? this.getStorage() : new ImageRegistryConfigStorageBuilder().build());
    }

    @Override
    public ImageRegistrySpecFluent.StorageNested<A> editOrNewStorageLike(ImageRegistryConfigStorage item) {
        return this.withNewStorageLike(this.getStorage() != null ? this.getStorage() : item);
    }

    @Override
    public A addToTolerations(Integer index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTolerations(Integer index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTolerations(Toleration ... items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    @Override
    public Toleration getToleration(Integer index) {
        return this.tolerations.get(index);
    }

    @Override
    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    @Override
    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    @Override
    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTolerations(List<Toleration> tolerations) {
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    @Override
    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    @Override
    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    @Override
    public A addToUnsupportedConfigOverrides(String key, Object value) {
        if (this.unsupportedConfigOverrides == null && key != null && value != null) {
            this.unsupportedConfigOverrides = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.unsupportedConfigOverrides.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToUnsupportedConfigOverrides(Map<String, Object> map) {
        if (this.unsupportedConfigOverrides == null && map != null) {
            this.unsupportedConfigOverrides = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.unsupportedConfigOverrides.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromUnsupportedConfigOverrides(String key) {
        if (this.unsupportedConfigOverrides == null) {
            return (A)this;
        }
        if (key != null && this.unsupportedConfigOverrides != null) {
            this.unsupportedConfigOverrides.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromUnsupportedConfigOverrides(Map<String, Object> map) {
        if (this.unsupportedConfigOverrides == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.unsupportedConfigOverrides == null) continue;
                this.unsupportedConfigOverrides.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getUnsupportedConfigOverrides() {
        return this.unsupportedConfigOverrides;
    }

    @Override
    public <K, V> A withUnsupportedConfigOverrides(Map<String, Object> unsupportedConfigOverrides) {
        this.unsupportedConfigOverrides = unsupportedConfigOverrides == null ? null : new LinkedHashMap<String, Object>(unsupportedConfigOverrides);
        return (A)this;
    }

    @Override
    public Boolean hasUnsupportedConfigOverrides() {
        return this.unsupportedConfigOverrides != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageRegistrySpecFluentImpl that = (ImageRegistrySpecFluentImpl)o;
        if (this.affinity != null ? !this.affinity.equals(that.affinity) : that.affinity != null) {
            return false;
        }
        if (this.defaultRoute != null ? !this.defaultRoute.equals(that.defaultRoute) : that.defaultRoute != null) {
            return false;
        }
        if (this.disableRedirect != null ? !this.disableRedirect.equals(that.disableRedirect) : that.disableRedirect != null) {
            return false;
        }
        if (this.httpSecret != null ? !this.httpSecret.equals(that.httpSecret) : that.httpSecret != null) {
            return false;
        }
        if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) {
            return false;
        }
        if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) {
            return false;
        }
        if (this.managementState != null ? !this.managementState.equals(that.managementState) : that.managementState != null) {
            return false;
        }
        if (this.nodeSelector != null ? !this.nodeSelector.equals(that.nodeSelector) : that.nodeSelector != null) {
            return false;
        }
        if (this.observedConfig != null ? !this.observedConfig.equals(that.observedConfig) : that.observedConfig != null) {
            return false;
        }
        if (this.operatorLogLevel != null ? !this.operatorLogLevel.equals(that.operatorLogLevel) : that.operatorLogLevel != null) {
            return false;
        }
        if (this.proxy != null ? !this.proxy.equals(that.proxy) : that.proxy != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.requests != null ? !this.requests.equals(that.requests) : that.requests != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.rolloutStrategy != null ? !this.rolloutStrategy.equals(that.rolloutStrategy) : that.rolloutStrategy != null) {
            return false;
        }
        if (this.routes != null ? !this.routes.equals(that.routes) : that.routes != null) {
            return false;
        }
        if (this.storage != null ? !this.storage.equals(that.storage) : that.storage != null) {
            return false;
        }
        if (this.tolerations != null ? !this.tolerations.equals(that.tolerations) : that.tolerations != null) {
            return false;
        }
        if (this.unsupportedConfigOverrides != null ? !this.unsupportedConfigOverrides.equals(that.unsupportedConfigOverrides) : that.unsupportedConfigOverrides != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.affinity, this.defaultRoute, this.disableRedirect, this.httpSecret, this.logLevel, this.logging, this.managementState, this.nodeSelector, this.observedConfig, this.operatorLogLevel, this.proxy, this.readOnly, this.replicas, this.requests, this.resources, this.rolloutStrategy, this.routes, this.storage, this.tolerations, this.unsupportedConfigOverrides, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.affinity != null) {
            sb.append("affinity:");
            sb.append(this.affinity + ",");
        }
        if (this.defaultRoute != null) {
            sb.append("defaultRoute:");
            sb.append(this.defaultRoute + ",");
        }
        if (this.disableRedirect != null) {
            sb.append("disableRedirect:");
            sb.append(this.disableRedirect + ",");
        }
        if (this.httpSecret != null) {
            sb.append("httpSecret:");
            sb.append(this.httpSecret + ",");
        }
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.logging != null) {
            sb.append("logging:");
            sb.append(this.logging + ",");
        }
        if (this.managementState != null) {
            sb.append("managementState:");
            sb.append(this.managementState + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.observedConfig != null && !this.observedConfig.isEmpty()) {
            sb.append("observedConfig:");
            sb.append(this.observedConfig + ",");
        }
        if (this.operatorLogLevel != null) {
            sb.append("operatorLogLevel:");
            sb.append(this.operatorLogLevel + ",");
        }
        if (this.proxy != null) {
            sb.append("proxy:");
            sb.append(this.proxy + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.requests != null) {
            sb.append("requests:");
            sb.append(this.requests + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.rolloutStrategy != null) {
            sb.append("rolloutStrategy:");
            sb.append(this.rolloutStrategy + ",");
        }
        if (this.routes != null && !this.routes.isEmpty()) {
            sb.append("routes:");
            sb.append(this.routes + ",");
        }
        if (this.storage != null) {
            sb.append("storage:");
            sb.append(this.storage + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(this.tolerations + ",");
        }
        if (this.unsupportedConfigOverrides != null && !this.unsupportedConfigOverrides.isEmpty()) {
            sb.append("unsupportedConfigOverrides:");
            sb.append(this.unsupportedConfigOverrides + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withDefaultRoute() {
        return this.withDefaultRoute(true);
    }

    @Override
    public A withDisableRedirect() {
        return this.withDisableRedirect(true);
    }

    @Override
    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    class StorageNestedImpl<N>
    extends ImageRegistryConfigStorageFluentImpl<ImageRegistrySpecFluent.StorageNested<N>>
    implements ImageRegistrySpecFluent.StorageNested<N>,
    Nested<N> {
        ImageRegistryConfigStorageBuilder builder;

        StorageNestedImpl(ImageRegistryConfigStorage item) {
            this.builder = new ImageRegistryConfigStorageBuilder(this, item);
        }

        StorageNestedImpl() {
            this.builder = new ImageRegistryConfigStorageBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageRegistrySpecFluentImpl.this.withStorage(this.builder.build());
        }

        @Override
        public N endStorage() {
            return this.and();
        }
    }

    class RoutesNestedImpl<N>
    extends ImageRegistryConfigRouteFluentImpl<ImageRegistrySpecFluent.RoutesNested<N>>
    implements ImageRegistrySpecFluent.RoutesNested<N>,
    Nested<N> {
        ImageRegistryConfigRouteBuilder builder;
        Integer index;

        RoutesNestedImpl(Integer index, ImageRegistryConfigRoute item) {
            this.index = index;
            this.builder = new ImageRegistryConfigRouteBuilder(this, item);
        }

        RoutesNestedImpl() {
            this.index = -1;
            this.builder = new ImageRegistryConfigRouteBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageRegistrySpecFluentImpl.this.setToRoutes(this.index, this.builder.build());
        }

        @Override
        public N endRoute() {
            return this.and();
        }
    }

    class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<ImageRegistrySpecFluent.ResourcesNested<N>>
    implements ImageRegistrySpecFluent.ResourcesNested<N>,
    Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageRegistrySpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    class RequestsNestedImpl<N>
    extends ImageRegistryConfigRequestsFluentImpl<ImageRegistrySpecFluent.RequestsNested<N>>
    implements ImageRegistrySpecFluent.RequestsNested<N>,
    Nested<N> {
        ImageRegistryConfigRequestsBuilder builder;

        RequestsNestedImpl(ImageRegistryConfigRequests item) {
            this.builder = new ImageRegistryConfigRequestsBuilder(this, item);
        }

        RequestsNestedImpl() {
            this.builder = new ImageRegistryConfigRequestsBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageRegistrySpecFluentImpl.this.withRequests(this.builder.build());
        }

        @Override
        public N endRequests() {
            return this.and();
        }
    }

    class ProxyNestedImpl<N>
    extends ImageRegistryConfigProxyFluentImpl<ImageRegistrySpecFluent.ProxyNested<N>>
    implements ImageRegistrySpecFluent.ProxyNested<N>,
    Nested<N> {
        ImageRegistryConfigProxyBuilder builder;

        ProxyNestedImpl(ImageRegistryConfigProxy item) {
            this.builder = new ImageRegistryConfigProxyBuilder(this, item);
        }

        ProxyNestedImpl() {
            this.builder = new ImageRegistryConfigProxyBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageRegistrySpecFluentImpl.this.withProxy(this.builder.build());
        }

        @Override
        public N endProxy() {
            return this.and();
        }
    }
}

