/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0.installer.v1;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.kubernetes.api.model.v6_0.ObjectMeta;
import io.fabric8.kubernetes.api.model.v6_0.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v6_0.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v6_0.installer.v1.BootstrapInPlace;
import io.fabric8.openshift.api.model.v6_0.installer.v1.BootstrapInPlaceBuilder;
import io.fabric8.openshift.api.model.v6_0.installer.v1.BootstrapInPlaceFluentImpl;
import io.fabric8.openshift.api.model.v6_0.installer.v1.ImageContentSource;
import io.fabric8.openshift.api.model.v6_0.installer.v1.ImageContentSourceBuilder;
import io.fabric8.openshift.api.model.v6_0.installer.v1.ImageContentSourceFluentImpl;
import io.fabric8.openshift.api.model.v6_0.installer.v1.InstallConfig;
import io.fabric8.openshift.api.model.v6_0.installer.v1.InstallConfigFluent;
import io.fabric8.openshift.api.model.v6_0.installer.v1.MachinePool;
import io.fabric8.openshift.api.model.v6_0.installer.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.v6_0.installer.v1.MachinePoolFluentImpl;
import io.fabric8.openshift.api.model.v6_0.installer.v1.Networking;
import io.fabric8.openshift.api.model.v6_0.installer.v1.NetworkingBuilder;
import io.fabric8.openshift.api.model.v6_0.installer.v1.NetworkingFluentImpl;
import io.fabric8.openshift.api.model.v6_0.installer.v1.Platform;
import io.fabric8.openshift.api.model.v6_0.installer.v1.PlatformBuilder;
import io.fabric8.openshift.api.model.v6_0.installer.v1.PlatformFluentImpl;
import io.fabric8.openshift.api.model.v6_0.installer.v1.Proxy;
import io.fabric8.openshift.api.model.v6_0.installer.v1.ProxyBuilder;
import io.fabric8.openshift.api.model.v6_0.installer.v1.ProxyFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class InstallConfigFluentImpl<A extends InstallConfigFluent<A>>
extends BaseFluent<A>
implements InstallConfigFluent<A> {
    private String additionalTrustBundle;
    private String apiVersion;
    private String baseDomain;
    private BootstrapInPlaceBuilder bootstrapInPlace;
    private ArrayList<MachinePoolBuilder> compute = new ArrayList();
    private MachinePoolBuilder controlPlane;
    private String credentialsMode;
    private Boolean fips;
    private ArrayList<ImageContentSourceBuilder> imageContentSources = new ArrayList();
    private String kind;
    private ObjectMetaBuilder metadata;
    private NetworkingBuilder networking;
    private PlatformBuilder platform;
    private ProxyBuilder proxy;
    private String publish;
    private String pullSecret;
    private String sshKey;
    private Map<String, Object> additionalProperties;

    public InstallConfigFluentImpl() {
    }

    public InstallConfigFluentImpl(InstallConfig instance) {
        this.withAdditionalTrustBundle(instance.getAdditionalTrustBundle());
        this.withApiVersion(instance.getApiVersion());
        this.withBaseDomain(instance.getBaseDomain());
        this.withBootstrapInPlace(instance.getBootstrapInPlace());
        this.withCompute(instance.getCompute());
        this.withControlPlane(instance.getControlPlane());
        this.withCredentialsMode(instance.getCredentialsMode());
        this.withFips(instance.getFips());
        this.withImageContentSources(instance.getImageContentSources());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withNetworking(instance.getNetworking());
        this.withPlatform(instance.getPlatform());
        this.withProxy(instance.getProxy());
        this.withPublish(instance.getPublish());
        this.withPullSecret(instance.getPullSecret());
        this.withSshKey(instance.getSshKey());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getAdditionalTrustBundle() {
        return this.additionalTrustBundle;
    }

    @Override
    public A withAdditionalTrustBundle(String additionalTrustBundle) {
        this.additionalTrustBundle = additionalTrustBundle;
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalTrustBundle() {
        return this.additionalTrustBundle != null;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getBaseDomain() {
        return this.baseDomain;
    }

    @Override
    public A withBaseDomain(String baseDomain) {
        this.baseDomain = baseDomain;
        return (A)this;
    }

    @Override
    public Boolean hasBaseDomain() {
        return this.baseDomain != null;
    }

    @Override
    @Deprecated
    public BootstrapInPlace getBootstrapInPlace() {
        return this.bootstrapInPlace != null ? this.bootstrapInPlace.build() : null;
    }

    @Override
    public BootstrapInPlace buildBootstrapInPlace() {
        return this.bootstrapInPlace != null ? this.bootstrapInPlace.build() : null;
    }

    @Override
    public A withBootstrapInPlace(BootstrapInPlace bootstrapInPlace) {
        this._visitables.get("bootstrapInPlace").remove(this.bootstrapInPlace);
        if (bootstrapInPlace != null) {
            this.bootstrapInPlace = new BootstrapInPlaceBuilder(bootstrapInPlace);
            this._visitables.get("bootstrapInPlace").add(this.bootstrapInPlace);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBootstrapInPlace() {
        return this.bootstrapInPlace != null;
    }

    @Override
    public A withNewBootstrapInPlace(String installationDisk) {
        return this.withBootstrapInPlace(new BootstrapInPlace(installationDisk));
    }

    @Override
    public InstallConfigFluent.BootstrapInPlaceNested<A> withNewBootstrapInPlace() {
        return new BootstrapInPlaceNestedImpl();
    }

    @Override
    public InstallConfigFluent.BootstrapInPlaceNested<A> withNewBootstrapInPlaceLike(BootstrapInPlace item) {
        return new BootstrapInPlaceNestedImpl(item);
    }

    @Override
    public InstallConfigFluent.BootstrapInPlaceNested<A> editBootstrapInPlace() {
        return this.withNewBootstrapInPlaceLike(this.getBootstrapInPlace());
    }

    @Override
    public InstallConfigFluent.BootstrapInPlaceNested<A> editOrNewBootstrapInPlace() {
        return this.withNewBootstrapInPlaceLike(this.getBootstrapInPlace() != null ? this.getBootstrapInPlace() : new BootstrapInPlaceBuilder().build());
    }

    @Override
    public InstallConfigFluent.BootstrapInPlaceNested<A> editOrNewBootstrapInPlaceLike(BootstrapInPlace item) {
        return this.withNewBootstrapInPlaceLike(this.getBootstrapInPlace() != null ? this.getBootstrapInPlace() : item);
    }

    @Override
    public A addToCompute(Integer index, MachinePool item) {
        if (this.compute == null) {
            this.compute = new ArrayList();
        }
        MachinePoolBuilder builder = new MachinePoolBuilder(item);
        this._visitables.get("compute").add(index >= 0 ? index.intValue() : this._visitables.get("compute").size(), builder);
        this.compute.add(index >= 0 ? index.intValue() : this.compute.size(), builder);
        return (A)this;
    }

    @Override
    public A setToCompute(Integer index, MachinePool item) {
        if (this.compute == null) {
            this.compute = new ArrayList();
        }
        MachinePoolBuilder builder = new MachinePoolBuilder(item);
        if (index < 0 || index >= this._visitables.get("compute").size()) {
            this._visitables.get("compute").add(builder);
        } else {
            this._visitables.get("compute").set(index, builder);
        }
        if (index < 0 || index >= this.compute.size()) {
            this.compute.add(builder);
        } else {
            this.compute.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToCompute(MachinePool ... items) {
        if (this.compute == null) {
            this.compute = new ArrayList();
        }
        for (MachinePool item : items) {
            MachinePoolBuilder builder = new MachinePoolBuilder(item);
            this._visitables.get("compute").add(builder);
            this.compute.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToCompute(Collection<MachinePool> items) {
        if (this.compute == null) {
            this.compute = new ArrayList();
        }
        for (MachinePool item : items) {
            MachinePoolBuilder builder = new MachinePoolBuilder(item);
            this._visitables.get("compute").add(builder);
            this.compute.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromCompute(MachinePool ... items) {
        for (MachinePool item : items) {
            MachinePoolBuilder builder = new MachinePoolBuilder(item);
            this._visitables.get("compute").remove(builder);
            if (this.compute == null) continue;
            this.compute.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCompute(Collection<MachinePool> items) {
        for (MachinePool item : items) {
            MachinePoolBuilder builder = new MachinePoolBuilder(item);
            this._visitables.get("compute").remove(builder);
            if (this.compute == null) continue;
            this.compute.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromCompute(Predicate<MachinePoolBuilder> predicate) {
        if (this.compute == null) {
            return (A)this;
        }
        Iterator<MachinePoolBuilder> each = this.compute.iterator();
        Object visitables = this._visitables.get("compute");
        while (each.hasNext()) {
            MachinePoolBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<MachinePool> getCompute() {
        return this.compute != null ? InstallConfigFluentImpl.build(this.compute) : null;
    }

    @Override
    public List<MachinePool> buildCompute() {
        return this.compute != null ? InstallConfigFluentImpl.build(this.compute) : null;
    }

    @Override
    public MachinePool buildCompute(Integer index) {
        return this.compute.get(index).build();
    }

    @Override
    public MachinePool buildFirstCompute() {
        return this.compute.get(0).build();
    }

    @Override
    public MachinePool buildLastCompute() {
        return this.compute.get(this.compute.size() - 1).build();
    }

    @Override
    public MachinePool buildMatchingCompute(Predicate<MachinePoolBuilder> predicate) {
        for (MachinePoolBuilder item : this.compute) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCompute(Predicate<MachinePoolBuilder> predicate) {
        for (MachinePoolBuilder item : this.compute) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCompute(List<MachinePool> compute) {
        if (this.compute != null) {
            this._visitables.get("compute").removeAll(this.compute);
        }
        if (compute != null) {
            this.compute = new ArrayList();
            for (MachinePool item : compute) {
                this.addToCompute(item);
            }
        } else {
            this.compute = null;
        }
        return (A)this;
    }

    @Override
    public A withCompute(MachinePool ... compute) {
        if (this.compute != null) {
            this.compute.clear();
        }
        if (compute != null) {
            for (MachinePool item : compute) {
                this.addToCompute(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCompute() {
        return this.compute != null && !this.compute.isEmpty();
    }

    @Override
    public InstallConfigFluent.ComputeNested<A> addNewCompute() {
        return new ComputeNestedImpl();
    }

    @Override
    public InstallConfigFluent.ComputeNested<A> addNewComputeLike(MachinePool item) {
        return new ComputeNestedImpl(-1, item);
    }

    @Override
    public InstallConfigFluent.ComputeNested<A> setNewComputeLike(Integer index, MachinePool item) {
        return new ComputeNestedImpl(index, item);
    }

    @Override
    public InstallConfigFluent.ComputeNested<A> editCompute(Integer index) {
        if (this.compute.size() <= index) {
            throw new RuntimeException("Can't edit compute. Index exceeds size.");
        }
        return this.setNewComputeLike(index, this.buildCompute(index));
    }

    @Override
    public InstallConfigFluent.ComputeNested<A> editFirstCompute() {
        if (this.compute.size() == 0) {
            throw new RuntimeException("Can't edit first compute. The list is empty.");
        }
        return this.setNewComputeLike(0, this.buildCompute(0));
    }

    @Override
    public InstallConfigFluent.ComputeNested<A> editLastCompute() {
        int index = this.compute.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last compute. The list is empty.");
        }
        return this.setNewComputeLike(index, this.buildCompute(index));
    }

    @Override
    public InstallConfigFluent.ComputeNested<A> editMatchingCompute(Predicate<MachinePoolBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.compute.size(); ++i) {
            if (!predicate.test(this.compute.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching compute. No match found.");
        }
        return this.setNewComputeLike(index, this.buildCompute(index));
    }

    @Override
    @Deprecated
    public MachinePool getControlPlane() {
        return this.controlPlane != null ? this.controlPlane.build() : null;
    }

    @Override
    public MachinePool buildControlPlane() {
        return this.controlPlane != null ? this.controlPlane.build() : null;
    }

    @Override
    public A withControlPlane(MachinePool controlPlane) {
        this._visitables.get("controlPlane").remove(this.controlPlane);
        if (controlPlane != null) {
            this.controlPlane = new MachinePoolBuilder(controlPlane);
            this._visitables.get("controlPlane").add(this.controlPlane);
        }
        return (A)this;
    }

    @Override
    public Boolean hasControlPlane() {
        return this.controlPlane != null;
    }

    @Override
    public InstallConfigFluent.ControlPlaneNested<A> withNewControlPlane() {
        return new ControlPlaneNestedImpl();
    }

    @Override
    public InstallConfigFluent.ControlPlaneNested<A> withNewControlPlaneLike(MachinePool item) {
        return new ControlPlaneNestedImpl(item);
    }

    @Override
    public InstallConfigFluent.ControlPlaneNested<A> editControlPlane() {
        return this.withNewControlPlaneLike(this.getControlPlane());
    }

    @Override
    public InstallConfigFluent.ControlPlaneNested<A> editOrNewControlPlane() {
        return this.withNewControlPlaneLike(this.getControlPlane() != null ? this.getControlPlane() : new MachinePoolBuilder().build());
    }

    @Override
    public InstallConfigFluent.ControlPlaneNested<A> editOrNewControlPlaneLike(MachinePool item) {
        return this.withNewControlPlaneLike(this.getControlPlane() != null ? this.getControlPlane() : item);
    }

    @Override
    public String getCredentialsMode() {
        return this.credentialsMode;
    }

    @Override
    public A withCredentialsMode(String credentialsMode) {
        this.credentialsMode = credentialsMode;
        return (A)this;
    }

    @Override
    public Boolean hasCredentialsMode() {
        return this.credentialsMode != null;
    }

    @Override
    public Boolean getFips() {
        return this.fips;
    }

    @Override
    public A withFips(Boolean fips) {
        this.fips = fips;
        return (A)this;
    }

    @Override
    public Boolean hasFips() {
        return this.fips != null;
    }

    @Override
    public A addToImageContentSources(Integer index, ImageContentSource item) {
        if (this.imageContentSources == null) {
            this.imageContentSources = new ArrayList();
        }
        ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
        this._visitables.get("imageContentSources").add(index >= 0 ? index.intValue() : this._visitables.get("imageContentSources").size(), builder);
        this.imageContentSources.add(index >= 0 ? index.intValue() : this.imageContentSources.size(), builder);
        return (A)this;
    }

    @Override
    public A setToImageContentSources(Integer index, ImageContentSource item) {
        if (this.imageContentSources == null) {
            this.imageContentSources = new ArrayList();
        }
        ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
        if (index < 0 || index >= this._visitables.get("imageContentSources").size()) {
            this._visitables.get("imageContentSources").add(builder);
        } else {
            this._visitables.get("imageContentSources").set(index, builder);
        }
        if (index < 0 || index >= this.imageContentSources.size()) {
            this.imageContentSources.add(builder);
        } else {
            this.imageContentSources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImageContentSources(ImageContentSource ... items) {
        if (this.imageContentSources == null) {
            this.imageContentSources = new ArrayList();
        }
        for (ImageContentSource item : items) {
            ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
            this._visitables.get("imageContentSources").add(builder);
            this.imageContentSources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImageContentSources(Collection<ImageContentSource> items) {
        if (this.imageContentSources == null) {
            this.imageContentSources = new ArrayList();
        }
        for (ImageContentSource item : items) {
            ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
            this._visitables.get("imageContentSources").add(builder);
            this.imageContentSources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImageContentSources(ImageContentSource ... items) {
        for (ImageContentSource item : items) {
            ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
            this._visitables.get("imageContentSources").remove(builder);
            if (this.imageContentSources == null) continue;
            this.imageContentSources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImageContentSources(Collection<ImageContentSource> items) {
        for (ImageContentSource item : items) {
            ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
            this._visitables.get("imageContentSources").remove(builder);
            if (this.imageContentSources == null) continue;
            this.imageContentSources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromImageContentSources(Predicate<ImageContentSourceBuilder> predicate) {
        if (this.imageContentSources == null) {
            return (A)this;
        }
        Iterator<ImageContentSourceBuilder> each = this.imageContentSources.iterator();
        Object visitables = this._visitables.get("imageContentSources");
        while (each.hasNext()) {
            ImageContentSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageContentSource> getImageContentSources() {
        return this.imageContentSources != null ? InstallConfigFluentImpl.build(this.imageContentSources) : null;
    }

    @Override
    public List<ImageContentSource> buildImageContentSources() {
        return this.imageContentSources != null ? InstallConfigFluentImpl.build(this.imageContentSources) : null;
    }

    @Override
    public ImageContentSource buildImageContentSource(Integer index) {
        return this.imageContentSources.get(index).build();
    }

    @Override
    public ImageContentSource buildFirstImageContentSource() {
        return this.imageContentSources.get(0).build();
    }

    @Override
    public ImageContentSource buildLastImageContentSource() {
        return this.imageContentSources.get(this.imageContentSources.size() - 1).build();
    }

    @Override
    public ImageContentSource buildMatchingImageContentSource(Predicate<ImageContentSourceBuilder> predicate) {
        for (ImageContentSourceBuilder item : this.imageContentSources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImageContentSource(Predicate<ImageContentSourceBuilder> predicate) {
        for (ImageContentSourceBuilder item : this.imageContentSources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImageContentSources(List<ImageContentSource> imageContentSources) {
        if (this.imageContentSources != null) {
            this._visitables.get("imageContentSources").removeAll(this.imageContentSources);
        }
        if (imageContentSources != null) {
            this.imageContentSources = new ArrayList();
            for (ImageContentSource item : imageContentSources) {
                this.addToImageContentSources(item);
            }
        } else {
            this.imageContentSources = null;
        }
        return (A)this;
    }

    @Override
    public A withImageContentSources(ImageContentSource ... imageContentSources) {
        if (this.imageContentSources != null) {
            this.imageContentSources.clear();
        }
        if (imageContentSources != null) {
            for (ImageContentSource item : imageContentSources) {
                this.addToImageContentSources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImageContentSources() {
        return this.imageContentSources != null && !this.imageContentSources.isEmpty();
    }

    @Override
    public InstallConfigFluent.ImageContentSourcesNested<A> addNewImageContentSource() {
        return new ImageContentSourcesNestedImpl();
    }

    @Override
    public InstallConfigFluent.ImageContentSourcesNested<A> addNewImageContentSourceLike(ImageContentSource item) {
        return new ImageContentSourcesNestedImpl(-1, item);
    }

    @Override
    public InstallConfigFluent.ImageContentSourcesNested<A> setNewImageContentSourceLike(Integer index, ImageContentSource item) {
        return new ImageContentSourcesNestedImpl(index, item);
    }

    @Override
    public InstallConfigFluent.ImageContentSourcesNested<A> editImageContentSource(Integer index) {
        if (this.imageContentSources.size() <= index) {
            throw new RuntimeException("Can't edit imageContentSources. Index exceeds size.");
        }
        return this.setNewImageContentSourceLike(index, this.buildImageContentSource(index));
    }

    @Override
    public InstallConfigFluent.ImageContentSourcesNested<A> editFirstImageContentSource() {
        if (this.imageContentSources.size() == 0) {
            throw new RuntimeException("Can't edit first imageContentSources. The list is empty.");
        }
        return this.setNewImageContentSourceLike(0, this.buildImageContentSource(0));
    }

    @Override
    public InstallConfigFluent.ImageContentSourcesNested<A> editLastImageContentSource() {
        int index = this.imageContentSources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imageContentSources. The list is empty.");
        }
        return this.setNewImageContentSourceLike(index, this.buildImageContentSource(index));
    }

    @Override
    public InstallConfigFluent.ImageContentSourcesNested<A> editMatchingImageContentSource(Predicate<ImageContentSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imageContentSources.size(); ++i) {
            if (!predicate.test(this.imageContentSources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imageContentSources. No match found.");
        }
        return this.setNewImageContentSourceLike(index, this.buildImageContentSource(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public InstallConfigFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public InstallConfigFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public InstallConfigFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public InstallConfigFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public InstallConfigFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public Networking getNetworking() {
        return this.networking != null ? this.networking.build() : null;
    }

    @Override
    public Networking buildNetworking() {
        return this.networking != null ? this.networking.build() : null;
    }

    @Override
    public A withNetworking(Networking networking) {
        this._visitables.get("networking").remove(this.networking);
        if (networking != null) {
            this.networking = new NetworkingBuilder(networking);
            this._visitables.get("networking").add(this.networking);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNetworking() {
        return this.networking != null;
    }

    @Override
    public InstallConfigFluent.NetworkingNested<A> withNewNetworking() {
        return new NetworkingNestedImpl();
    }

    @Override
    public InstallConfigFluent.NetworkingNested<A> withNewNetworkingLike(Networking item) {
        return new NetworkingNestedImpl(item);
    }

    @Override
    public InstallConfigFluent.NetworkingNested<A> editNetworking() {
        return this.withNewNetworkingLike(this.getNetworking());
    }

    @Override
    public InstallConfigFluent.NetworkingNested<A> editOrNewNetworking() {
        return this.withNewNetworkingLike(this.getNetworking() != null ? this.getNetworking() : new NetworkingBuilder().build());
    }

    @Override
    public InstallConfigFluent.NetworkingNested<A> editOrNewNetworkingLike(Networking item) {
        return this.withNewNetworkingLike(this.getNetworking() != null ? this.getNetworking() : item);
    }

    @Override
    @Deprecated
    public Platform getPlatform() {
        return this.platform != null ? this.platform.build() : null;
    }

    @Override
    public Platform buildPlatform() {
        return this.platform != null ? this.platform.build() : null;
    }

    @Override
    public A withPlatform(Platform platform) {
        this._visitables.get("platform").remove(this.platform);
        if (platform != null) {
            this.platform = new PlatformBuilder(platform);
            this._visitables.get("platform").add(this.platform);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPlatform() {
        return this.platform != null;
    }

    @Override
    public InstallConfigFluent.PlatformNested<A> withNewPlatform() {
        return new PlatformNestedImpl();
    }

    @Override
    public InstallConfigFluent.PlatformNested<A> withNewPlatformLike(Platform item) {
        return new PlatformNestedImpl(item);
    }

    @Override
    public InstallConfigFluent.PlatformNested<A> editPlatform() {
        return this.withNewPlatformLike(this.getPlatform());
    }

    @Override
    public InstallConfigFluent.PlatformNested<A> editOrNewPlatform() {
        return this.withNewPlatformLike(this.getPlatform() != null ? this.getPlatform() : new PlatformBuilder().build());
    }

    @Override
    public InstallConfigFluent.PlatformNested<A> editOrNewPlatformLike(Platform item) {
        return this.withNewPlatformLike(this.getPlatform() != null ? this.getPlatform() : item);
    }

    @Override
    @Deprecated
    public Proxy getProxy() {
        return this.proxy != null ? this.proxy.build() : null;
    }

    @Override
    public Proxy buildProxy() {
        return this.proxy != null ? this.proxy.build() : null;
    }

    @Override
    public A withProxy(Proxy proxy) {
        this._visitables.get("proxy").remove(this.proxy);
        if (proxy != null) {
            this.proxy = new ProxyBuilder(proxy);
            this._visitables.get("proxy").add(this.proxy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasProxy() {
        return this.proxy != null;
    }

    @Override
    public A withNewProxy(String httpProxy, String httpsProxy, String noProxy) {
        return this.withProxy(new Proxy(httpProxy, httpsProxy, noProxy));
    }

    @Override
    public InstallConfigFluent.ProxyNested<A> withNewProxy() {
        return new ProxyNestedImpl();
    }

    @Override
    public InstallConfigFluent.ProxyNested<A> withNewProxyLike(Proxy item) {
        return new ProxyNestedImpl(item);
    }

    @Override
    public InstallConfigFluent.ProxyNested<A> editProxy() {
        return this.withNewProxyLike(this.getProxy());
    }

    @Override
    public InstallConfigFluent.ProxyNested<A> editOrNewProxy() {
        return this.withNewProxyLike(this.getProxy() != null ? this.getProxy() : new ProxyBuilder().build());
    }

    @Override
    public InstallConfigFluent.ProxyNested<A> editOrNewProxyLike(Proxy item) {
        return this.withNewProxyLike(this.getProxy() != null ? this.getProxy() : item);
    }

    @Override
    public String getPublish() {
        return this.publish;
    }

    @Override
    public A withPublish(String publish) {
        this.publish = publish;
        return (A)this;
    }

    @Override
    public Boolean hasPublish() {
        return this.publish != null;
    }

    @Override
    public String getPullSecret() {
        return this.pullSecret;
    }

    @Override
    public A withPullSecret(String pullSecret) {
        this.pullSecret = pullSecret;
        return (A)this;
    }

    @Override
    public Boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    @Override
    public String getSshKey() {
        return this.sshKey;
    }

    @Override
    public A withSshKey(String sshKey) {
        this.sshKey = sshKey;
        return (A)this;
    }

    @Override
    public Boolean hasSshKey() {
        return this.sshKey != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstallConfigFluentImpl that = (InstallConfigFluentImpl)o;
        if (this.additionalTrustBundle != null ? !this.additionalTrustBundle.equals(that.additionalTrustBundle) : that.additionalTrustBundle != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.baseDomain != null ? !this.baseDomain.equals(that.baseDomain) : that.baseDomain != null) {
            return false;
        }
        if (this.bootstrapInPlace != null ? !this.bootstrapInPlace.equals(that.bootstrapInPlace) : that.bootstrapInPlace != null) {
            return false;
        }
        if (this.compute != null ? !this.compute.equals(that.compute) : that.compute != null) {
            return false;
        }
        if (this.controlPlane != null ? !this.controlPlane.equals(that.controlPlane) : that.controlPlane != null) {
            return false;
        }
        if (this.credentialsMode != null ? !this.credentialsMode.equals(that.credentialsMode) : that.credentialsMode != null) {
            return false;
        }
        if (this.fips != null ? !this.fips.equals(that.fips) : that.fips != null) {
            return false;
        }
        if (this.imageContentSources != null ? !this.imageContentSources.equals(that.imageContentSources) : that.imageContentSources != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.networking != null ? !this.networking.equals(that.networking) : that.networking != null) {
            return false;
        }
        if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) {
            return false;
        }
        if (this.proxy != null ? !this.proxy.equals(that.proxy) : that.proxy != null) {
            return false;
        }
        if (this.publish != null ? !this.publish.equals(that.publish) : that.publish != null) {
            return false;
        }
        if (this.pullSecret != null ? !this.pullSecret.equals(that.pullSecret) : that.pullSecret != null) {
            return false;
        }
        if (this.sshKey != null ? !this.sshKey.equals(that.sshKey) : that.sshKey != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.additionalTrustBundle, this.apiVersion, this.baseDomain, this.bootstrapInPlace, this.compute, this.controlPlane, this.credentialsMode, this.fips, this.imageContentSources, this.kind, this.metadata, this.networking, this.platform, this.proxy, this.publish, this.pullSecret, this.sshKey, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalTrustBundle != null) {
            sb.append("additionalTrustBundle:");
            sb.append(this.additionalTrustBundle + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.baseDomain != null) {
            sb.append("baseDomain:");
            sb.append(this.baseDomain + ",");
        }
        if (this.bootstrapInPlace != null) {
            sb.append("bootstrapInPlace:");
            sb.append(this.bootstrapInPlace + ",");
        }
        if (this.compute != null && !this.compute.isEmpty()) {
            sb.append("compute:");
            sb.append(this.compute + ",");
        }
        if (this.controlPlane != null) {
            sb.append("controlPlane:");
            sb.append(this.controlPlane + ",");
        }
        if (this.credentialsMode != null) {
            sb.append("credentialsMode:");
            sb.append(this.credentialsMode + ",");
        }
        if (this.fips != null) {
            sb.append("fips:");
            sb.append(this.fips + ",");
        }
        if (this.imageContentSources != null && !this.imageContentSources.isEmpty()) {
            sb.append("imageContentSources:");
            sb.append(this.imageContentSources + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.networking != null) {
            sb.append("networking:");
            sb.append(this.networking + ",");
        }
        if (this.platform != null) {
            sb.append("platform:");
            sb.append(this.platform + ",");
        }
        if (this.proxy != null) {
            sb.append("proxy:");
            sb.append(this.proxy + ",");
        }
        if (this.publish != null) {
            sb.append("publish:");
            sb.append(this.publish + ",");
        }
        if (this.pullSecret != null) {
            sb.append("pullSecret:");
            sb.append(this.pullSecret + ",");
        }
        if (this.sshKey != null) {
            sb.append("sshKey:");
            sb.append(this.sshKey + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withFips() {
        return this.withFips(true);
    }

    class ProxyNestedImpl<N>
    extends ProxyFluentImpl<InstallConfigFluent.ProxyNested<N>>
    implements InstallConfigFluent.ProxyNested<N>,
    Nested<N> {
        ProxyBuilder builder;

        ProxyNestedImpl(Proxy item) {
            this.builder = new ProxyBuilder(this, item);
        }

        ProxyNestedImpl() {
            this.builder = new ProxyBuilder(this);
        }

        @Override
        public N and() {
            return (N)InstallConfigFluentImpl.this.withProxy(this.builder.build());
        }

        @Override
        public N endProxy() {
            return this.and();
        }
    }

    class PlatformNestedImpl<N>
    extends PlatformFluentImpl<InstallConfigFluent.PlatformNested<N>>
    implements InstallConfigFluent.PlatformNested<N>,
    Nested<N> {
        PlatformBuilder builder;

        PlatformNestedImpl(Platform item) {
            this.builder = new PlatformBuilder(this, item);
        }

        PlatformNestedImpl() {
            this.builder = new PlatformBuilder(this);
        }

        @Override
        public N and() {
            return (N)InstallConfigFluentImpl.this.withPlatform(this.builder.build());
        }

        @Override
        public N endPlatform() {
            return this.and();
        }
    }

    class NetworkingNestedImpl<N>
    extends NetworkingFluentImpl<InstallConfigFluent.NetworkingNested<N>>
    implements InstallConfigFluent.NetworkingNested<N>,
    Nested<N> {
        NetworkingBuilder builder;

        NetworkingNestedImpl(Networking item) {
            this.builder = new NetworkingBuilder(this, item);
        }

        NetworkingNestedImpl() {
            this.builder = new NetworkingBuilder(this);
        }

        @Override
        public N and() {
            return (N)InstallConfigFluentImpl.this.withNetworking(this.builder.build());
        }

        @Override
        public N endNetworking() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<InstallConfigFluent.MetadataNested<N>>
    implements InstallConfigFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)InstallConfigFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    class ImageContentSourcesNestedImpl<N>
    extends ImageContentSourceFluentImpl<InstallConfigFluent.ImageContentSourcesNested<N>>
    implements InstallConfigFluent.ImageContentSourcesNested<N>,
    Nested<N> {
        ImageContentSourceBuilder builder;
        Integer index;

        ImageContentSourcesNestedImpl(Integer index, ImageContentSource item) {
            this.index = index;
            this.builder = new ImageContentSourceBuilder(this, item);
        }

        ImageContentSourcesNestedImpl() {
            this.index = -1;
            this.builder = new ImageContentSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)InstallConfigFluentImpl.this.setToImageContentSources(this.index, this.builder.build());
        }

        @Override
        public N endImageContentSource() {
            return this.and();
        }
    }

    class ControlPlaneNestedImpl<N>
    extends MachinePoolFluentImpl<InstallConfigFluent.ControlPlaneNested<N>>
    implements InstallConfigFluent.ControlPlaneNested<N>,
    Nested<N> {
        MachinePoolBuilder builder;

        ControlPlaneNestedImpl(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        ControlPlaneNestedImpl() {
            this.builder = new MachinePoolBuilder(this);
        }

        @Override
        public N and() {
            return (N)InstallConfigFluentImpl.this.withControlPlane(this.builder.build());
        }

        @Override
        public N endControlPlane() {
            return this.and();
        }
    }

    class ComputeNestedImpl<N>
    extends MachinePoolFluentImpl<InstallConfigFluent.ComputeNested<N>>
    implements InstallConfigFluent.ComputeNested<N>,
    Nested<N> {
        MachinePoolBuilder builder;
        Integer index;

        ComputeNestedImpl(Integer index, MachinePool item) {
            this.index = index;
            this.builder = new MachinePoolBuilder(this, item);
        }

        ComputeNestedImpl() {
            this.index = -1;
            this.builder = new MachinePoolBuilder(this);
        }

        @Override
        public N and() {
            return (N)InstallConfigFluentImpl.this.setToCompute(this.index, this.builder.build());
        }

        @Override
        public N endCompute() {
            return this.and();
        }
    }

    class BootstrapInPlaceNestedImpl<N>
    extends BootstrapInPlaceFluentImpl<InstallConfigFluent.BootstrapInPlaceNested<N>>
    implements InstallConfigFluent.BootstrapInPlaceNested<N>,
    Nested<N> {
        BootstrapInPlaceBuilder builder;

        BootstrapInPlaceNestedImpl(BootstrapInPlace item) {
            this.builder = new BootstrapInPlaceBuilder(this, item);
        }

        BootstrapInPlaceNestedImpl() {
            this.builder = new BootstrapInPlaceBuilder(this);
        }

        @Override
        public N and() {
            return (N)InstallConfigFluentImpl.this.withBootstrapInPlace(this.builder.build());
        }

        @Override
        public N endBootstrapInPlace() {
            return this.and();
        }
    }
}

