/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.openshift.api.model.v6_0.installer.gcp.v1.MachinePool;
import io.fabric8.openshift.api.model.v6_0.installer.gcp.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.v6_0.installer.gcp.v1.MachinePoolFluentImpl;
import io.fabric8.openshift.api.model.v6_0.installer.gcp.v1.Platform;
import io.fabric8.openshift.api.model.v6_0.installer.gcp.v1.PlatformFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PlatformFluentImpl<A extends PlatformFluent<A>>
extends BaseFluent<A>
implements PlatformFluent<A> {
    private String computeSubnet;
    private String controlPlaneSubnet;
    private MachinePoolBuilder defaultMachinePlatform;
    private List<String> licenses = new ArrayList<String>();
    private String network;
    private String projectID;
    private String region;
    private Map<String, Object> additionalProperties;

    public PlatformFluentImpl() {
    }

    public PlatformFluentImpl(Platform instance) {
        this.withComputeSubnet(instance.getComputeSubnet());
        this.withControlPlaneSubnet(instance.getControlPlaneSubnet());
        this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
        this.withLicenses(instance.getLicenses());
        this.withNetwork(instance.getNetwork());
        this.withProjectID(instance.getProjectID());
        this.withRegion(instance.getRegion());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getComputeSubnet() {
        return this.computeSubnet;
    }

    @Override
    public A withComputeSubnet(String computeSubnet) {
        this.computeSubnet = computeSubnet;
        return (A)this;
    }

    @Override
    public Boolean hasComputeSubnet() {
        return this.computeSubnet != null;
    }

    @Override
    public String getControlPlaneSubnet() {
        return this.controlPlaneSubnet;
    }

    @Override
    public A withControlPlaneSubnet(String controlPlaneSubnet) {
        this.controlPlaneSubnet = controlPlaneSubnet;
        return (A)this;
    }

    @Override
    public Boolean hasControlPlaneSubnet() {
        return this.controlPlaneSubnet != null;
    }

    @Override
    @Deprecated
    public MachinePool getDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNestedImpl();
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNestedImpl(item);
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : new MachinePoolBuilder().build());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : item);
    }

    @Override
    public A addToLicenses(Integer index, String item) {
        if (this.licenses == null) {
            this.licenses = new ArrayList<String>();
        }
        this.licenses.add(index, item);
        return (A)this;
    }

    @Override
    public A setToLicenses(Integer index, String item) {
        if (this.licenses == null) {
            this.licenses = new ArrayList<String>();
        }
        this.licenses.set(index, item);
        return (A)this;
    }

    @Override
    public A addToLicenses(String ... items) {
        if (this.licenses == null) {
            this.licenses = new ArrayList<String>();
        }
        for (String item : items) {
            this.licenses.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToLicenses(Collection<String> items) {
        if (this.licenses == null) {
            this.licenses = new ArrayList<String>();
        }
        for (String item : items) {
            this.licenses.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromLicenses(String ... items) {
        for (String item : items) {
            if (this.licenses == null) continue;
            this.licenses.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLicenses(Collection<String> items) {
        for (String item : items) {
            if (this.licenses == null) continue;
            this.licenses.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getLicenses() {
        return this.licenses;
    }

    @Override
    public String getLicense(Integer index) {
        return this.licenses.get(index);
    }

    @Override
    public String getFirstLicense() {
        return this.licenses.get(0);
    }

    @Override
    public String getLastLicense() {
        return this.licenses.get(this.licenses.size() - 1);
    }

    @Override
    public String getMatchingLicense(Predicate<String> predicate) {
        for (String item : this.licenses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingLicense(Predicate<String> predicate) {
        for (String item : this.licenses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withLicenses(List<String> licenses) {
        if (licenses != null) {
            this.licenses = new ArrayList<String>();
            for (String item : licenses) {
                this.addToLicenses(item);
            }
        } else {
            this.licenses = null;
        }
        return (A)this;
    }

    @Override
    public A withLicenses(String ... licenses) {
        if (this.licenses != null) {
            this.licenses.clear();
        }
        if (licenses != null) {
            for (String item : licenses) {
                this.addToLicenses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLicenses() {
        return this.licenses != null && !this.licenses.isEmpty();
    }

    @Override
    public String getNetwork() {
        return this.network;
    }

    @Override
    public A withNetwork(String network) {
        this.network = network;
        return (A)this;
    }

    @Override
    public Boolean hasNetwork() {
        return this.network != null;
    }

    @Override
    public String getProjectID() {
        return this.projectID;
    }

    @Override
    public A withProjectID(String projectID) {
        this.projectID = projectID;
        return (A)this;
    }

    @Override
    public Boolean hasProjectID() {
        return this.projectID != null;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    @Override
    public Boolean hasRegion() {
        return this.region != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformFluentImpl that = (PlatformFluentImpl)o;
        if (this.computeSubnet != null ? !this.computeSubnet.equals(that.computeSubnet) : that.computeSubnet != null) {
            return false;
        }
        if (this.controlPlaneSubnet != null ? !this.controlPlaneSubnet.equals(that.controlPlaneSubnet) : that.controlPlaneSubnet != null) {
            return false;
        }
        if (this.defaultMachinePlatform != null ? !this.defaultMachinePlatform.equals(that.defaultMachinePlatform) : that.defaultMachinePlatform != null) {
            return false;
        }
        if (this.licenses != null ? !this.licenses.equals(that.licenses) : that.licenses != null) {
            return false;
        }
        if (this.network != null ? !this.network.equals(that.network) : that.network != null) {
            return false;
        }
        if (this.projectID != null ? !this.projectID.equals(that.projectID) : that.projectID != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(that.region) : that.region != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.computeSubnet, this.controlPlaneSubnet, this.defaultMachinePlatform, this.licenses, this.network, this.projectID, this.region, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.computeSubnet != null) {
            sb.append("computeSubnet:");
            sb.append(this.computeSubnet + ",");
        }
        if (this.controlPlaneSubnet != null) {
            sb.append("controlPlaneSubnet:");
            sb.append(this.controlPlaneSubnet + ",");
        }
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append(this.defaultMachinePlatform + ",");
        }
        if (this.licenses != null && !this.licenses.isEmpty()) {
            sb.append("licenses:");
            sb.append(this.licenses + ",");
        }
        if (this.network != null) {
            sb.append("network:");
            sb.append(this.network + ",");
        }
        if (this.projectID != null) {
            sb.append("projectID:");
            sb.append(this.projectID + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class DefaultMachinePlatformNestedImpl<N>
    extends MachinePoolFluentImpl<PlatformFluent.DefaultMachinePlatformNested<N>>
    implements PlatformFluent.DefaultMachinePlatformNested<N>,
    Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNestedImpl(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        DefaultMachinePlatformNestedImpl() {
            this.builder = new MachinePoolBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlatformFluentImpl.this.withDefaultMachinePlatform(this.builder.build());
        }

        @Override
        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

