/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0.hive.v1;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.openshift.api.model.v6_0.hive.v1.AWSDNSZoneStatus;
import io.fabric8.openshift.api.model.v6_0.hive.v1.AWSDNSZoneStatusBuilder;
import io.fabric8.openshift.api.model.v6_0.hive.v1.AWSDNSZoneStatusFluentImpl;
import io.fabric8.openshift.api.model.v6_0.hive.v1.AzureDNSZoneStatus;
import io.fabric8.openshift.api.model.v6_0.hive.v1.AzureDNSZoneStatusBuilder;
import io.fabric8.openshift.api.model.v6_0.hive.v1.AzureDNSZoneStatusFluentImpl;
import io.fabric8.openshift.api.model.v6_0.hive.v1.DNSZoneCondition;
import io.fabric8.openshift.api.model.v6_0.hive.v1.DNSZoneConditionBuilder;
import io.fabric8.openshift.api.model.v6_0.hive.v1.DNSZoneConditionFluentImpl;
import io.fabric8.openshift.api.model.v6_0.hive.v1.DNSZoneStatus;
import io.fabric8.openshift.api.model.v6_0.hive.v1.DNSZoneStatusFluent;
import io.fabric8.openshift.api.model.v6_0.hive.v1.GCPDNSZoneStatus;
import io.fabric8.openshift.api.model.v6_0.hive.v1.GCPDNSZoneStatusBuilder;
import io.fabric8.openshift.api.model.v6_0.hive.v1.GCPDNSZoneStatusFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DNSZoneStatusFluentImpl<A extends DNSZoneStatusFluent<A>>
extends BaseFluent<A>
implements DNSZoneStatusFluent<A> {
    private AWSDNSZoneStatusBuilder aws;
    private AzureDNSZoneStatusBuilder azure;
    private ArrayList<DNSZoneConditionBuilder> conditions = new ArrayList();
    private GCPDNSZoneStatusBuilder gcp;
    private Long lastSyncGeneration;
    private String lastSyncTimestamp;
    private List<String> nameServers = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public DNSZoneStatusFluentImpl() {
    }

    public DNSZoneStatusFluentImpl(DNSZoneStatus instance) {
        this.withAws(instance.getAws());
        this.withAzure(instance.getAzure());
        this.withConditions(instance.getConditions());
        this.withGcp(instance.getGcp());
        this.withLastSyncGeneration(instance.getLastSyncGeneration());
        this.withLastSyncTimestamp(instance.getLastSyncTimestamp());
        this.withNameServers(instance.getNameServers());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public AWSDNSZoneStatus getAws() {
        return this.aws != null ? this.aws.build() : null;
    }

    @Override
    public AWSDNSZoneStatus buildAws() {
        return this.aws != null ? this.aws.build() : null;
    }

    @Override
    public A withAws(AWSDNSZoneStatus aws) {
        this._visitables.get("aws").remove(this.aws);
        if (aws != null) {
            this.aws = new AWSDNSZoneStatusBuilder(aws);
            this._visitables.get("aws").add(this.aws);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAws() {
        return this.aws != null;
    }

    @Override
    public A withNewAws(String zoneID) {
        return this.withAws(new AWSDNSZoneStatus(zoneID));
    }

    @Override
    public DNSZoneStatusFluent.AwsNested<A> withNewAws() {
        return new AwsNestedImpl();
    }

    @Override
    public DNSZoneStatusFluent.AwsNested<A> withNewAwsLike(AWSDNSZoneStatus item) {
        return new AwsNestedImpl(item);
    }

    @Override
    public DNSZoneStatusFluent.AwsNested<A> editAws() {
        return this.withNewAwsLike(this.getAws());
    }

    @Override
    public DNSZoneStatusFluent.AwsNested<A> editOrNewAws() {
        return this.withNewAwsLike(this.getAws() != null ? this.getAws() : new AWSDNSZoneStatusBuilder().build());
    }

    @Override
    public DNSZoneStatusFluent.AwsNested<A> editOrNewAwsLike(AWSDNSZoneStatus item) {
        return this.withNewAwsLike(this.getAws() != null ? this.getAws() : item);
    }

    @Override
    @Deprecated
    public AzureDNSZoneStatus getAzure() {
        return this.azure != null ? this.azure.build() : null;
    }

    @Override
    public AzureDNSZoneStatus buildAzure() {
        return this.azure != null ? this.azure.build() : null;
    }

    @Override
    public A withAzure(AzureDNSZoneStatus azure) {
        this._visitables.get("azure").remove(this.azure);
        if (azure != null) {
            this.azure = new AzureDNSZoneStatusBuilder(azure);
            this._visitables.get("azure").add(this.azure);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAzure() {
        return this.azure != null;
    }

    @Override
    public DNSZoneStatusFluent.AzureNested<A> withNewAzure() {
        return new AzureNestedImpl();
    }

    @Override
    public DNSZoneStatusFluent.AzureNested<A> withNewAzureLike(AzureDNSZoneStatus item) {
        return new AzureNestedImpl(item);
    }

    @Override
    public DNSZoneStatusFluent.AzureNested<A> editAzure() {
        return this.withNewAzureLike(this.getAzure());
    }

    @Override
    public DNSZoneStatusFluent.AzureNested<A> editOrNewAzure() {
        return this.withNewAzureLike(this.getAzure() != null ? this.getAzure() : new AzureDNSZoneStatusBuilder().build());
    }

    @Override
    public DNSZoneStatusFluent.AzureNested<A> editOrNewAzureLike(AzureDNSZoneStatus item) {
        return this.withNewAzureLike(this.getAzure() != null ? this.getAzure() : item);
    }

    @Override
    public A addToConditions(Integer index, DNSZoneCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index.intValue() : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, DNSZoneCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(DNSZoneCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (DNSZoneCondition item : items) {
            DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<DNSZoneCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (DNSZoneCondition item : items) {
            DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(DNSZoneCondition ... items) {
        for (DNSZoneCondition item : items) {
            DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<DNSZoneCondition> items) {
        for (DNSZoneCondition item : items) {
            DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<DNSZoneConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<DNSZoneConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            DNSZoneConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<DNSZoneCondition> getConditions() {
        return this.conditions != null ? DNSZoneStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<DNSZoneCondition> buildConditions() {
        return this.conditions != null ? DNSZoneStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public DNSZoneCondition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public DNSZoneCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public DNSZoneCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public DNSZoneCondition buildMatchingCondition(Predicate<DNSZoneConditionBuilder> predicate) {
        for (DNSZoneConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<DNSZoneConditionBuilder> predicate) {
        for (DNSZoneConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<DNSZoneCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (DNSZoneCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(DNSZoneCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (DNSZoneCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public DNSZoneStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public DNSZoneStatusFluent.ConditionsNested<A> addNewConditionLike(DNSZoneCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public DNSZoneStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, DNSZoneCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public DNSZoneStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public DNSZoneStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public DNSZoneStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public DNSZoneStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<DNSZoneConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    @Deprecated
    public GCPDNSZoneStatus getGcp() {
        return this.gcp != null ? this.gcp.build() : null;
    }

    @Override
    public GCPDNSZoneStatus buildGcp() {
        return this.gcp != null ? this.gcp.build() : null;
    }

    @Override
    public A withGcp(GCPDNSZoneStatus gcp) {
        this._visitables.get("gcp").remove(this.gcp);
        if (gcp != null) {
            this.gcp = new GCPDNSZoneStatusBuilder(gcp);
            this._visitables.get("gcp").add(this.gcp);
        }
        return (A)this;
    }

    @Override
    public Boolean hasGcp() {
        return this.gcp != null;
    }

    @Override
    public A withNewGcp(String zoneName) {
        return this.withGcp(new GCPDNSZoneStatus(zoneName));
    }

    @Override
    public DNSZoneStatusFluent.GcpNested<A> withNewGcp() {
        return new GcpNestedImpl();
    }

    @Override
    public DNSZoneStatusFluent.GcpNested<A> withNewGcpLike(GCPDNSZoneStatus item) {
        return new GcpNestedImpl(item);
    }

    @Override
    public DNSZoneStatusFluent.GcpNested<A> editGcp() {
        return this.withNewGcpLike(this.getGcp());
    }

    @Override
    public DNSZoneStatusFluent.GcpNested<A> editOrNewGcp() {
        return this.withNewGcpLike(this.getGcp() != null ? this.getGcp() : new GCPDNSZoneStatusBuilder().build());
    }

    @Override
    public DNSZoneStatusFluent.GcpNested<A> editOrNewGcpLike(GCPDNSZoneStatus item) {
        return this.withNewGcpLike(this.getGcp() != null ? this.getGcp() : item);
    }

    @Override
    public Long getLastSyncGeneration() {
        return this.lastSyncGeneration;
    }

    @Override
    public A withLastSyncGeneration(Long lastSyncGeneration) {
        this.lastSyncGeneration = lastSyncGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasLastSyncGeneration() {
        return this.lastSyncGeneration != null;
    }

    @Override
    public String getLastSyncTimestamp() {
        return this.lastSyncTimestamp;
    }

    @Override
    public A withLastSyncTimestamp(String lastSyncTimestamp) {
        this.lastSyncTimestamp = lastSyncTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasLastSyncTimestamp() {
        return this.lastSyncTimestamp != null;
    }

    @Override
    public A addToNameServers(Integer index, String item) {
        if (this.nameServers == null) {
            this.nameServers = new ArrayList<String>();
        }
        this.nameServers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNameServers(Integer index, String item) {
        if (this.nameServers == null) {
            this.nameServers = new ArrayList<String>();
        }
        this.nameServers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNameServers(String ... items) {
        if (this.nameServers == null) {
            this.nameServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameServers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNameServers(Collection<String> items) {
        if (this.nameServers == null) {
            this.nameServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameServers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNameServers(String ... items) {
        for (String item : items) {
            if (this.nameServers == null) continue;
            this.nameServers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNameServers(Collection<String> items) {
        for (String item : items) {
            if (this.nameServers == null) continue;
            this.nameServers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNameServers() {
        return this.nameServers;
    }

    @Override
    public String getNameServer(Integer index) {
        return this.nameServers.get(index);
    }

    @Override
    public String getFirstNameServer() {
        return this.nameServers.get(0);
    }

    @Override
    public String getLastNameServer() {
        return this.nameServers.get(this.nameServers.size() - 1);
    }

    @Override
    public String getMatchingNameServer(Predicate<String> predicate) {
        for (String item : this.nameServers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNameServer(Predicate<String> predicate) {
        for (String item : this.nameServers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNameServers(List<String> nameServers) {
        if (nameServers != null) {
            this.nameServers = new ArrayList<String>();
            for (String item : nameServers) {
                this.addToNameServers(item);
            }
        } else {
            this.nameServers = null;
        }
        return (A)this;
    }

    @Override
    public A withNameServers(String ... nameServers) {
        if (this.nameServers != null) {
            this.nameServers.clear();
        }
        if (nameServers != null) {
            for (String item : nameServers) {
                this.addToNameServers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNameServers() {
        return this.nameServers != null && !this.nameServers.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DNSZoneStatusFluentImpl that = (DNSZoneStatusFluentImpl)o;
        if (this.aws != null ? !this.aws.equals(that.aws) : that.aws != null) {
            return false;
        }
        if (this.azure != null ? !this.azure.equals(that.azure) : that.azure != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.gcp != null ? !this.gcp.equals(that.gcp) : that.gcp != null) {
            return false;
        }
        if (this.lastSyncGeneration != null ? !this.lastSyncGeneration.equals(that.lastSyncGeneration) : that.lastSyncGeneration != null) {
            return false;
        }
        if (this.lastSyncTimestamp != null ? !this.lastSyncTimestamp.equals(that.lastSyncTimestamp) : that.lastSyncTimestamp != null) {
            return false;
        }
        if (this.nameServers != null ? !this.nameServers.equals(that.nameServers) : that.nameServers != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.aws, this.azure, this.conditions, this.gcp, this.lastSyncGeneration, this.lastSyncTimestamp, this.nameServers, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aws != null) {
            sb.append("aws:");
            sb.append(this.aws + ",");
        }
        if (this.azure != null) {
            sb.append("azure:");
            sb.append(this.azure + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.gcp != null) {
            sb.append("gcp:");
            sb.append(this.gcp + ",");
        }
        if (this.lastSyncGeneration != null) {
            sb.append("lastSyncGeneration:");
            sb.append(this.lastSyncGeneration + ",");
        }
        if (this.lastSyncTimestamp != null) {
            sb.append("lastSyncTimestamp:");
            sb.append(this.lastSyncTimestamp + ",");
        }
        if (this.nameServers != null && !this.nameServers.isEmpty()) {
            sb.append("nameServers:");
            sb.append(this.nameServers + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class GcpNestedImpl<N>
    extends GCPDNSZoneStatusFluentImpl<DNSZoneStatusFluent.GcpNested<N>>
    implements DNSZoneStatusFluent.GcpNested<N>,
    Nested<N> {
        GCPDNSZoneStatusBuilder builder;

        GcpNestedImpl(GCPDNSZoneStatus item) {
            this.builder = new GCPDNSZoneStatusBuilder(this, item);
        }

        GcpNestedImpl() {
            this.builder = new GCPDNSZoneStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)DNSZoneStatusFluentImpl.this.withGcp(this.builder.build());
        }

        @Override
        public N endGcp() {
            return this.and();
        }
    }

    class ConditionsNestedImpl<N>
    extends DNSZoneConditionFluentImpl<DNSZoneStatusFluent.ConditionsNested<N>>
    implements DNSZoneStatusFluent.ConditionsNested<N>,
    Nested<N> {
        DNSZoneConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, DNSZoneCondition item) {
            this.index = index;
            this.builder = new DNSZoneConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new DNSZoneConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)DNSZoneStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }

    class AzureNestedImpl<N>
    extends AzureDNSZoneStatusFluentImpl<DNSZoneStatusFluent.AzureNested<N>>
    implements DNSZoneStatusFluent.AzureNested<N>,
    Nested<N> {
        AzureDNSZoneStatusBuilder builder;

        AzureNestedImpl(AzureDNSZoneStatus item) {
            this.builder = new AzureDNSZoneStatusBuilder(this, item);
        }

        AzureNestedImpl() {
            this.builder = new AzureDNSZoneStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)DNSZoneStatusFluentImpl.this.withAzure(this.builder.build());
        }

        @Override
        public N endAzure() {
            return this.and();
        }
    }

    class AwsNestedImpl<N>
    extends AWSDNSZoneStatusFluentImpl<DNSZoneStatusFluent.AwsNested<N>>
    implements DNSZoneStatusFluent.AwsNested<N>,
    Nested<N> {
        AWSDNSZoneStatusBuilder builder;

        AwsNestedImpl(AWSDNSZoneStatus item) {
            this.builder = new AWSDNSZoneStatusBuilder(this, item);
        }

        AwsNestedImpl() {
            this.builder = new AWSDNSZoneStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)DNSZoneStatusFluentImpl.this.withAws(this.builder.build());
        }

        @Override
        public N endAws() {
            return this.and();
        }
    }
}

