/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0.hive.ovirt.v1;

import io.fabric8.kubernetes.api.builder.v6_0.VisitableBuilder;
import io.fabric8.openshift.api.model.v6_0.hive.ovirt.v1.Platform;
import io.fabric8.openshift.api.model.v6_0.hive.ovirt.v1.PlatformFluent;
import io.fabric8.openshift.api.model.v6_0.hive.ovirt.v1.PlatformFluentImpl;

public class PlatformBuilder
extends PlatformFluentImpl<PlatformBuilder>
implements VisitableBuilder<Platform, PlatformBuilder> {
    PlatformFluent<?> fluent;
    Boolean validationEnabled;

    public PlatformBuilder() {
        this(false);
    }

    public PlatformBuilder(Boolean validationEnabled) {
        this(new Platform(), validationEnabled);
    }

    public PlatformBuilder(PlatformFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public PlatformBuilder(PlatformFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Platform(), validationEnabled);
    }

    public PlatformBuilder(PlatformFluent<?> fluent, Platform instance) {
        this(fluent, instance, false);
    }

    public PlatformBuilder(PlatformFluent<?> fluent, Platform instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCertificatesSecretRef(instance.getCertificatesSecretRef());
        fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
        fluent.withOvirtClusterId(instance.getOvirtClusterId());
        fluent.withOvirtNetworkName(instance.getOvirtNetworkName());
        fluent.withStorageDomainId(instance.getStorageDomainId());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public PlatformBuilder(Platform instance) {
        this(instance, (Boolean)false);
    }

    public PlatformBuilder(Platform instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCertificatesSecretRef(instance.getCertificatesSecretRef());
        this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
        this.withOvirtClusterId(instance.getOvirtClusterId());
        this.withOvirtNetworkName(instance.getOvirtNetworkName());
        this.withStorageDomainId(instance.getStorageDomainId());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Platform build() {
        Platform buildable = new Platform(this.fluent.getCertificatesSecretRef(), this.fluent.getCredentialsSecretRef(), this.fluent.getOvirtClusterId(), this.fluent.getOvirtNetworkName(), this.fluent.getStorageDomainId());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

