/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.kubernetes.api.model.v6_0.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v6_0.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_0.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v6_0.hive.aws.v1.AssumeRole;
import io.fabric8.openshift.api.model.v6_0.hive.aws.v1.AssumeRoleBuilder;
import io.fabric8.openshift.api.model.v6_0.hive.aws.v1.AssumeRoleFluentImpl;
import io.fabric8.openshift.api.model.v6_0.hive.aws.v1.Platform;
import io.fabric8.openshift.api.model.v6_0.hive.aws.v1.PlatformFluent;
import io.fabric8.openshift.api.model.v6_0.hive.aws.v1.PrivateLinkAccess;
import io.fabric8.openshift.api.model.v6_0.hive.aws.v1.PrivateLinkAccessBuilder;
import io.fabric8.openshift.api.model.v6_0.hive.aws.v1.PrivateLinkAccessFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class PlatformFluentImpl<A extends PlatformFluent<A>>
extends BaseFluent<A>
implements PlatformFluent<A> {
    private AssumeRoleBuilder credentialsAssumeRole;
    private LocalObjectReferenceBuilder credentialsSecretRef;
    private PrivateLinkAccessBuilder privateLink;
    private String region;
    private Map<String, String> userTags;
    private Map<String, Object> additionalProperties;

    public PlatformFluentImpl() {
    }

    public PlatformFluentImpl(Platform instance) {
        this.withCredentialsAssumeRole(instance.getCredentialsAssumeRole());
        this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
        this.withPrivateLink(instance.getPrivateLink());
        this.withRegion(instance.getRegion());
        this.withUserTags(instance.getUserTags());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public AssumeRole getCredentialsAssumeRole() {
        return this.credentialsAssumeRole != null ? this.credentialsAssumeRole.build() : null;
    }

    @Override
    public AssumeRole buildCredentialsAssumeRole() {
        return this.credentialsAssumeRole != null ? this.credentialsAssumeRole.build() : null;
    }

    @Override
    public A withCredentialsAssumeRole(AssumeRole credentialsAssumeRole) {
        this._visitables.get("credentialsAssumeRole").remove(this.credentialsAssumeRole);
        if (credentialsAssumeRole != null) {
            this.credentialsAssumeRole = new AssumeRoleBuilder(credentialsAssumeRole);
            this._visitables.get("credentialsAssumeRole").add(this.credentialsAssumeRole);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCredentialsAssumeRole() {
        return this.credentialsAssumeRole != null;
    }

    @Override
    public A withNewCredentialsAssumeRole(String externalID, String roleARN) {
        return this.withCredentialsAssumeRole(new AssumeRole(externalID, roleARN));
    }

    @Override
    public PlatformFluent.CredentialsAssumeRoleNested<A> withNewCredentialsAssumeRole() {
        return new CredentialsAssumeRoleNestedImpl();
    }

    @Override
    public PlatformFluent.CredentialsAssumeRoleNested<A> withNewCredentialsAssumeRoleLike(AssumeRole item) {
        return new CredentialsAssumeRoleNestedImpl(item);
    }

    @Override
    public PlatformFluent.CredentialsAssumeRoleNested<A> editCredentialsAssumeRole() {
        return this.withNewCredentialsAssumeRoleLike(this.getCredentialsAssumeRole());
    }

    @Override
    public PlatformFluent.CredentialsAssumeRoleNested<A> editOrNewCredentialsAssumeRole() {
        return this.withNewCredentialsAssumeRoleLike(this.getCredentialsAssumeRole() != null ? this.getCredentialsAssumeRole() : new AssumeRoleBuilder().build());
    }

    @Override
    public PlatformFluent.CredentialsAssumeRoleNested<A> editOrNewCredentialsAssumeRoleLike(AssumeRole item) {
        return this.withNewCredentialsAssumeRoleLike(this.getCredentialsAssumeRole() != null ? this.getCredentialsAssumeRole() : item);
    }

    @Override
    @Deprecated
    public LocalObjectReference getCredentialsSecretRef() {
        return this.credentialsSecretRef != null ? this.credentialsSecretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildCredentialsSecretRef() {
        return this.credentialsSecretRef != null ? this.credentialsSecretRef.build() : null;
    }

    @Override
    public A withCredentialsSecretRef(LocalObjectReference credentialsSecretRef) {
        this._visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef);
        if (credentialsSecretRef != null) {
            this.credentialsSecretRef = new LocalObjectReferenceBuilder(credentialsSecretRef);
            this._visitables.get("credentialsSecretRef").add(this.credentialsSecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCredentialsSecretRef() {
        return this.credentialsSecretRef != null;
    }

    @Override
    public A withNewCredentialsSecretRef(String name) {
        return this.withCredentialsSecretRef(new LocalObjectReference(name));
    }

    @Override
    public PlatformFluent.CredentialsSecretRefNested<A> withNewCredentialsSecretRef() {
        return new CredentialsSecretRefNestedImpl();
    }

    @Override
    public PlatformFluent.CredentialsSecretRefNested<A> withNewCredentialsSecretRefLike(LocalObjectReference item) {
        return new CredentialsSecretRefNestedImpl(item);
    }

    @Override
    public PlatformFluent.CredentialsSecretRefNested<A> editCredentialsSecretRef() {
        return this.withNewCredentialsSecretRefLike(this.getCredentialsSecretRef());
    }

    @Override
    public PlatformFluent.CredentialsSecretRefNested<A> editOrNewCredentialsSecretRef() {
        return this.withNewCredentialsSecretRefLike(this.getCredentialsSecretRef() != null ? this.getCredentialsSecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public PlatformFluent.CredentialsSecretRefNested<A> editOrNewCredentialsSecretRefLike(LocalObjectReference item) {
        return this.withNewCredentialsSecretRefLike(this.getCredentialsSecretRef() != null ? this.getCredentialsSecretRef() : item);
    }

    @Override
    @Deprecated
    public PrivateLinkAccess getPrivateLink() {
        return this.privateLink != null ? this.privateLink.build() : null;
    }

    @Override
    public PrivateLinkAccess buildPrivateLink() {
        return this.privateLink != null ? this.privateLink.build() : null;
    }

    @Override
    public A withPrivateLink(PrivateLinkAccess privateLink) {
        this._visitables.get("privateLink").remove(this.privateLink);
        if (privateLink != null) {
            this.privateLink = new PrivateLinkAccessBuilder(privateLink);
            this._visitables.get("privateLink").add(this.privateLink);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPrivateLink() {
        return this.privateLink != null;
    }

    @Override
    public A withNewPrivateLink(Boolean enabled) {
        return this.withPrivateLink(new PrivateLinkAccess(enabled));
    }

    @Override
    public PlatformFluent.PrivateLinkNested<A> withNewPrivateLink() {
        return new PrivateLinkNestedImpl();
    }

    @Override
    public PlatformFluent.PrivateLinkNested<A> withNewPrivateLinkLike(PrivateLinkAccess item) {
        return new PrivateLinkNestedImpl(item);
    }

    @Override
    public PlatformFluent.PrivateLinkNested<A> editPrivateLink() {
        return this.withNewPrivateLinkLike(this.getPrivateLink());
    }

    @Override
    public PlatformFluent.PrivateLinkNested<A> editOrNewPrivateLink() {
        return this.withNewPrivateLinkLike(this.getPrivateLink() != null ? this.getPrivateLink() : new PrivateLinkAccessBuilder().build());
    }

    @Override
    public PlatformFluent.PrivateLinkNested<A> editOrNewPrivateLinkLike(PrivateLinkAccess item) {
        return this.withNewPrivateLinkLike(this.getPrivateLink() != null ? this.getPrivateLink() : item);
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    @Override
    public Boolean hasRegion() {
        return this.region != null;
    }

    @Override
    public A addToUserTags(String key, String value) {
        if (this.userTags == null && key != null && value != null) {
            this.userTags = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.userTags.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToUserTags(Map<String, String> map) {
        if (this.userTags == null && map != null) {
            this.userTags = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.userTags.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromUserTags(String key) {
        if (this.userTags == null) {
            return (A)this;
        }
        if (key != null && this.userTags != null) {
            this.userTags.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromUserTags(Map<String, String> map) {
        if (this.userTags == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.userTags == null) continue;
                this.userTags.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getUserTags() {
        return this.userTags;
    }

    @Override
    public <K, V> A withUserTags(Map<String, String> userTags) {
        this.userTags = userTags == null ? null : new LinkedHashMap<String, String>(userTags);
        return (A)this;
    }

    @Override
    public Boolean hasUserTags() {
        return this.userTags != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformFluentImpl that = (PlatformFluentImpl)o;
        if (this.credentialsAssumeRole != null ? !this.credentialsAssumeRole.equals(that.credentialsAssumeRole) : that.credentialsAssumeRole != null) {
            return false;
        }
        if (this.credentialsSecretRef != null ? !this.credentialsSecretRef.equals(that.credentialsSecretRef) : that.credentialsSecretRef != null) {
            return false;
        }
        if (this.privateLink != null ? !this.privateLink.equals(that.privateLink) : that.privateLink != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(that.region) : that.region != null) {
            return false;
        }
        if (this.userTags != null ? !this.userTags.equals(that.userTags) : that.userTags != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.credentialsAssumeRole, this.credentialsSecretRef, this.privateLink, this.region, this.userTags, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.credentialsAssumeRole != null) {
            sb.append("credentialsAssumeRole:");
            sb.append(this.credentialsAssumeRole + ",");
        }
        if (this.credentialsSecretRef != null) {
            sb.append("credentialsSecretRef:");
            sb.append(this.credentialsSecretRef + ",");
        }
        if (this.privateLink != null) {
            sb.append("privateLink:");
            sb.append(this.privateLink + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.userTags != null && !this.userTags.isEmpty()) {
            sb.append("userTags:");
            sb.append(this.userTags + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class PrivateLinkNestedImpl<N>
    extends PrivateLinkAccessFluentImpl<PlatformFluent.PrivateLinkNested<N>>
    implements PlatformFluent.PrivateLinkNested<N>,
    Nested<N> {
        PrivateLinkAccessBuilder builder;

        PrivateLinkNestedImpl(PrivateLinkAccess item) {
            this.builder = new PrivateLinkAccessBuilder(this, item);
        }

        PrivateLinkNestedImpl() {
            this.builder = new PrivateLinkAccessBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlatformFluentImpl.this.withPrivateLink(this.builder.build());
        }

        @Override
        public N endPrivateLink() {
            return this.and();
        }
    }

    class CredentialsSecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<PlatformFluent.CredentialsSecretRefNested<N>>
    implements PlatformFluent.CredentialsSecretRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        CredentialsSecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        CredentialsSecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlatformFluentImpl.this.withCredentialsSecretRef(this.builder.build());
        }

        @Override
        public N endCredentialsSecretRef() {
            return this.and();
        }
    }

    class CredentialsAssumeRoleNestedImpl<N>
    extends AssumeRoleFluentImpl<PlatformFluent.CredentialsAssumeRoleNested<N>>
    implements PlatformFluent.CredentialsAssumeRoleNested<N>,
    Nested<N> {
        AssumeRoleBuilder builder;

        CredentialsAssumeRoleNestedImpl(AssumeRole item) {
            this.builder = new AssumeRoleBuilder(this, item);
        }

        CredentialsAssumeRoleNestedImpl() {
            this.builder = new AssumeRoleBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlatformFluentImpl.this.withCredentialsAssumeRole(this.builder.build());
        }

        @Override
        public N endCredentialsAssumeRole() {
            return this.and();
        }
    }
}

