/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.kubernetes.api.model.v6_0.ObjectMeta;
import io.fabric8.kubernetes.api.model.v6_0.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v6_0.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v6_0.User;
import io.fabric8.openshift.api.model.v6_0.UserFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class UserFluentImpl<A extends UserFluent<A>>
extends BaseFluent<A>
implements UserFluent<A> {
    private String apiVersion;
    private String fullName;
    private List<String> groups = new ArrayList<String>();
    private List<String> identities = new ArrayList<String>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private Map<String, Object> additionalProperties;

    public UserFluentImpl() {
    }

    public UserFluentImpl(User instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withFullName(instance.getFullName());
        this.withGroups(instance.getGroups());
        this.withIdentities(instance.getIdentities());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public A withFullName(String fullName) {
        this.fullName = fullName;
        return (A)this;
    }

    @Override
    public Boolean hasFullName() {
        return this.fullName != null;
    }

    @Override
    public A addToGroups(Integer index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroups(Integer index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroups(String ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroups(Collection<String> items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroups(String ... items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroups(Collection<String> items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public String getGroup(Integer index) {
        return this.groups.get(index);
    }

    @Override
    public String getFirstGroup() {
        return this.groups.get(0);
    }

    @Override
    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    @Override
    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGroups(List<String> groups) {
        if (groups != null) {
            this.groups = new ArrayList<String>();
            for (String item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)this;
    }

    @Override
    public A withGroups(String ... groups) {
        if (this.groups != null) {
            this.groups.clear();
        }
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    @Override
    public A addToIdentities(Integer index, String item) {
        if (this.identities == null) {
            this.identities = new ArrayList<String>();
        }
        this.identities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToIdentities(Integer index, String item) {
        if (this.identities == null) {
            this.identities = new ArrayList<String>();
        }
        this.identities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToIdentities(String ... items) {
        if (this.identities == null) {
            this.identities = new ArrayList<String>();
        }
        for (String item : items) {
            this.identities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToIdentities(Collection<String> items) {
        if (this.identities == null) {
            this.identities = new ArrayList<String>();
        }
        for (String item : items) {
            this.identities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromIdentities(String ... items) {
        for (String item : items) {
            if (this.identities == null) continue;
            this.identities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIdentities(Collection<String> items) {
        for (String item : items) {
            if (this.identities == null) continue;
            this.identities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getIdentities() {
        return this.identities;
    }

    @Override
    public String getIdentity(Integer index) {
        return this.identities.get(index);
    }

    @Override
    public String getFirstIdentity() {
        return this.identities.get(0);
    }

    @Override
    public String getLastIdentity() {
        return this.identities.get(this.identities.size() - 1);
    }

    @Override
    public String getMatchingIdentity(Predicate<String> predicate) {
        for (String item : this.identities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIdentity(Predicate<String> predicate) {
        for (String item : this.identities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIdentities(List<String> identities) {
        if (identities != null) {
            this.identities = new ArrayList<String>();
            for (String item : identities) {
                this.addToIdentities(item);
            }
        } else {
            this.identities = null;
        }
        return (A)this;
    }

    @Override
    public A withIdentities(String ... identities) {
        if (this.identities != null) {
            this.identities.clear();
        }
        if (identities != null) {
            for (String item : identities) {
                this.addToIdentities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIdentities() {
        return this.identities != null && !this.identities.isEmpty();
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public UserFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public UserFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public UserFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public UserFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public UserFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserFluentImpl that = (UserFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.fullName != null ? !this.fullName.equals(that.fullName) : that.fullName != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.identities != null ? !this.identities.equals(that.identities) : that.identities != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.fullName, this.groups, this.identities, this.kind, this.metadata, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.fullName != null) {
            sb.append("fullName:");
            sb.append(this.fullName + ",");
        }
        if (this.groups != null && !this.groups.isEmpty()) {
            sb.append("groups:");
            sb.append(this.groups + ",");
        }
        if (this.identities != null && !this.identities.isEmpty()) {
            sb.append("identities:");
            sb.append(this.identities + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<UserFluent.MetadataNested<N>>
    implements UserFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)UserFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

