/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.kubernetes.api.model.v6_0.ObjectMeta;
import io.fabric8.kubernetes.api.model.v6_0.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v6_0.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v6_0.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.v6_0.OAuthClientAuthorizationFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OAuthClientAuthorizationFluentImpl<A extends OAuthClientAuthorizationFluent<A>>
extends BaseFluent<A>
implements OAuthClientAuthorizationFluent<A> {
    private String apiVersion;
    private String clientName;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<String> scopes = new ArrayList<String>();
    private String userName;
    private String userUID;
    private Map<String, Object> additionalProperties;

    public OAuthClientAuthorizationFluentImpl() {
    }

    public OAuthClientAuthorizationFluentImpl(OAuthClientAuthorization instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withClientName(instance.getClientName());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withScopes(instance.getScopes());
        this.withUserName(instance.getUserName());
        this.withUserUID(instance.getUserUID());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public A withClientName(String clientName) {
        this.clientName = clientName;
        return (A)this;
    }

    @Override
    public Boolean hasClientName() {
        return this.clientName != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public OAuthClientAuthorizationFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public OAuthClientAuthorizationFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public OAuthClientAuthorizationFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public OAuthClientAuthorizationFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public OAuthClientAuthorizationFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToScopes(Integer index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToScopes(Integer index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToScopes(String ... items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToScopes(Collection<String> items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromScopes(String ... items) {
        for (String item : items) {
            if (this.scopes == null) continue;
            this.scopes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromScopes(Collection<String> items) {
        for (String item : items) {
            if (this.scopes == null) continue;
            this.scopes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    public String getScope(Integer index) {
        return this.scopes.get(index);
    }

    @Override
    public String getFirstScope() {
        return this.scopes.get(0);
    }

    @Override
    public String getLastScope() {
        return this.scopes.get(this.scopes.size() - 1);
    }

    @Override
    public String getMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withScopes(List<String> scopes) {
        if (scopes != null) {
            this.scopes = new ArrayList<String>();
            for (String item : scopes) {
                this.addToScopes(item);
            }
        } else {
            this.scopes = null;
        }
        return (A)this;
    }

    @Override
    public A withScopes(String ... scopes) {
        if (this.scopes != null) {
            this.scopes.clear();
        }
        if (scopes != null) {
            for (String item : scopes) {
                this.addToScopes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasScopes() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public A withUserName(String userName) {
        this.userName = userName;
        return (A)this;
    }

    @Override
    public Boolean hasUserName() {
        return this.userName != null;
    }

    @Override
    public String getUserUID() {
        return this.userUID;
    }

    @Override
    public A withUserUID(String userUID) {
        this.userUID = userUID;
        return (A)this;
    }

    @Override
    public Boolean hasUserUID() {
        return this.userUID != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthClientAuthorizationFluentImpl that = (OAuthClientAuthorizationFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.clientName != null ? !this.clientName.equals(that.clientName) : that.clientName != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.scopes != null ? !this.scopes.equals(that.scopes) : that.scopes != null) {
            return false;
        }
        if (this.userName != null ? !this.userName.equals(that.userName) : that.userName != null) {
            return false;
        }
        if (this.userUID != null ? !this.userUID.equals(that.userUID) : that.userUID != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.clientName, this.kind, this.metadata, this.scopes, this.userName, this.userUID, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.clientName != null) {
            sb.append("clientName:");
            sb.append(this.clientName + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.scopes != null && !this.scopes.isEmpty()) {
            sb.append("scopes:");
            sb.append(this.scopes + ",");
        }
        if (this.userName != null) {
            sb.append("userName:");
            sb.append(this.userName + ",");
        }
        if (this.userUID != null) {
            sb.append("userUID:");
            sb.append(this.userUID + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<OAuthClientAuthorizationFluent.MetadataNested<N>>
    implements OAuthClientAuthorizationFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)OAuthClientAuthorizationFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

