/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0;

import io.fabric8.kubernetes.api.builder.v6_0.VisitableBuilder;
import io.fabric8.openshift.api.model.v6_0.OAuth;
import io.fabric8.openshift.api.model.v6_0.OAuthFluent;
import io.fabric8.openshift.api.model.v6_0.OAuthFluentImpl;

public class OAuthBuilder
extends OAuthFluentImpl<OAuthBuilder>
implements VisitableBuilder<OAuth, OAuthBuilder> {
    OAuthFluent<?> fluent;
    Boolean validationEnabled;

    public OAuthBuilder() {
        this(false);
    }

    public OAuthBuilder(Boolean validationEnabled) {
        this(new OAuth(), validationEnabled);
    }

    public OAuthBuilder(OAuthFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public OAuthBuilder(OAuthFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new OAuth(), validationEnabled);
    }

    public OAuthBuilder(OAuthFluent<?> fluent, OAuth instance) {
        this(fluent, instance, false);
    }

    public OAuthBuilder(OAuthFluent<?> fluent, OAuth instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public OAuthBuilder(OAuth instance) {
        this(instance, (Boolean)false);
    }

    public OAuthBuilder(OAuth instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public OAuth build() {
        OAuth buildable = new OAuth(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

