/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0;

import io.fabric8.kubernetes.api.builder.v6_0.VisitableBuilder;
import io.fabric8.openshift.api.model.v6_0.NetworkSpec;
import io.fabric8.openshift.api.model.v6_0.NetworkSpecFluent;
import io.fabric8.openshift.api.model.v6_0.NetworkSpecFluentImpl;

public class NetworkSpecBuilder
extends NetworkSpecFluentImpl<NetworkSpecBuilder>
implements VisitableBuilder<NetworkSpec, NetworkSpecBuilder> {
    NetworkSpecFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkSpecBuilder() {
        this(false);
    }

    public NetworkSpecBuilder(Boolean validationEnabled) {
        this(new NetworkSpec(), validationEnabled);
    }

    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkSpec(), validationEnabled);
    }

    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent, NetworkSpec instance) {
        this(fluent, instance, false);
    }

    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent, NetworkSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withClusterNetwork(instance.getClusterNetwork());
        fluent.withExternalIP(instance.getExternalIP());
        fluent.withNetworkType(instance.getNetworkType());
        fluent.withServiceNetwork(instance.getServiceNetwork());
        fluent.withServiceNodePortRange(instance.getServiceNodePortRange());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public NetworkSpecBuilder(NetworkSpec instance) {
        this(instance, (Boolean)false);
    }

    public NetworkSpecBuilder(NetworkSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withClusterNetwork(instance.getClusterNetwork());
        this.withExternalIP(instance.getExternalIP());
        this.withNetworkType(instance.getNetworkType());
        this.withServiceNetwork(instance.getServiceNetwork());
        this.withServiceNodePortRange(instance.getServiceNodePortRange());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NetworkSpec build() {
        NetworkSpec buildable = new NetworkSpec(this.fluent.getClusterNetwork(), this.fluent.getExternalIP(), this.fluent.getNetworkType(), this.fluent.getServiceNetwork(), this.fluent.getServiceNodePortRange());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

