/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0;

import io.fabric8.kubernetes.api.builder.v6_0.VisitableBuilder;
import io.fabric8.openshift.api.model.v6_0.InfrastructureSpec;
import io.fabric8.openshift.api.model.v6_0.InfrastructureSpecFluent;
import io.fabric8.openshift.api.model.v6_0.InfrastructureSpecFluentImpl;

public class InfrastructureSpecBuilder
extends InfrastructureSpecFluentImpl<InfrastructureSpecBuilder>
implements VisitableBuilder<InfrastructureSpec, InfrastructureSpecBuilder> {
    InfrastructureSpecFluent<?> fluent;
    Boolean validationEnabled;

    public InfrastructureSpecBuilder() {
        this(false);
    }

    public InfrastructureSpecBuilder(Boolean validationEnabled) {
        this(new InfrastructureSpec(), validationEnabled);
    }

    public InfrastructureSpecBuilder(InfrastructureSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public InfrastructureSpecBuilder(InfrastructureSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new InfrastructureSpec(), validationEnabled);
    }

    public InfrastructureSpecBuilder(InfrastructureSpecFluent<?> fluent, InfrastructureSpec instance) {
        this(fluent, instance, false);
    }

    public InfrastructureSpecBuilder(InfrastructureSpecFluent<?> fluent, InfrastructureSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCloudConfig(instance.getCloudConfig());
        fluent.withPlatformSpec(instance.getPlatformSpec());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public InfrastructureSpecBuilder(InfrastructureSpec instance) {
        this(instance, (Boolean)false);
    }

    public InfrastructureSpecBuilder(InfrastructureSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCloudConfig(instance.getCloudConfig());
        this.withPlatformSpec(instance.getPlatformSpec());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public InfrastructureSpec build() {
        InfrastructureSpec buildable = new InfrastructureSpec(this.fluent.getCloudConfig(), this.fluent.getPlatformSpec());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

