/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.openshift.api.model.v6_0.ImageStreamStatus;
import io.fabric8.openshift.api.model.v6_0.ImageStreamStatusFluent;
import io.fabric8.openshift.api.model.v6_0.NamedTagEventList;
import io.fabric8.openshift.api.model.v6_0.NamedTagEventListBuilder;
import io.fabric8.openshift.api.model.v6_0.NamedTagEventListFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ImageStreamStatusFluentImpl<A extends ImageStreamStatusFluent<A>>
extends BaseFluent<A>
implements ImageStreamStatusFluent<A> {
    private String dockerImageRepository;
    private String publicDockerImageRepository;
    private ArrayList<NamedTagEventListBuilder> tags = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ImageStreamStatusFluentImpl() {
    }

    public ImageStreamStatusFluentImpl(ImageStreamStatus instance) {
        this.withDockerImageRepository(instance.getDockerImageRepository());
        this.withPublicDockerImageRepository(instance.getPublicDockerImageRepository());
        this.withTags(instance.getTags());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getDockerImageRepository() {
        return this.dockerImageRepository;
    }

    @Override
    public A withDockerImageRepository(String dockerImageRepository) {
        this.dockerImageRepository = dockerImageRepository;
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageRepository() {
        return this.dockerImageRepository != null;
    }

    @Override
    public String getPublicDockerImageRepository() {
        return this.publicDockerImageRepository;
    }

    @Override
    public A withPublicDockerImageRepository(String publicDockerImageRepository) {
        this.publicDockerImageRepository = publicDockerImageRepository;
        return (A)this;
    }

    @Override
    public Boolean hasPublicDockerImageRepository() {
        return this.publicDockerImageRepository != null;
    }

    @Override
    public A addToTags(Integer index, NamedTagEventList item) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
        this._visitables.get("tags").add(index >= 0 ? index.intValue() : this._visitables.get("tags").size(), builder);
        this.tags.add(index >= 0 ? index.intValue() : this.tags.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTags(Integer index, NamedTagEventList item) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
        if (index < 0 || index >= this._visitables.get("tags").size()) {
            this._visitables.get("tags").add(builder);
        } else {
            this._visitables.get("tags").set(index, builder);
        }
        if (index < 0 || index >= this.tags.size()) {
            this.tags.add(builder);
        } else {
            this.tags.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTags(NamedTagEventList ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        for (NamedTagEventList item : items) {
            NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
            this._visitables.get("tags").add(builder);
            this.tags.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTags(Collection<NamedTagEventList> items) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        for (NamedTagEventList item : items) {
            NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
            this._visitables.get("tags").add(builder);
            this.tags.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTags(NamedTagEventList ... items) {
        for (NamedTagEventList item : items) {
            NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
            this._visitables.get("tags").remove(builder);
            if (this.tags == null) continue;
            this.tags.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTags(Collection<NamedTagEventList> items) {
        for (NamedTagEventList item : items) {
            NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
            this._visitables.get("tags").remove(builder);
            if (this.tags == null) continue;
            this.tags.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTags(Predicate<NamedTagEventListBuilder> predicate) {
        if (this.tags == null) {
            return (A)this;
        }
        Iterator<NamedTagEventListBuilder> each = this.tags.iterator();
        Object visitables = this._visitables.get("tags");
        while (each.hasNext()) {
            NamedTagEventListBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NamedTagEventList> getTags() {
        return this.tags != null ? ImageStreamStatusFluentImpl.build(this.tags) : null;
    }

    @Override
    public List<NamedTagEventList> buildTags() {
        return this.tags != null ? ImageStreamStatusFluentImpl.build(this.tags) : null;
    }

    @Override
    public NamedTagEventList buildTag(Integer index) {
        return this.tags.get(index).build();
    }

    @Override
    public NamedTagEventList buildFirstTag() {
        return this.tags.get(0).build();
    }

    @Override
    public NamedTagEventList buildLastTag() {
        return this.tags.get(this.tags.size() - 1).build();
    }

    @Override
    public NamedTagEventList buildMatchingTag(Predicate<NamedTagEventListBuilder> predicate) {
        for (NamedTagEventListBuilder item : this.tags) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTag(Predicate<NamedTagEventListBuilder> predicate) {
        for (NamedTagEventListBuilder item : this.tags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTags(List<NamedTagEventList> tags) {
        if (this.tags != null) {
            this._visitables.get("tags").removeAll(this.tags);
        }
        if (tags != null) {
            this.tags = new ArrayList();
            for (NamedTagEventList item : tags) {
                this.addToTags(item);
            }
        } else {
            this.tags = null;
        }
        return (A)this;
    }

    @Override
    public A withTags(NamedTagEventList ... tags) {
        if (this.tags != null) {
            this.tags.clear();
        }
        if (tags != null) {
            for (NamedTagEventList item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    @Override
    public ImageStreamStatusFluent.TagsNested<A> addNewTag() {
        return new TagsNestedImpl();
    }

    @Override
    public ImageStreamStatusFluent.TagsNested<A> addNewTagLike(NamedTagEventList item) {
        return new TagsNestedImpl(-1, item);
    }

    @Override
    public ImageStreamStatusFluent.TagsNested<A> setNewTagLike(Integer index, NamedTagEventList item) {
        return new TagsNestedImpl(index, item);
    }

    @Override
    public ImageStreamStatusFluent.TagsNested<A> editTag(Integer index) {
        if (this.tags.size() <= index) {
            throw new RuntimeException("Can't edit tags. Index exceeds size.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    @Override
    public ImageStreamStatusFluent.TagsNested<A> editFirstTag() {
        if (this.tags.size() == 0) {
            throw new RuntimeException("Can't edit first tags. The list is empty.");
        }
        return this.setNewTagLike(0, this.buildTag(0));
    }

    @Override
    public ImageStreamStatusFluent.TagsNested<A> editLastTag() {
        int index = this.tags.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tags. The list is empty.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    @Override
    public ImageStreamStatusFluent.TagsNested<A> editMatchingTag(Predicate<NamedTagEventListBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tags.size(); ++i) {
            if (!predicate.test(this.tags.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tags. No match found.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageStreamStatusFluentImpl that = (ImageStreamStatusFluentImpl)o;
        if (this.dockerImageRepository != null ? !this.dockerImageRepository.equals(that.dockerImageRepository) : that.dockerImageRepository != null) {
            return false;
        }
        if (this.publicDockerImageRepository != null ? !this.publicDockerImageRepository.equals(that.publicDockerImageRepository) : that.publicDockerImageRepository != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dockerImageRepository, this.publicDockerImageRepository, this.tags, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dockerImageRepository != null) {
            sb.append("dockerImageRepository:");
            sb.append(this.dockerImageRepository + ",");
        }
        if (this.publicDockerImageRepository != null) {
            sb.append("publicDockerImageRepository:");
            sb.append(this.publicDockerImageRepository + ",");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            sb.append("tags:");
            sb.append(this.tags + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class TagsNestedImpl<N>
    extends NamedTagEventListFluentImpl<ImageStreamStatusFluent.TagsNested<N>>
    implements ImageStreamStatusFluent.TagsNested<N>,
    Nested<N> {
        NamedTagEventListBuilder builder;
        Integer index;

        TagsNestedImpl(Integer index, NamedTagEventList item) {
            this.index = index;
            this.builder = new NamedTagEventListBuilder(this, item);
        }

        TagsNestedImpl() {
            this.index = -1;
            this.builder = new NamedTagEventListBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamStatusFluentImpl.this.setToTags(this.index, this.builder.build());
        }

        @Override
        public N endTag() {
            return this.and();
        }
    }
}

