/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.openshift.api.model.v6_0.ConfigMapNameReference;
import io.fabric8.openshift.api.model.v6_0.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.v6_0.ConfigMapNameReferenceFluentImpl;
import io.fabric8.openshift.api.model.v6_0.GitHubIdentityProvider;
import io.fabric8.openshift.api.model.v6_0.GitHubIdentityProviderFluent;
import io.fabric8.openshift.api.model.v6_0.SecretNameReference;
import io.fabric8.openshift.api.model.v6_0.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.v6_0.SecretNameReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GitHubIdentityProviderFluentImpl<A extends GitHubIdentityProviderFluent<A>>
extends BaseFluent<A>
implements GitHubIdentityProviderFluent<A> {
    private ConfigMapNameReferenceBuilder ca;
    private String clientID;
    private SecretNameReferenceBuilder clientSecret;
    private String hostname;
    private List<String> organizations = new ArrayList<String>();
    private List<String> teams = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public GitHubIdentityProviderFluentImpl() {
    }

    public GitHubIdentityProviderFluentImpl(GitHubIdentityProvider instance) {
        this.withCa(instance.getCa());
        this.withClientID(instance.getClientID());
        this.withClientSecret(instance.getClientSecret());
        this.withHostname(instance.getHostname());
        this.withOrganizations(instance.getOrganizations());
        this.withTeams(instance.getTeams());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public ConfigMapNameReference getCa() {
        return this.ca != null ? this.ca.build() : null;
    }

    @Override
    public ConfigMapNameReference buildCa() {
        return this.ca != null ? this.ca.build() : null;
    }

    @Override
    public A withCa(ConfigMapNameReference ca) {
        this._visitables.get("ca").remove(this.ca);
        if (ca != null) {
            this.ca = new ConfigMapNameReferenceBuilder(ca);
            this._visitables.get("ca").add(this.ca);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCa() {
        return this.ca != null;
    }

    @Override
    public A withNewCa(String name) {
        return this.withCa(new ConfigMapNameReference(name));
    }

    @Override
    public GitHubIdentityProviderFluent.CaNested<A> withNewCa() {
        return new CaNestedImpl();
    }

    @Override
    public GitHubIdentityProviderFluent.CaNested<A> withNewCaLike(ConfigMapNameReference item) {
        return new CaNestedImpl(item);
    }

    @Override
    public GitHubIdentityProviderFluent.CaNested<A> editCa() {
        return this.withNewCaLike(this.getCa());
    }

    @Override
    public GitHubIdentityProviderFluent.CaNested<A> editOrNewCa() {
        return this.withNewCaLike(this.getCa() != null ? this.getCa() : new ConfigMapNameReferenceBuilder().build());
    }

    @Override
    public GitHubIdentityProviderFluent.CaNested<A> editOrNewCaLike(ConfigMapNameReference item) {
        return this.withNewCaLike(this.getCa() != null ? this.getCa() : item);
    }

    @Override
    public String getClientID() {
        return this.clientID;
    }

    @Override
    public A withClientID(String clientID) {
        this.clientID = clientID;
        return (A)this;
    }

    @Override
    public Boolean hasClientID() {
        return this.clientID != null;
    }

    @Override
    @Deprecated
    public SecretNameReference getClientSecret() {
        return this.clientSecret != null ? this.clientSecret.build() : null;
    }

    @Override
    public SecretNameReference buildClientSecret() {
        return this.clientSecret != null ? this.clientSecret.build() : null;
    }

    @Override
    public A withClientSecret(SecretNameReference clientSecret) {
        this._visitables.get("clientSecret").remove(this.clientSecret);
        if (clientSecret != null) {
            this.clientSecret = new SecretNameReferenceBuilder(clientSecret);
            this._visitables.get("clientSecret").add(this.clientSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    @Override
    public A withNewClientSecret(String name) {
        return this.withClientSecret(new SecretNameReference(name));
    }

    @Override
    public GitHubIdentityProviderFluent.ClientSecretNested<A> withNewClientSecret() {
        return new ClientSecretNestedImpl();
    }

    @Override
    public GitHubIdentityProviderFluent.ClientSecretNested<A> withNewClientSecretLike(SecretNameReference item) {
        return new ClientSecretNestedImpl(item);
    }

    @Override
    public GitHubIdentityProviderFluent.ClientSecretNested<A> editClientSecret() {
        return this.withNewClientSecretLike(this.getClientSecret());
    }

    @Override
    public GitHubIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecret() {
        return this.withNewClientSecretLike(this.getClientSecret() != null ? this.getClientSecret() : new SecretNameReferenceBuilder().build());
    }

    @Override
    public GitHubIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecretLike(SecretNameReference item) {
        return this.withNewClientSecretLike(this.getClientSecret() != null ? this.getClientSecret() : item);
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    public A addToOrganizations(Integer index, String item) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        this.organizations.add(index, item);
        return (A)this;
    }

    @Override
    public A setToOrganizations(Integer index, String item) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        this.organizations.set(index, item);
        return (A)this;
    }

    @Override
    public A addToOrganizations(String ... items) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        for (String item : items) {
            this.organizations.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToOrganizations(Collection<String> items) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        for (String item : items) {
            this.organizations.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromOrganizations(String ... items) {
        for (String item : items) {
            if (this.organizations == null) continue;
            this.organizations.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOrganizations(Collection<String> items) {
        for (String item : items) {
            if (this.organizations == null) continue;
            this.organizations.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getOrganizations() {
        return this.organizations;
    }

    @Override
    public String getOrganization(Integer index) {
        return this.organizations.get(index);
    }

    @Override
    public String getFirstOrganization() {
        return this.organizations.get(0);
    }

    @Override
    public String getLastOrganization() {
        return this.organizations.get(this.organizations.size() - 1);
    }

    @Override
    public String getMatchingOrganization(Predicate<String> predicate) {
        for (String item : this.organizations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOrganization(Predicate<String> predicate) {
        for (String item : this.organizations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOrganizations(List<String> organizations) {
        if (organizations != null) {
            this.organizations = new ArrayList<String>();
            for (String item : organizations) {
                this.addToOrganizations(item);
            }
        } else {
            this.organizations = null;
        }
        return (A)this;
    }

    @Override
    public A withOrganizations(String ... organizations) {
        if (this.organizations != null) {
            this.organizations.clear();
        }
        if (organizations != null) {
            for (String item : organizations) {
                this.addToOrganizations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOrganizations() {
        return this.organizations != null && !this.organizations.isEmpty();
    }

    @Override
    public A addToTeams(Integer index, String item) {
        if (this.teams == null) {
            this.teams = new ArrayList<String>();
        }
        this.teams.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTeams(Integer index, String item) {
        if (this.teams == null) {
            this.teams = new ArrayList<String>();
        }
        this.teams.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTeams(String ... items) {
        if (this.teams == null) {
            this.teams = new ArrayList<String>();
        }
        for (String item : items) {
            this.teams.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTeams(Collection<String> items) {
        if (this.teams == null) {
            this.teams = new ArrayList<String>();
        }
        for (String item : items) {
            this.teams.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTeams(String ... items) {
        for (String item : items) {
            if (this.teams == null) continue;
            this.teams.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTeams(Collection<String> items) {
        for (String item : items) {
            if (this.teams == null) continue;
            this.teams.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getTeams() {
        return this.teams;
    }

    @Override
    public String getTeam(Integer index) {
        return this.teams.get(index);
    }

    @Override
    public String getFirstTeam() {
        return this.teams.get(0);
    }

    @Override
    public String getLastTeam() {
        return this.teams.get(this.teams.size() - 1);
    }

    @Override
    public String getMatchingTeam(Predicate<String> predicate) {
        for (String item : this.teams) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTeam(Predicate<String> predicate) {
        for (String item : this.teams) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTeams(List<String> teams) {
        if (teams != null) {
            this.teams = new ArrayList<String>();
            for (String item : teams) {
                this.addToTeams(item);
            }
        } else {
            this.teams = null;
        }
        return (A)this;
    }

    @Override
    public A withTeams(String ... teams) {
        if (this.teams != null) {
            this.teams.clear();
        }
        if (teams != null) {
            for (String item : teams) {
                this.addToTeams(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTeams() {
        return this.teams != null && !this.teams.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitHubIdentityProviderFluentImpl that = (GitHubIdentityProviderFluentImpl)o;
        if (this.ca != null ? !this.ca.equals(that.ca) : that.ca != null) {
            return false;
        }
        if (this.clientID != null ? !this.clientID.equals(that.clientID) : that.clientID != null) {
            return false;
        }
        if (this.clientSecret != null ? !this.clientSecret.equals(that.clientSecret) : that.clientSecret != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.organizations != null ? !this.organizations.equals(that.organizations) : that.organizations != null) {
            return false;
        }
        if (this.teams != null ? !this.teams.equals(that.teams) : that.teams != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ca, this.clientID, this.clientSecret, this.hostname, this.organizations, this.teams, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ca != null) {
            sb.append("ca:");
            sb.append(this.ca + ",");
        }
        if (this.clientID != null) {
            sb.append("clientID:");
            sb.append(this.clientID + ",");
        }
        if (this.clientSecret != null) {
            sb.append("clientSecret:");
            sb.append(this.clientSecret + ",");
        }
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.organizations != null && !this.organizations.isEmpty()) {
            sb.append("organizations:");
            sb.append(this.organizations + ",");
        }
        if (this.teams != null && !this.teams.isEmpty()) {
            sb.append("teams:");
            sb.append(this.teams + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ClientSecretNestedImpl<N>
    extends SecretNameReferenceFluentImpl<GitHubIdentityProviderFluent.ClientSecretNested<N>>
    implements GitHubIdentityProviderFluent.ClientSecretNested<N>,
    Nested<N> {
        SecretNameReferenceBuilder builder;

        ClientSecretNestedImpl(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        ClientSecretNestedImpl() {
            this.builder = new SecretNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)GitHubIdentityProviderFluentImpl.this.withClientSecret(this.builder.build());
        }

        @Override
        public N endClientSecret() {
            return this.and();
        }
    }

    class CaNestedImpl<N>
    extends ConfigMapNameReferenceFluentImpl<GitHubIdentityProviderFluent.CaNested<N>>
    implements GitHubIdentityProviderFluent.CaNested<N>,
    Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        CaNestedImpl(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        CaNestedImpl() {
            this.builder = new ConfigMapNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)GitHubIdentityProviderFluentImpl.this.withCa(this.builder.build());
        }

        @Override
        public N endCa() {
            return this.and();
        }
    }
}

