/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.openshift.api.model.v6_0.ComponentRouteSpec;
import io.fabric8.openshift.api.model.v6_0.ComponentRouteSpecFluent;
import io.fabric8.openshift.api.model.v6_0.SecretNameReference;
import io.fabric8.openshift.api.model.v6_0.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.v6_0.SecretNameReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ComponentRouteSpecFluentImpl<A extends ComponentRouteSpecFluent<A>>
extends BaseFluent<A>
implements ComponentRouteSpecFluent<A> {
    private String hostname;
    private String name;
    private String namespace;
    private SecretNameReferenceBuilder servingCertKeyPairSecret;
    private Map<String, Object> additionalProperties;

    public ComponentRouteSpecFluentImpl() {
    }

    public ComponentRouteSpecFluentImpl(ComponentRouteSpec instance) {
        this.withHostname(instance.getHostname());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withServingCertKeyPairSecret(instance.getServingCertKeyPairSecret());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    @Deprecated
    public SecretNameReference getServingCertKeyPairSecret() {
        return this.servingCertKeyPairSecret != null ? this.servingCertKeyPairSecret.build() : null;
    }

    @Override
    public SecretNameReference buildServingCertKeyPairSecret() {
        return this.servingCertKeyPairSecret != null ? this.servingCertKeyPairSecret.build() : null;
    }

    @Override
    public A withServingCertKeyPairSecret(SecretNameReference servingCertKeyPairSecret) {
        this._visitables.get("servingCertKeyPairSecret").remove(this.servingCertKeyPairSecret);
        if (servingCertKeyPairSecret != null) {
            this.servingCertKeyPairSecret = new SecretNameReferenceBuilder(servingCertKeyPairSecret);
            this._visitables.get("servingCertKeyPairSecret").add(this.servingCertKeyPairSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasServingCertKeyPairSecret() {
        return this.servingCertKeyPairSecret != null;
    }

    @Override
    public A withNewServingCertKeyPairSecret(String name) {
        return this.withServingCertKeyPairSecret(new SecretNameReference(name));
    }

    @Override
    public ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<A> withNewServingCertKeyPairSecret() {
        return new ServingCertKeyPairSecretNestedImpl();
    }

    @Override
    public ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<A> withNewServingCertKeyPairSecretLike(SecretNameReference item) {
        return new ServingCertKeyPairSecretNestedImpl(item);
    }

    @Override
    public ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<A> editServingCertKeyPairSecret() {
        return this.withNewServingCertKeyPairSecretLike(this.getServingCertKeyPairSecret());
    }

    @Override
    public ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<A> editOrNewServingCertKeyPairSecret() {
        return this.withNewServingCertKeyPairSecretLike(this.getServingCertKeyPairSecret() != null ? this.getServingCertKeyPairSecret() : new SecretNameReferenceBuilder().build());
    }

    @Override
    public ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<A> editOrNewServingCertKeyPairSecretLike(SecretNameReference item) {
        return this.withNewServingCertKeyPairSecretLike(this.getServingCertKeyPairSecret() != null ? this.getServingCertKeyPairSecret() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentRouteSpecFluentImpl that = (ComponentRouteSpecFluentImpl)o;
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.servingCertKeyPairSecret != null ? !this.servingCertKeyPairSecret.equals(that.servingCertKeyPairSecret) : that.servingCertKeyPairSecret != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hostname, this.name, this.namespace, this.servingCertKeyPairSecret, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.servingCertKeyPairSecret != null) {
            sb.append("servingCertKeyPairSecret:");
            sb.append(this.servingCertKeyPairSecret + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ServingCertKeyPairSecretNestedImpl<N>
    extends SecretNameReferenceFluentImpl<ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<N>>
    implements ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<N>,
    Nested<N> {
        SecretNameReferenceBuilder builder;

        ServingCertKeyPairSecretNestedImpl(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        ServingCertKeyPairSecretNestedImpl() {
            this.builder = new SecretNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentRouteSpecFluentImpl.this.withServingCertKeyPairSecret(this.builder.build());
        }

        @Override
        public N endServingCertKeyPairSecret() {
            return this.and();
        }
    }
}

