/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.kubernetes.api.model.v6_0.ObjectReference;
import io.fabric8.kubernetes.api.model.v6_0.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_0.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v6_0.BuildCondition;
import io.fabric8.openshift.api.model.v6_0.BuildConditionBuilder;
import io.fabric8.openshift.api.model.v6_0.BuildConditionFluentImpl;
import io.fabric8.openshift.api.model.v6_0.BuildStatus;
import io.fabric8.openshift.api.model.v6_0.BuildStatusFluent;
import io.fabric8.openshift.api.model.v6_0.BuildStatusOutput;
import io.fabric8.openshift.api.model.v6_0.BuildStatusOutputBuilder;
import io.fabric8.openshift.api.model.v6_0.BuildStatusOutputFluentImpl;
import io.fabric8.openshift.api.model.v6_0.StageInfo;
import io.fabric8.openshift.api.model.v6_0.StageInfoBuilder;
import io.fabric8.openshift.api.model.v6_0.StageInfoFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class BuildStatusFluentImpl<A extends BuildStatusFluent<A>>
extends BaseFluent<A>
implements BuildStatusFluent<A> {
    private Boolean cancelled;
    private String completionTimestamp;
    private ArrayList<BuildConditionBuilder> conditions = new ArrayList();
    private ObjectReferenceBuilder config;
    private Long duration;
    private String logSnippet;
    private String message;
    private BuildStatusOutputBuilder output;
    private String outputDockerImageReference;
    private String phase;
    private String reason;
    private ArrayList<StageInfoBuilder> stages = new ArrayList();
    private String startTimestamp;
    private Map<String, Object> additionalProperties;

    public BuildStatusFluentImpl() {
    }

    public BuildStatusFluentImpl(BuildStatus instance) {
        this.withCancelled(instance.getCancelled());
        this.withCompletionTimestamp(instance.getCompletionTimestamp());
        this.withConditions(instance.getConditions());
        this.withConfig(instance.getConfig());
        this.withDuration(instance.getDuration());
        this.withLogSnippet(instance.getLogSnippet());
        this.withMessage(instance.getMessage());
        this.withOutput(instance.getOutput());
        this.withOutputDockerImageReference(instance.getOutputDockerImageReference());
        this.withPhase(instance.getPhase());
        this.withReason(instance.getReason());
        this.withStages(instance.getStages());
        this.withStartTimestamp(instance.getStartTimestamp());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Boolean getCancelled() {
        return this.cancelled;
    }

    @Override
    public A withCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
        return (A)this;
    }

    @Override
    public Boolean hasCancelled() {
        return this.cancelled != null;
    }

    @Override
    public String getCompletionTimestamp() {
        return this.completionTimestamp;
    }

    @Override
    public A withCompletionTimestamp(String completionTimestamp) {
        this.completionTimestamp = completionTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasCompletionTimestamp() {
        return this.completionTimestamp != null;
    }

    @Override
    public A addToConditions(Integer index, BuildCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        BuildConditionBuilder builder = new BuildConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index.intValue() : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, BuildCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        BuildConditionBuilder builder = new BuildConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(BuildCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (BuildCondition item : items) {
            BuildConditionBuilder builder = new BuildConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<BuildCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (BuildCondition item : items) {
            BuildConditionBuilder builder = new BuildConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(BuildCondition ... items) {
        for (BuildCondition item : items) {
            BuildConditionBuilder builder = new BuildConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<BuildCondition> items) {
        for (BuildCondition item : items) {
            BuildConditionBuilder builder = new BuildConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<BuildConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<BuildConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            BuildConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BuildCondition> getConditions() {
        return this.conditions != null ? BuildStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<BuildCondition> buildConditions() {
        return this.conditions != null ? BuildStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public BuildCondition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public BuildCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public BuildCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public BuildCondition buildMatchingCondition(Predicate<BuildConditionBuilder> predicate) {
        for (BuildConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<BuildConditionBuilder> predicate) {
        for (BuildConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<BuildCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (BuildCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(BuildCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (BuildCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public BuildStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public BuildStatusFluent.ConditionsNested<A> addNewConditionLike(BuildCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public BuildStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, BuildCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public BuildStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public BuildStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public BuildStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public BuildStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<BuildConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    @Deprecated
    public ObjectReference getConfig() {
        return this.config != null ? this.config.build() : null;
    }

    @Override
    public ObjectReference buildConfig() {
        return this.config != null ? this.config.build() : null;
    }

    @Override
    public A withConfig(ObjectReference config) {
        this._visitables.get("config").remove(this.config);
        if (config != null) {
            this.config = new ObjectReferenceBuilder(config);
            this._visitables.get("config").add(this.config);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.config != null;
    }

    @Override
    public BuildStatusFluent.ConfigNested<A> withNewConfig() {
        return new ConfigNestedImpl();
    }

    @Override
    public BuildStatusFluent.ConfigNested<A> withNewConfigLike(ObjectReference item) {
        return new ConfigNestedImpl(item);
    }

    @Override
    public BuildStatusFluent.ConfigNested<A> editConfig() {
        return this.withNewConfigLike(this.getConfig());
    }

    @Override
    public BuildStatusFluent.ConfigNested<A> editOrNewConfig() {
        return this.withNewConfigLike(this.getConfig() != null ? this.getConfig() : new ObjectReferenceBuilder().build());
    }

    @Override
    public BuildStatusFluent.ConfigNested<A> editOrNewConfigLike(ObjectReference item) {
        return this.withNewConfigLike(this.getConfig() != null ? this.getConfig() : item);
    }

    @Override
    public Long getDuration() {
        return this.duration;
    }

    @Override
    public A withDuration(Long duration) {
        this.duration = duration;
        return (A)this;
    }

    @Override
    public Boolean hasDuration() {
        return this.duration != null;
    }

    @Override
    public String getLogSnippet() {
        return this.logSnippet;
    }

    @Override
    public A withLogSnippet(String logSnippet) {
        this.logSnippet = logSnippet;
        return (A)this;
    }

    @Override
    public Boolean hasLogSnippet() {
        return this.logSnippet != null;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    @Override
    public Boolean hasMessage() {
        return this.message != null;
    }

    @Override
    @Deprecated
    public BuildStatusOutput getOutput() {
        return this.output != null ? this.output.build() : null;
    }

    @Override
    public BuildStatusOutput buildOutput() {
        return this.output != null ? this.output.build() : null;
    }

    @Override
    public A withOutput(BuildStatusOutput output) {
        this._visitables.get("output").remove(this.output);
        if (output != null) {
            this.output = new BuildStatusOutputBuilder(output);
            this._visitables.get("output").add(this.output);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOutput() {
        return this.output != null;
    }

    @Override
    public BuildStatusFluent.OutputNested<A> withNewOutput() {
        return new OutputNestedImpl();
    }

    @Override
    public BuildStatusFluent.OutputNested<A> withNewOutputLike(BuildStatusOutput item) {
        return new OutputNestedImpl(item);
    }

    @Override
    public BuildStatusFluent.OutputNested<A> editOutput() {
        return this.withNewOutputLike(this.getOutput());
    }

    @Override
    public BuildStatusFluent.OutputNested<A> editOrNewOutput() {
        return this.withNewOutputLike(this.getOutput() != null ? this.getOutput() : new BuildStatusOutputBuilder().build());
    }

    @Override
    public BuildStatusFluent.OutputNested<A> editOrNewOutputLike(BuildStatusOutput item) {
        return this.withNewOutputLike(this.getOutput() != null ? this.getOutput() : item);
    }

    @Override
    public String getOutputDockerImageReference() {
        return this.outputDockerImageReference;
    }

    @Override
    public A withOutputDockerImageReference(String outputDockerImageReference) {
        this.outputDockerImageReference = outputDockerImageReference;
        return (A)this;
    }

    @Override
    public Boolean hasOutputDockerImageReference() {
        return this.outputDockerImageReference != null;
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    @Override
    public Boolean hasPhase() {
        return this.phase != null;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    @Override
    public Boolean hasReason() {
        return this.reason != null;
    }

    @Override
    public A addToStages(Integer index, StageInfo item) {
        if (this.stages == null) {
            this.stages = new ArrayList();
        }
        StageInfoBuilder builder = new StageInfoBuilder(item);
        this._visitables.get("stages").add(index >= 0 ? index.intValue() : this._visitables.get("stages").size(), builder);
        this.stages.add(index >= 0 ? index.intValue() : this.stages.size(), builder);
        return (A)this;
    }

    @Override
    public A setToStages(Integer index, StageInfo item) {
        if (this.stages == null) {
            this.stages = new ArrayList();
        }
        StageInfoBuilder builder = new StageInfoBuilder(item);
        if (index < 0 || index >= this._visitables.get("stages").size()) {
            this._visitables.get("stages").add(builder);
        } else {
            this._visitables.get("stages").set(index, builder);
        }
        if (index < 0 || index >= this.stages.size()) {
            this.stages.add(builder);
        } else {
            this.stages.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToStages(StageInfo ... items) {
        if (this.stages == null) {
            this.stages = new ArrayList();
        }
        for (StageInfo item : items) {
            StageInfoBuilder builder = new StageInfoBuilder(item);
            this._visitables.get("stages").add(builder);
            this.stages.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToStages(Collection<StageInfo> items) {
        if (this.stages == null) {
            this.stages = new ArrayList();
        }
        for (StageInfo item : items) {
            StageInfoBuilder builder = new StageInfoBuilder(item);
            this._visitables.get("stages").add(builder);
            this.stages.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromStages(StageInfo ... items) {
        for (StageInfo item : items) {
            StageInfoBuilder builder = new StageInfoBuilder(item);
            this._visitables.get("stages").remove(builder);
            if (this.stages == null) continue;
            this.stages.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromStages(Collection<StageInfo> items) {
        for (StageInfo item : items) {
            StageInfoBuilder builder = new StageInfoBuilder(item);
            this._visitables.get("stages").remove(builder);
            if (this.stages == null) continue;
            this.stages.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromStages(Predicate<StageInfoBuilder> predicate) {
        if (this.stages == null) {
            return (A)this;
        }
        Iterator<StageInfoBuilder> each = this.stages.iterator();
        Object visitables = this._visitables.get("stages");
        while (each.hasNext()) {
            StageInfoBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<StageInfo> getStages() {
        return this.stages != null ? BuildStatusFluentImpl.build(this.stages) : null;
    }

    @Override
    public List<StageInfo> buildStages() {
        return this.stages != null ? BuildStatusFluentImpl.build(this.stages) : null;
    }

    @Override
    public StageInfo buildStage(Integer index) {
        return this.stages.get(index).build();
    }

    @Override
    public StageInfo buildFirstStage() {
        return this.stages.get(0).build();
    }

    @Override
    public StageInfo buildLastStage() {
        return this.stages.get(this.stages.size() - 1).build();
    }

    @Override
    public StageInfo buildMatchingStage(Predicate<StageInfoBuilder> predicate) {
        for (StageInfoBuilder item : this.stages) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingStage(Predicate<StageInfoBuilder> predicate) {
        for (StageInfoBuilder item : this.stages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withStages(List<StageInfo> stages) {
        if (this.stages != null) {
            this._visitables.get("stages").removeAll(this.stages);
        }
        if (stages != null) {
            this.stages = new ArrayList();
            for (StageInfo item : stages) {
                this.addToStages(item);
            }
        } else {
            this.stages = null;
        }
        return (A)this;
    }

    @Override
    public A withStages(StageInfo ... stages) {
        if (this.stages != null) {
            this.stages.clear();
        }
        if (stages != null) {
            for (StageInfo item : stages) {
                this.addToStages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasStages() {
        return this.stages != null && !this.stages.isEmpty();
    }

    @Override
    public BuildStatusFluent.StagesNested<A> addNewStage() {
        return new StagesNestedImpl();
    }

    @Override
    public BuildStatusFluent.StagesNested<A> addNewStageLike(StageInfo item) {
        return new StagesNestedImpl(-1, item);
    }

    @Override
    public BuildStatusFluent.StagesNested<A> setNewStageLike(Integer index, StageInfo item) {
        return new StagesNestedImpl(index, item);
    }

    @Override
    public BuildStatusFluent.StagesNested<A> editStage(Integer index) {
        if (this.stages.size() <= index) {
            throw new RuntimeException("Can't edit stages. Index exceeds size.");
        }
        return this.setNewStageLike(index, this.buildStage(index));
    }

    @Override
    public BuildStatusFluent.StagesNested<A> editFirstStage() {
        if (this.stages.size() == 0) {
            throw new RuntimeException("Can't edit first stages. The list is empty.");
        }
        return this.setNewStageLike(0, this.buildStage(0));
    }

    @Override
    public BuildStatusFluent.StagesNested<A> editLastStage() {
        int index = this.stages.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last stages. The list is empty.");
        }
        return this.setNewStageLike(index, this.buildStage(index));
    }

    @Override
    public BuildStatusFluent.StagesNested<A> editMatchingStage(Predicate<StageInfoBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.stages.size(); ++i) {
            if (!predicate.test(this.stages.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching stages. No match found.");
        }
        return this.setNewStageLike(index, this.buildStage(index));
    }

    @Override
    public String getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public A withStartTimestamp(String startTimestamp) {
        this.startTimestamp = startTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasStartTimestamp() {
        return this.startTimestamp != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildStatusFluentImpl that = (BuildStatusFluentImpl)o;
        if (this.cancelled != null ? !this.cancelled.equals(that.cancelled) : that.cancelled != null) {
            return false;
        }
        if (this.completionTimestamp != null ? !this.completionTimestamp.equals(that.completionTimestamp) : that.completionTimestamp != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        if (this.duration != null ? !this.duration.equals(that.duration) : that.duration != null) {
            return false;
        }
        if (this.logSnippet != null ? !this.logSnippet.equals(that.logSnippet) : that.logSnippet != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.output != null ? !this.output.equals(that.output) : that.output != null) {
            return false;
        }
        if (this.outputDockerImageReference != null ? !this.outputDockerImageReference.equals(that.outputDockerImageReference) : that.outputDockerImageReference != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        if (this.stages != null ? !this.stages.equals(that.stages) : that.stages != null) {
            return false;
        }
        if (this.startTimestamp != null ? !this.startTimestamp.equals(that.startTimestamp) : that.startTimestamp != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cancelled, this.completionTimestamp, this.conditions, this.config, this.duration, this.logSnippet, this.message, this.output, this.outputDockerImageReference, this.phase, this.reason, this.stages, this.startTimestamp, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cancelled != null) {
            sb.append("cancelled:");
            sb.append(this.cancelled + ",");
        }
        if (this.completionTimestamp != null) {
            sb.append("completionTimestamp:");
            sb.append(this.completionTimestamp + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.config != null) {
            sb.append("config:");
            sb.append(this.config + ",");
        }
        if (this.duration != null) {
            sb.append("duration:");
            sb.append(this.duration + ",");
        }
        if (this.logSnippet != null) {
            sb.append("logSnippet:");
            sb.append(this.logSnippet + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.output != null) {
            sb.append("output:");
            sb.append(this.output + ",");
        }
        if (this.outputDockerImageReference != null) {
            sb.append("outputDockerImageReference:");
            sb.append(this.outputDockerImageReference + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason + ",");
        }
        if (this.stages != null && !this.stages.isEmpty()) {
            sb.append("stages:");
            sb.append(this.stages + ",");
        }
        if (this.startTimestamp != null) {
            sb.append("startTimestamp:");
            sb.append(this.startTimestamp + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withCancelled() {
        return this.withCancelled(true);
    }

    class StagesNestedImpl<N>
    extends StageInfoFluentImpl<BuildStatusFluent.StagesNested<N>>
    implements BuildStatusFluent.StagesNested<N>,
    Nested<N> {
        StageInfoBuilder builder;
        Integer index;

        StagesNestedImpl(Integer index, StageInfo item) {
            this.index = index;
            this.builder = new StageInfoBuilder(this, item);
        }

        StagesNestedImpl() {
            this.index = -1;
            this.builder = new StageInfoBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildStatusFluentImpl.this.setToStages(this.index, this.builder.build());
        }

        @Override
        public N endStage() {
            return this.and();
        }
    }

    class OutputNestedImpl<N>
    extends BuildStatusOutputFluentImpl<BuildStatusFluent.OutputNested<N>>
    implements BuildStatusFluent.OutputNested<N>,
    Nested<N> {
        BuildStatusOutputBuilder builder;

        OutputNestedImpl(BuildStatusOutput item) {
            this.builder = new BuildStatusOutputBuilder(this, item);
        }

        OutputNestedImpl() {
            this.builder = new BuildStatusOutputBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildStatusFluentImpl.this.withOutput(this.builder.build());
        }

        @Override
        public N endOutput() {
            return this.and();
        }
    }

    class ConfigNestedImpl<N>
    extends ObjectReferenceFluentImpl<BuildStatusFluent.ConfigNested<N>>
    implements BuildStatusFluent.ConfigNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        ConfigNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        ConfigNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildStatusFluentImpl.this.withConfig(this.builder.build());
        }

        @Override
        public N endConfig() {
            return this.and();
        }
    }

    class ConditionsNestedImpl<N>
    extends BuildConditionFluentImpl<BuildStatusFluent.ConditionsNested<N>>
    implements BuildStatusFluent.ConditionsNested<N>,
    Nested<N> {
        BuildConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, BuildCondition item) {
            this.index = index;
            this.builder = new BuildConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new BuildConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

