/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0;

import io.fabric8.kubernetes.api.builder.v6_0.VisitableBuilder;
import io.fabric8.openshift.api.model.v6_0.Build;
import io.fabric8.openshift.api.model.v6_0.BuildFluent;
import io.fabric8.openshift.api.model.v6_0.BuildFluentImpl;

public class BuildBuilder
extends BuildFluentImpl<BuildBuilder>
implements VisitableBuilder<Build, BuildBuilder> {
    BuildFluent<?> fluent;
    Boolean validationEnabled;

    public BuildBuilder() {
        this(false);
    }

    public BuildBuilder(Boolean validationEnabled) {
        this(new Build(), validationEnabled);
    }

    public BuildBuilder(BuildFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public BuildBuilder(BuildFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Build(), validationEnabled);
    }

    public BuildBuilder(BuildFluent<?> fluent, Build instance) {
        this(fluent, instance, false);
    }

    public BuildBuilder(BuildFluent<?> fluent, Build instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public BuildBuilder(Build instance) {
        this(instance, (Boolean)false);
    }

    public BuildBuilder(Build instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Build build() {
        Build buildable = new Build(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

