/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_0;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.kubernetes.api.model.v6_0.ObjectReference;
import io.fabric8.kubernetes.api.model.v6_0.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_0.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v6_0.BrokerTemplateInstanceSpec;
import io.fabric8.openshift.api.model.v6_0.BrokerTemplateInstanceSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class BrokerTemplateInstanceSpecFluentImpl<A extends BrokerTemplateInstanceSpecFluent<A>>
extends BaseFluent<A>
implements BrokerTemplateInstanceSpecFluent<A> {
    private List<String> bindingIDs = new ArrayList<String>();
    private ObjectReferenceBuilder secret;
    private ObjectReferenceBuilder templateInstance;
    private Map<String, Object> additionalProperties;

    public BrokerTemplateInstanceSpecFluentImpl() {
    }

    public BrokerTemplateInstanceSpecFluentImpl(BrokerTemplateInstanceSpec instance) {
        this.withBindingIDs(instance.getBindingIDs());
        this.withSecret(instance.getSecret());
        this.withTemplateInstance(instance.getTemplateInstance());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToBindingIDs(Integer index, String item) {
        if (this.bindingIDs == null) {
            this.bindingIDs = new ArrayList<String>();
        }
        this.bindingIDs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToBindingIDs(Integer index, String item) {
        if (this.bindingIDs == null) {
            this.bindingIDs = new ArrayList<String>();
        }
        this.bindingIDs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToBindingIDs(String ... items) {
        if (this.bindingIDs == null) {
            this.bindingIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.bindingIDs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToBindingIDs(Collection<String> items) {
        if (this.bindingIDs == null) {
            this.bindingIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.bindingIDs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromBindingIDs(String ... items) {
        for (String item : items) {
            if (this.bindingIDs == null) continue;
            this.bindingIDs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromBindingIDs(Collection<String> items) {
        for (String item : items) {
            if (this.bindingIDs == null) continue;
            this.bindingIDs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getBindingIDs() {
        return this.bindingIDs;
    }

    @Override
    public String getBindingID(Integer index) {
        return this.bindingIDs.get(index);
    }

    @Override
    public String getFirstBindingID() {
        return this.bindingIDs.get(0);
    }

    @Override
    public String getLastBindingID() {
        return this.bindingIDs.get(this.bindingIDs.size() - 1);
    }

    @Override
    public String getMatchingBindingID(Predicate<String> predicate) {
        for (String item : this.bindingIDs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingBindingID(Predicate<String> predicate) {
        for (String item : this.bindingIDs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withBindingIDs(List<String> bindingIDs) {
        if (bindingIDs != null) {
            this.bindingIDs = new ArrayList<String>();
            for (String item : bindingIDs) {
                this.addToBindingIDs(item);
            }
        } else {
            this.bindingIDs = null;
        }
        return (A)this;
    }

    @Override
    public A withBindingIDs(String ... bindingIDs) {
        if (this.bindingIDs != null) {
            this.bindingIDs.clear();
        }
        if (bindingIDs != null) {
            for (String item : bindingIDs) {
                this.addToBindingIDs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasBindingIDs() {
        return this.bindingIDs != null && !this.bindingIDs.isEmpty();
    }

    @Override
    @Deprecated
    public ObjectReference getSecret() {
        return this.secret != null ? this.secret.build() : null;
    }

    @Override
    public ObjectReference buildSecret() {
        return this.secret != null ? this.secret.build() : null;
    }

    @Override
    public A withSecret(ObjectReference secret) {
        this._visitables.get("secret").remove(this.secret);
        if (secret != null) {
            this.secret = new ObjectReferenceBuilder(secret);
            this._visitables.get("secret").add(this.secret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecret() {
        return this.secret != null;
    }

    @Override
    public BrokerTemplateInstanceSpecFluent.SecretNested<A> withNewSecret() {
        return new SecretNestedImpl();
    }

    @Override
    public BrokerTemplateInstanceSpecFluent.SecretNested<A> withNewSecretLike(ObjectReference item) {
        return new SecretNestedImpl(item);
    }

    @Override
    public BrokerTemplateInstanceSpecFluent.SecretNested<A> editSecret() {
        return this.withNewSecretLike(this.getSecret());
    }

    @Override
    public BrokerTemplateInstanceSpecFluent.SecretNested<A> editOrNewSecret() {
        return this.withNewSecretLike(this.getSecret() != null ? this.getSecret() : new ObjectReferenceBuilder().build());
    }

    @Override
    public BrokerTemplateInstanceSpecFluent.SecretNested<A> editOrNewSecretLike(ObjectReference item) {
        return this.withNewSecretLike(this.getSecret() != null ? this.getSecret() : item);
    }

    @Override
    @Deprecated
    public ObjectReference getTemplateInstance() {
        return this.templateInstance != null ? this.templateInstance.build() : null;
    }

    @Override
    public ObjectReference buildTemplateInstance() {
        return this.templateInstance != null ? this.templateInstance.build() : null;
    }

    @Override
    public A withTemplateInstance(ObjectReference templateInstance) {
        this._visitables.get("templateInstance").remove(this.templateInstance);
        if (templateInstance != null) {
            this.templateInstance = new ObjectReferenceBuilder(templateInstance);
            this._visitables.get("templateInstance").add(this.templateInstance);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplateInstance() {
        return this.templateInstance != null;
    }

    @Override
    public BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> withNewTemplateInstance() {
        return new TemplateInstanceNestedImpl();
    }

    @Override
    public BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> withNewTemplateInstanceLike(ObjectReference item) {
        return new TemplateInstanceNestedImpl(item);
    }

    @Override
    public BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> editTemplateInstance() {
        return this.withNewTemplateInstanceLike(this.getTemplateInstance());
    }

    @Override
    public BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> editOrNewTemplateInstance() {
        return this.withNewTemplateInstanceLike(this.getTemplateInstance() != null ? this.getTemplateInstance() : new ObjectReferenceBuilder().build());
    }

    @Override
    public BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> editOrNewTemplateInstanceLike(ObjectReference item) {
        return this.withNewTemplateInstanceLike(this.getTemplateInstance() != null ? this.getTemplateInstance() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerTemplateInstanceSpecFluentImpl that = (BrokerTemplateInstanceSpecFluentImpl)o;
        if (this.bindingIDs != null ? !this.bindingIDs.equals(that.bindingIDs) : that.bindingIDs != null) {
            return false;
        }
        if (this.secret != null ? !this.secret.equals(that.secret) : that.secret != null) {
            return false;
        }
        if (this.templateInstance != null ? !this.templateInstance.equals(that.templateInstance) : that.templateInstance != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.bindingIDs, this.secret, this.templateInstance, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bindingIDs != null && !this.bindingIDs.isEmpty()) {
            sb.append("bindingIDs:");
            sb.append(this.bindingIDs + ",");
        }
        if (this.secret != null) {
            sb.append("secret:");
            sb.append(this.secret + ",");
        }
        if (this.templateInstance != null) {
            sb.append("templateInstance:");
            sb.append(this.templateInstance + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class TemplateInstanceNestedImpl<N>
    extends ObjectReferenceFluentImpl<BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<N>>
    implements BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        TemplateInstanceNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        TemplateInstanceNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BrokerTemplateInstanceSpecFluentImpl.this.withTemplateInstance(this.builder.build());
        }

        @Override
        public N endTemplateInstance() {
            return this.and();
        }
    }

    class SecretNestedImpl<N>
    extends ObjectReferenceFluentImpl<BrokerTemplateInstanceSpecFluent.SecretNested<N>>
    implements BrokerTemplateInstanceSpecFluent.SecretNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        SecretNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        SecretNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BrokerTemplateInstanceSpecFluentImpl.this.withSecret(this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }
}

