/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_0.server.mock;

import io.fabric8.kubernetes.clnt.v6_0.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v6_0.server.mock.KubernetesCrudDispatcher;
import io.fabric8.kubernetes.clnt.v6_0.server.mock.Resetable;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.HttpMethod;
import io.fabric8.mockwebserver.internal.MockDispatcher;
import io.fabric8.mockwebserver.internal.SimpleRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;

public class KubernetesMixedDispatcher
extends Dispatcher
implements Resetable {
    private final Map<ServerRequest, Queue<ServerResponse>> responses;
    private final MockDispatcher mockDispatcher;
    private final KubernetesCrudDispatcher kubernetesCrudDispatcher;

    public KubernetesMixedDispatcher(Map<ServerRequest, Queue<ServerResponse>> responses) {
        this(responses, Collections.emptyList());
    }

    public KubernetesMixedDispatcher(Map<ServerRequest, Queue<ServerResponse>> responses, List<CustomResourceDefinitionContext> crdContexts) {
        this.responses = responses;
        this.mockDispatcher = new MockDispatcher(responses);
        this.kubernetesCrudDispatcher = new KubernetesCrudDispatcher(crdContexts);
    }

    public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
        Queue<ServerResponse> responseQueue = this.responses.get(new SimpleRequest(HttpMethod.valueOf((String)request.getMethod()), request.getPath()));
        if (responseQueue != null && !responseQueue.isEmpty()) {
            return this.mockDispatcher.dispatch(request);
        }
        return this.kubernetesCrudDispatcher.dispatch(request);
    }

    @Override
    public void reset() {
        this.kubernetesCrudDispatcher.reset();
    }
}

