/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_0.server.mock;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.api.model.v6_0.HasMetadata;
import io.fabric8.kubernetes.api.model.v6_0.Status;
import io.fabric8.kubernetes.api.model.v6_0.StatusBuilder;
import io.fabric8.kubernetes.api.model.v6_0.StatusCause;
import io.fabric8.kubernetes.api.model.v6_0.StatusCauseBuilder;
import io.fabric8.kubernetes.api.model.v6_0.StatusFluent;
import io.fabric8.kubernetes.clnt.v6_0.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v6_0.Watcher;
import io.fabric8.kubernetes.clnt.v6_0.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v6_0.dsl.base.PatchType;
import io.fabric8.kubernetes.clnt.v6_0.server.mock.CustomResourceDefinitionProcessor;
import io.fabric8.kubernetes.clnt.v6_0.server.mock.KubernetesAttributesExtractor;
import io.fabric8.kubernetes.clnt.v6_0.server.mock.KubernetesResponseComposer;
import io.fabric8.kubernetes.clnt.v6_0.server.mock.Resetable;
import io.fabric8.kubernetes.clnt.v6_0.server.mock.WatchEventsListener;
import io.fabric8.kubernetes.clnt.v6_0.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.clnt.v6_0.utils.Serialization;
import io.fabric8.kubernetes.clnt.v6_0.utils.Utils;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.crud.Attribute;
import io.fabric8.mockwebserver.crud.AttributeExtractor;
import io.fabric8.mockwebserver.crud.AttributeSet;
import io.fabric8.mockwebserver.crud.CrudDispatcher;
import io.fabric8.mockwebserver.crud.ResponseComposer;
import io.fabric8.zjsonpatch.JsonDiff;
import io.fabric8.zjsonpatch.JsonPatch;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import okhttp3.MediaType;
import okhttp3.WebSocketListener;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.mockwebserver.SocketPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCrudDispatcher
extends CrudDispatcher
implements Resetable {
    private static final String RESOURCE_VERSION = "resourceVersion";
    private static final String GENERATION = "generation";
    private static final String STATUS = "status";
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesCrudDispatcher.class);
    public static final int HTTP_UNPROCESSABLE_ENTITY = 422;
    private final Set<WatchEventsListener> watchEventListeners;
    private final CustomResourceDefinitionProcessor crdProcessor;
    private final KubernetesAttributesExtractor kubernetesAttributesExtractor;
    private final AtomicLong resourceVersion;
    private final KubernetesResponseComposer kubernetesResponseComposer;

    public KubernetesCrudDispatcher() {
        this(Collections.emptyList());
    }

    public KubernetesCrudDispatcher(List<CustomResourceDefinitionContext> crdContexts) {
        this(new KubernetesAttributesExtractor(crdContexts), new KubernetesResponseComposer());
    }

    public KubernetesCrudDispatcher(KubernetesAttributesExtractor attributeExtractor, KubernetesResponseComposer responseComposer) {
        super(new Context(Serialization.jsonMapper()), (AttributeExtractor)attributeExtractor, (ResponseComposer)responseComposer);
        this.kubernetesAttributesExtractor = attributeExtractor;
        this.kubernetesResponseComposer = responseComposer;
        this.watchEventListeners = new CopyOnWriteArraySet<WatchEventsListener>();
        this.crdProcessor = new CustomResourceDefinitionProcessor(this.kubernetesAttributesExtractor);
        this.resourceVersion = new AtomicLong();
    }

    public MockResponse handleCreate(String path, String s) {
        return this.validateRequestBodyAndHandleRequest(s, h -> this.doCreateOrModify(path, s, (HasMetadata)h, Watcher.Action.ADDED));
    }

    public MockResponse handleUpdate(String path, String s) {
        return this.validateRequestBodyAndHandleRequest(s, h -> this.doCreateOrModify(path, s, (HasMetadata)h, Watcher.Action.MODIFIED));
    }

    public MockResponse handleGet(String path) {
        if (this.detectWatchMode(path)) {
            return this.handleWatch(path);
        }
        return this.handle(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MockResponse handle(String path, EventProcessor eventProcessor) {
        MockResponse response = new MockResponse();
        ArrayList<String> items = new ArrayList<String>();
        AttributeSet query = this.attributeExtractor.fromPath(path);
        Map map = this.map;
        synchronized (map) {
            new ArrayList(this.map.entrySet()).stream().filter(entry -> ((AttributeSet)entry.getKey()).matches(query)).forEach(entry -> {
                LOGGER.debug("Entry found for query {} : {}", (Object)query, entry);
                items.add((String)entry.getValue());
                if (eventProcessor != null) {
                    eventProcessor.processEvent(path, query, (AttributeSet)entry.getKey());
                }
            });
        }
        if (query.containsKey("name")) {
            if (!items.isEmpty()) {
                response.setBody((String)items.get(0));
                response.setResponseCode(200);
            } else {
                response.setResponseCode(404);
            }
        } else {
            response.setBody(this.kubernetesResponseComposer.compose(items, String.valueOf(this.resourceVersion.get())));
            response.setResponseCode(200);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MockResponse handlePatch(RecordedRequest request) {
        Optional<Map.Entry> bodyEntry;
        String path = request.getPath();
        String requestBody = request.getBody().readUtf8();
        String contentType = request.getHeader("Content-Type");
        MockResponse response = new MockResponse();
        AttributeSet query = this.attributeExtractor.fromPath(path);
        Map map = this.map;
        synchronized (map) {
            bodyEntry = this.map.entrySet().stream().filter(entry -> ((AttributeSet)entry.getKey()).matches(query)).findFirst();
        }
        if (!bodyEntry.isPresent()) {
            response.setResponseCode(404);
        } else {
            String body = (String)bodyEntry.get().getValue();
            try {
                JsonNode updated;
                PatchType mergeType;
                JsonNode patch = this.context.getMapper().readTree(requestBody);
                JsonNode source = this.context.getMapper().readTree(body);
                JsonNode status = null;
                Map<String, String> pathValues = this.kubernetesAttributesExtractor.fromKubernetesPath(path);
                boolean statusSubresource = this.crdProcessor.isStatusSubresource(pathValues);
                if (statusSubresource && !KubernetesCrudDispatcher.isStatusPath(path)) {
                    status = this.removeStatus(source);
                }
                if (contentType == null) {
                    mergeType = PatchType.JSON;
                } else {
                    MediaType mediaType = MediaType.parse((String)contentType);
                    String subtype = mediaType.subtype();
                    if (subtype.equals(MediaType.get((String)PatchType.JSON.getContentType()).subtype())) {
                        mergeType = PatchType.JSON;
                    } else if (subtype.equals(MediaType.get((String)PatchType.JSON_MERGE.getContentType()).subtype())) {
                        mergeType = PatchType.JSON_MERGE;
                    } else {
                        response.setResponseCode(415);
                        return response;
                    }
                }
                if (mergeType == PatchType.JSON) {
                    updated = JsonPatch.apply((JsonNode)patch, (JsonNode)source);
                } else {
                    ObjectReader objectReader = this.context.getMapper().readerForUpdating((Object)source);
                    updated = (JsonNode)objectReader.readValue(requestBody);
                }
                if (KubernetesCrudDispatcher.isStatusPath(path)) {
                    status = this.removeStatus(updated);
                    updated = this.context.getMapper().readTree(body);
                }
                if (statusSubresource || KubernetesCrudDispatcher.isStatusPath(path)) {
                    if (status == null) {
                        this.removeStatus(updated);
                    } else {
                        ((ObjectNode)updated).set(STATUS, status);
                    }
                }
                this.setDefaultMetadata(updated, pathValues, source);
                String updatedAsString = Serialization.asJson((Object)updated);
                return this.validateRequestBodyAndHandleRequest(updatedAsString, h -> {
                    this.processEvent(path, query, (AttributeSet)((Map.Entry)bodyEntry.get()).getKey(), updatedAsString);
                    response.setResponseCode(202);
                    response.setBody(updatedAsString);
                    return response;
                });
            }
            catch (JsonProcessingException e) {
                response.setResponseCode(422);
            }
        }
        return response;
    }

    public MockResponse handleDelete(String path) {
        return this.handle(path, (p, a, o) -> this.processEvent(path, a, o, null));
    }

    public MockResponse handleWatch(String path) {
        MockResponse mockResponse = new MockResponse();
        String resourceName = this.fetchResourceNameFromWatchRequestPath(path);
        AttributeSet query = this.attributeExtractor.fromPath(path);
        if (resourceName != null) {
            query = query.add(new Attribute[]{new Attribute("name", resourceName)});
        }
        WatchEventsListener watchEventListener = new WatchEventsListener(this.context, query, this.watchEventListeners, LOGGER, watch -> {
            Map map = this.map;
            synchronized (map) {
                this.map.entrySet().stream().filter(entry -> watch.attributeMatches((AttributeSet)entry.getKey())).forEach(entry -> watch.sendWebSocketResponse((String)entry.getValue(), Watcher.Action.ADDED));
            }
        });
        this.watchEventListeners.add(watchEventListener);
        mockResponse.setSocketPolicy(SocketPolicy.KEEP_OPEN);
        return mockResponse.withWebSocketUpgrade((WebSocketListener)watchEventListener);
    }

    private boolean detectWatchMode(String path) {
        String queryString = null;
        try {
            queryString = new URI(path).getQuery();
        }
        catch (URISyntaxException e) {
            LOGGER.debug("incorrect URI string: [{}]", (Object)path);
            return false;
        }
        if (queryString != null && !queryString.isEmpty()) {
            return queryString.contains("watch=true");
        }
        return false;
    }

    private String fetchResourceNameFromWatchRequestPath(String path) {
        String queryString = null;
        try {
            queryString = new URI(path).getQuery();
        }
        catch (URISyntaxException e) {
            LOGGER.debug("Incorrect URI string: [{}]", (Object)path);
            return null;
        }
        if (queryString == null || queryString.isEmpty()) {
            return null;
        }
        String name = "";
        for (String q : queryString.split("&")) {
            if (!q.contains("fieldSelector") || !q.contains("metadata.name")) continue;
            String[] s = q.split("=");
            name = s[s.length - 1];
        }
        return name.isEmpty() ? null : name;
    }

    private void processEvent(String path, AttributeSet pathAttributes, AttributeSet oldAttributes, String newState) {
        String existing = (String)this.map.remove(oldAttributes);
        AttributeSet newAttributes = null;
        if (newState != null) {
            newAttributes = this.kubernetesAttributesExtractor.fromResource(newState);
            if (!newAttributes.containsKey("plural")) {
                newAttributes = AttributeSet.merge((AttributeSet[])new AttributeSet[]{pathAttributes, newAttributes});
            }
            this.map.put(newAttributes, newState);
        }
        if (!Objects.equals(existing, newState)) {
            AttributeSet finalAttributeSet = newAttributes;
            this.watchEventListeners.forEach(listener -> {
                boolean matchesNew;
                boolean matchesOld = oldAttributes != null && listener.attributeMatches(oldAttributes);
                boolean bl = matchesNew = finalAttributeSet != null && listener.attributeMatches(finalAttributeSet);
                if (matchesOld && matchesNew) {
                    listener.sendWebSocketResponse(newState, Watcher.Action.MODIFIED);
                } else if (matchesOld) {
                    listener.sendWebSocketResponse(existing, Watcher.Action.DELETED);
                } else if (matchesNew) {
                    listener.sendWebSocketResponse(newState, Watcher.Action.ADDED);
                }
            });
            this.crdProcessor.process(path, (String)Utils.getNonNullOrElse((Object)newState, (Object)existing), newState == null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AttributeSet> findItems(AttributeSet query) {
        Map map = this.map;
        synchronized (map) {
            return this.map.keySet().stream().filter(entry -> entry.matches(query)).collect(Collectors.toList());
        }
    }

    private MockResponse doCreateOrModify(String path, String initial, HasMetadata value, Watcher.Action event) {
        MockResponse mockResponse = new MockResponse();
        Map<String, String> pathValues = this.kubernetesAttributesExtractor.fromKubernetesPath(path);
        AttributeSet attributes = this.attributeExtractor.fromPath(path);
        try {
            List<AttributeSet> items;
            int responseCode = 200;
            boolean statusSubresource = this.crdProcessor.isStatusSubresource(pathValues);
            JsonNode updated = this.context.getMapper().readTree(initial);
            AttributeSet existingAttributes = null;
            if (event == Watcher.Action.ADDED) {
                items = this.findItems(attributes = attributes.add(new Attribute[]{new Attribute("name", KubernetesResourceUtil.getName((HasMetadata)value))}));
                if (items.isEmpty()) {
                    if (statusSubresource) {
                        this.removeStatus(updated);
                    }
                    this.setDefaultMetadata(updated, pathValues, null);
                } else {
                    responseCode = 409;
                }
            } else {
                items = this.findItems(attributes);
                if (items.isEmpty()) {
                    responseCode = 404;
                } else {
                    existingAttributes = items.get(0);
                    String existing = (String)this.map.get(existingAttributes);
                    JsonNode existingNode = this.context.getMapper().readTree(existing);
                    if (KubernetesCrudDispatcher.isStatusPath(path)) {
                        JsonNode status = this.removeStatus(updated);
                        updated = existingNode;
                        this.setStatus(updated, status);
                    } else {
                        if (statusSubresource) {
                            this.setStatus(updated, this.removeStatus(existingNode));
                        }
                        this.setDefaultMetadata(updated, pathValues, existingNode);
                    }
                }
            }
            if (responseCode == 200) {
                String s = this.context.getMapper().writeValueAsString((Object)updated);
                this.processEvent(path, attributes, existingAttributes, s);
                mockResponse.setBody(s);
            }
            mockResponse.setResponseCode(responseCode);
            return mockResponse;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static boolean isStatusPath(String path) {
        return path.endsWith("/status");
    }

    static boolean shouldIncreaseGeneration(JsonNode existing, JsonNode source) {
        JsonNode differences = Optional.ofNullable(existing).map(e -> JsonDiff.asJson((JsonNode)e, (JsonNode)source)).orElse(null);
        return KubernetesCrudDispatcher.shouldIncreaseGeneration(differences);
    }

    static boolean shouldIncreaseGeneration(JsonNode differences) {
        if (differences != null && !differences.isEmpty()) {
            return StreamSupport.stream(differences.spliterator(), false).filter(n -> !n.get("path").asText().matches("/metadata(/.*)?")).anyMatch(n -> !n.get("path").asText().matches("/status(/.*)?"));
        }
        return false;
    }

    private void setDefaultMetadata(JsonNode source, Map<String, String> pathValues, JsonNode existing) {
        ObjectNode metadata = (ObjectNode)source.findValue("metadata");
        ObjectNode existingMetadata = null;
        if (existing != null) {
            existingMetadata = (ObjectNode)existing.findValue("metadata");
        }
        UUID uuid = UUID.randomUUID();
        if (metadata.get("name") == null) {
            metadata.put("name", metadata.get("generateName").asText() + "-" + uuid.toString());
        }
        if (metadata.get("namespace") == null) {
            metadata.put("namespace", pathValues.get("namespace"));
        }
        metadata.put("uid", this.getOrDefault((JsonNode)existingMetadata, "uid", uuid.toString()));
        metadata.put(GENERATION, Integer.parseInt(this.getOrDefault((JsonNode)existingMetadata, GENERATION, "1")));
        metadata.put("creationTimestamp", this.getOrDefault((JsonNode)existingMetadata, "creationTimestamp", ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT)));
        if (existing == null) {
            metadata.put(RESOURCE_VERSION, String.valueOf(this.resourceVersion.incrementAndGet()));
        } else {
            metadata.put(RESOURCE_VERSION, this.getOrDefault((JsonNode)existingMetadata, RESOURCE_VERSION, "0"));
            JsonNode diff = JsonDiff.asJson((JsonNode)existing, (JsonNode)source);
            if (!diff.isEmpty()) {
                metadata.put(RESOURCE_VERSION, String.valueOf(this.resourceVersion.incrementAndGet()));
                if (KubernetesCrudDispatcher.shouldIncreaseGeneration(diff)) {
                    metadata.put(GENERATION, Integer.parseInt(this.getOrDefault((JsonNode)existingMetadata, GENERATION, "0")) + 1);
                }
            }
        }
    }

    private String getOrDefault(JsonNode node, String name, String defaultValue) {
        JsonNode field;
        if (node != null && (field = node.get(name)) != null) {
            return field.asText();
        }
        return defaultValue;
    }

    private JsonNode removeStatus(JsonNode source) {
        return ((ObjectNode)source).remove(STATUS);
    }

    private void setStatus(JsonNode source, JsonNode status) {
        if (status != null) {
            ((ObjectNode)source).set(STATUS, status);
        } else {
            ((ObjectNode)source).remove(STATUS);
        }
    }

    private MockResponse validateRequestBodyAndHandleRequest(String s, Function<HasMetadata, MockResponse> mockResponseFunction) {
        HasMetadata h = null;
        try {
            h = KubernetesAttributesExtractor.toKubernetesResource(s);
            this.validateResource(h);
            return mockResponseFunction.apply(h);
        }
        catch (KubernetesClientException | IllegalArgumentException e) {
            return this.getUnprocessableEntityMockResponse(s, h, (Exception)e);
        }
    }

    private MockResponse getUnprocessableEntityMockResponse(String s, HasMetadata h, Exception ex) {
        String statusBody = this.getStatusBody(h, 422, ex);
        if (statusBody == null) {
            statusBody = s;
        }
        return new MockResponse().setResponseCode(422).setBody(statusBody);
    }

    private String getStatusBody(HasMetadata h, int code, Exception ex) {
        String kind = "Unknown";
        if (h != null && Utils.isNotNullOrEmpty((String)h.getKind())) {
            kind = h.getKind();
        }
        Status status = ((StatusBuilder)((StatusBuilder)((StatusFluent.DetailsNested)((StatusFluent.DetailsNested)((StatusBuilder)((StatusBuilder)((StatusBuilder)new StatusBuilder().withStatus("Failure")).withReason("Invalid")).withMessage(kind + " is invalid")).withNewDetails().withKind(kind)).withCauses(this.getFailureStatusCause(ex))).endDetails()).withCode(code)).build();
        try {
            return Serialization.jsonMapper().writeValueAsString((Object)status);
        }
        catch (IOException ioException) {
            return null;
        }
    }

    private StatusCause getFailureStatusCause(Exception ex) {
        return ((StatusCauseBuilder)((StatusCauseBuilder)new StatusCauseBuilder().withMessage(ex.getMessage())).withReason("ValueRequired")).build();
    }

    private void validateResource(HasMetadata item) {
        if (item == null) {
            throw new IllegalArgumentException("No item provided");
        }
        if (item.getMetadata() == null) {
            throw new IllegalArgumentException("Required value: metadata is required");
        }
        if (Utils.isNullOrEmpty((String)item.getMetadata().getName()) && Utils.isNullOrEmpty((String)item.getMetadata().getGenerateName())) {
            throw new IllegalArgumentException("Required value: name or generateName is required");
        }
        if (Utils.isNullOrEmpty((String)item.getKind())) {
            throw new IllegalArgumentException("Required value: kind is required");
        }
        if (Utils.isNullOrEmpty((String)item.getApiVersion())) {
            throw new IllegalArgumentException("Required value: apiVersion is required");
        }
    }

    @Override
    public void reset() {
        this.map.clear();
    }

    private static interface EventProcessor {
        public void processEvent(String var1, AttributeSet var2, AttributeSet var3);
    }
}

