/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_0.informers.impl.cache;

import io.fabric8.kubernetes.api.model.v6_0.HasMetadata;
import io.fabric8.kubernetes.api.model.v6_0.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v6_0.ListOptionsBuilder;
import io.fabric8.kubernetes.clnt.v6_0.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v6_0.Watch;
import io.fabric8.kubernetes.clnt.v6_0.Watcher;
import io.fabric8.kubernetes.clnt.v6_0.WatcherException;
import io.fabric8.kubernetes.clnt.v6_0.informers.impl.ListerWatcher;
import io.fabric8.kubernetes.clnt.v6_0.informers.impl.cache.SyncableStore;
import io.fabric8.kubernetes.clnt.v6_0.utils.Utils;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reflector<T extends HasMetadata, L extends KubernetesResourceList<T>> {
    private static final Logger log = LoggerFactory.getLogger(Reflector.class);
    private volatile String lastSyncResourceVersion;
    private final Class<T> apiTypeClass;
    private final ListerWatcher<T, L> listerWatcher;
    private final SyncableStore<T> store;
    private final ReflectorWatcher watcher;
    private volatile boolean running;
    private volatile boolean watching;
    private volatile CompletableFuture<Watch> watchFuture;
    private volatile Future<?> reconnectFuture;

    public Reflector(Class<T> apiTypeClass, ListerWatcher<T, L> listerWatcher, SyncableStore<T> store) {
        this.apiTypeClass = apiTypeClass;
        this.listerWatcher = listerWatcher;
        this.store = store;
        this.watcher = new ReflectorWatcher();
    }

    public CompletableFuture<Void> start() {
        this.running = true;
        return this.listSyncAndWatch();
    }

    public void stop() {
        this.running = false;
        Future<?> future = this.reconnectFuture;
        if (future != null) {
            future.cancel(true);
        }
        this.stopWatcher();
    }

    private synchronized void stopWatcher() {
        if (this.watchFuture != null) {
            this.watchFuture.cancel(true);
            try {
                Watch w = this.watchFuture.getNow(null);
                if (w != null) {
                    this.stopWatch(w);
                }
            }
            catch (CancellationException | CompletionException runtimeException) {
                // empty catch block
            }
            this.watchFuture = null;
        }
    }

    public CompletableFuture<Void> listSyncAndWatch() {
        if (!this.running) {
            return CompletableFuture.completedFuture(null);
        }
        ConcurrentSkipListSet<String> nextKeys = new ConcurrentSkipListSet<String>();
        return this.processList(nextKeys, null).thenAccept(result -> {
            String latestResourceVersion;
            this.store.retainAll(nextKeys);
            this.lastSyncResourceVersion = latestResourceVersion = result.getMetadata().getResourceVersion();
            log.debug("Listing items ({}) for resource {} v{}", new Object[]{nextKeys.size(), this.apiTypeClass, latestResourceVersion});
            CompletableFuture<Watch> started = this.startWatcher(latestResourceVersion);
            if (started != null) {
                started.whenComplete((w, t) -> {
                    if (w != null) {
                        if (this.running) {
                            this.watching = true;
                        } else {
                            this.stopWatch((Watch)w);
                        }
                    }
                });
            }
        });
    }

    private CompletableFuture<L> processList(Set<String> nextKeys, String continueVal) {
        CompletableFuture<L> futureResult = this.listerWatcher.submitList(((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(this.listerWatcher.getLimit())).withContinue(continueVal)).build());
        return futureResult.thenCompose(result -> {
            result.getItems().forEach(i -> {
                String key = this.store.getKey(i);
                nextKeys.add(key);
            });
            this.store.update(result.getItems());
            String nextContinueVal = result.getMetadata().getContinue();
            if (Utils.isNotNullOrEmpty((String)nextContinueVal)) {
                return this.processList(nextKeys, nextContinueVal);
            }
            return CompletableFuture.completedFuture(result);
        });
    }

    private void stopWatch(Watch w) {
        String ns = this.listerWatcher.getNamespace();
        log.debug("Stopping watcher for resource {} v{} in namespace {}", new Object[]{this.apiTypeClass, this.lastSyncResourceVersion, ns});
        w.close();
        this.watchStopped();
    }

    private synchronized CompletableFuture<Watch> startWatcher(String latestResourceVersion) {
        if (!this.running) {
            return null;
        }
        log.debug("Starting watcher for resource {} v{}", this.apiTypeClass, (Object)latestResourceVersion);
        this.watchFuture = this.listerWatcher.submitWatch(((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion(latestResourceVersion)).withTimeoutSeconds(null)).build(), this.watcher);
        return this.watchFuture;
    }

    private synchronized void watchStopped() {
        this.watching = false;
    }

    public String getLastSyncResourceVersion() {
        return this.lastSyncResourceVersion;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isWatching() {
        return this.watching;
    }

    ReflectorWatcher getWatcher() {
        return this.watcher;
    }

    class ReflectorWatcher
    implements Watcher<T> {
        ReflectorWatcher() {
        }

        public void eventReceived(Watcher.Action action, T resource) {
            if (action == null) {
                throw new KubernetesClientException("Unrecognized event");
            }
            if (resource == null) {
                throw new KubernetesClientException("Unrecognized resource");
            }
            if (log.isDebugEnabled()) {
                log.debug("Event received {} {} resourceVersion {}", new Object[]{action.name(), resource.getKind(), resource.getMetadata().getResourceVersion()});
            }
            switch (action) {
                case ERROR: {
                    throw new KubernetesClientException("ERROR event");
                }
                case ADDED: {
                    Reflector.this.store.add(resource);
                    break;
                }
                case MODIFIED: {
                    Reflector.this.store.update(resource);
                    break;
                }
                case DELETED: {
                    Reflector.this.store.delete(resource);
                }
            }
            Reflector.this.lastSyncResourceVersion = resource.getMetadata().getResourceVersion();
        }

        public void onClose(WatcherException exception) {
            boolean restarted = false;
            try {
                if (exception.isHttpGone()) {
                    log.debug("Watch restarting due to http gone");
                    Reflector.this.listSyncAndWatch().whenComplete((v, t) -> {
                        if (t != null) {
                            Reflector.this.watchStopped();
                            Reflector.this.reconnectFuture = Utils.schedule(Runnable::run, Reflector.this::listSyncAndWatch, (long)Reflector.this.listerWatcher.getWatchReconnectInterval(), (TimeUnit)TimeUnit.MILLISECONDS);
                        }
                    });
                    restarted = true;
                } else {
                    log.warn("Watch closing with exception", (Throwable)exception);
                    Reflector.this.running = false;
                }
            }
            finally {
                if (!restarted) {
                    Reflector.this.watchStopped();
                }
            }
        }

        public void onClose() {
            Reflector.this.watchStopped();
            log.debug("Watch gracefully closed");
        }

        public boolean reconnecting() {
            return true;
        }
    }
}

