/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_0.dsl.internal.uploadable;

import io.fabric8.kubernetes.clnt.v6_0.dsl.ExecWatch;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_0.utils.InputStreamPumper;
import io.fabric8.kubernetes.clnt.v6_0.utils.Utils;
import io.fabric8.kubernetes.clnt.v6_0.utils.internal.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class PodUpload {
    private static final String TAR_PATH_DELIMITER = "/";

    private PodUpload() {
    }

    public static boolean upload(PodOperationsImpl operation, Path pathToUpload) throws IOException {
        if (Utils.isNotNullOrEmpty((String)operation.getContext().getFile()) && pathToUpload.toFile().isFile()) {
            return PodUpload.uploadFile(operation, pathToUpload);
        }
        if (Utils.isNotNullOrEmpty((String)operation.getContext().getDir()) && pathToUpload.toFile().isDirectory()) {
            return PodUpload.uploadDirectory(operation, pathToUpload);
        }
        throw new IllegalArgumentException("Provided arguments are not valid (file, directory, path)");
    }

    private static boolean upload(PodOperationsImpl operation, String command, UploadProcessor processor) throws IOException {
        CompletableFuture exitFuture;
        String containerId = (operation = operation.redirectingInput().terminateOnError()).getContext().getContainerId();
        if (Utils.isNotNullOrEmpty((String)containerId)) {
            operation = operation.inContainer(containerId);
        }
        try (ExecWatch execWatch = operation.exec("sh", "-c", command);){
            OutputStream out = execWatch.getInput();
            processor.process(out);
            out.close();
            exitFuture = execWatch.exitCode();
        }
        if (!Utils.waitUntilReady((Future)exitFuture, (long)operation.getConfig().getRequestConfig().getUploadRequestTimeout(), (TimeUnit)TimeUnit.MILLISECONDS)) {
            return false;
        }
        Integer exitCode = exitFuture.getNow(null);
        return exitCode == null || exitCode == 0;
    }

    public static boolean uploadFileData(PodOperationsImpl operation, InputStream inputStream) throws IOException {
        String command = PodUpload.createExecCommandForUpload(operation.getContext().getFile());
        return PodUpload.upload(operation, command, os -> {
            try (Base64.InputStream b64In = new Base64.InputStream(inputStream, 1);){
                InputStreamPumper.transferTo((InputStream)b64In, os::write);
            }
        });
    }

    private static boolean uploadFile(PodOperationsImpl operation, Path pathToUpload) throws IOException {
        try (FileInputStream fis = new FileInputStream(pathToUpload.toFile());){
            boolean bl = PodUpload.uploadFileData(operation, fis);
            return bl;
        }
    }

    private static boolean uploadDirectory(PodOperationsImpl operation, Path pathToUpload) throws IOException {
        String command = String.format("mkdir -p %1$s && base64 -d - | tar -C %1$s -xzf -", PodOperationsImpl.shellQuote(operation.getContext().getDir()));
        return PodUpload.upload(operation, command, os -> {
            try (Base64.OutputStream b64Out = new Base64.OutputStream(os, 1);
                 GZIPOutputStream gzip = new GZIPOutputStream(b64Out);
                 TarArchiveOutputStream tar = new TarArchiveOutputStream((OutputStream)gzip);){
                tar.setLongFileMode(3);
                for (File file : pathToUpload.toFile().listFiles()) {
                    PodUpload.addFileToTar(null, file, tar);
                }
                tar.flush();
            }
        });
    }

    private static void addFileToTar(String rootTarPath, File file, TarArchiveOutputStream tar) throws IOException {
        String fileName = Optional.ofNullable(rootTarPath).orElse("") + TAR_PATH_DELIMITER + file.getName();
        tar.putArchiveEntry((ArchiveEntry)new TarArchiveEntry(file, fileName));
        if (file.isFile()) {
            Files.copy(file.toPath(), (OutputStream)tar);
            tar.closeArchiveEntry();
        } else if (file.isDirectory()) {
            tar.closeArchiveEntry();
            for (File fileInDirectory : file.listFiles()) {
                PodUpload.addFileToTar(fileName, fileInDirectory, tar);
            }
        }
    }

    static String createExecCommandForUpload(String file) {
        String directoryTrimmedFromFilePath = file.substring(0, file.lastIndexOf(47));
        String directory = directoryTrimmedFromFilePath.isEmpty() ? TAR_PATH_DELIMITER : directoryTrimmedFromFilePath;
        return String.format("mkdir -p %s && base64 -d - > %s", PodOperationsImpl.shellQuote(directory), PodOperationsImpl.shellQuote(file));
    }

    private static interface UploadProcessor {
        public void process(OutputStream var1) throws IOException;
    }
}

