/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_0.dsl.internal.core.v1;

import io.fabric8.kubernetes.api.model.v6_0.Container;
import io.fabric8.kubernetes.api.model.v6_0.ReplicationController;
import io.fabric8.kubernetes.api.model.v6_0.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v6_0.Status;
import io.fabric8.kubernetes.api.model.v6_0.extensions.DeploymentRollback;
import io.fabric8.kubernetes.clnt.v6_0.Client;
import io.fabric8.kubernetes.clnt.v6_0.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v6_0.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v6_0.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v6_0.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v6_0.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.OperationContext;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.apps.v1.RollableScalableResourceOperation;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.core.v1.ReplicationControllerRollingUpdater;
import io.fabric8.kubernetes.clnt.v6_0.utils.internal.PodOperationUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ReplicationControllerOperationsImpl
extends RollableScalableResourceOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>>
implements TimeoutImageEditReplacePatchable<ReplicationController> {
    public ReplicationControllerOperationsImpl(Client client) {
        this(new RollingOperationContext(), HasMetadataOperationsImpl.defaultContext(client));
    }

    public ReplicationControllerOperationsImpl(RollingOperationContext context, OperationContext superContext) {
        super(context, superContext.withPlural("replicationcontrollers"), ReplicationController.class, ReplicationControllerList.class);
    }

    @Override
    public ReplicationControllerOperationsImpl newInstance(OperationContext context) {
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext, context);
    }

    public ReplicationControllerOperationsImpl newInstance(RollingOperationContext context) {
        return new ReplicationControllerOperationsImpl(context, this.context);
    }

    @Override
    public ReplicationController withReplicas(int count) {
        return (ReplicationController)this.accept(r -> r.getSpec().setReplicas(count));
    }

    @Override
    public RollingUpdater<ReplicationController, ReplicationControllerList> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new ReplicationControllerRollingUpdater(this.context.getClient(), this.namespace, rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    public int getCurrentReplicas(ReplicationController current) {
        return current.getStatus().getReplicas();
    }

    @Override
    public int getDesiredReplicas(ReplicationController item) {
        return item.getSpec().getReplicas();
    }

    @Override
    public long getObservedGeneration(ReplicationController current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    public Status rollback(DeploymentRollback deploymentRollback) {
        throw new KubernetesClientException("rollback not supported in case of ReplicationControllers");
    }

    public String getLog(boolean isPretty) {
        return PodOperationUtil.getLog(this.doGetLog(isPretty), isPretty);
    }

    private List<PodResource> doGetLog(boolean isPretty) {
        ReplicationController rc = (ReplicationController)this.requireFromServer();
        return PodOperationUtil.getPodOperationsForController(this.context, rc.getMetadata().getUid(), ReplicationControllerOperationsImpl.getReplicationControllerPodLabels(rc), isPretty, this.rollingOperationContext.getLogWaitTimeout(), this.rollingOperationContext.getContainerId());
    }

    public Reader getLogReader() {
        return PodOperationUtil.getLogReader(this.doGetLog(false));
    }

    public InputStream getLogInputStream() {
        return PodOperationUtil.getLogInputStream(this.doGetLog(false));
    }

    public LogWatch watchLog(OutputStream out) {
        return PodOperationUtil.watchLog(this.doGetLog(false), out);
    }

    public ReplicationController pause() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" pausing is not supported");
    }

    public ReplicationController resume() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" resuming is not supported");
    }

    public ReplicationController restart() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" restarting is not supported");
    }

    public ReplicationController undo() {
        throw new UnsupportedOperationException("no rollbacker has been implemented for \"" + ((ReplicationController)this.get()).getKind() + "\"");
    }

    static Map<String, String> getReplicationControllerPodLabels(ReplicationController replicationController) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (replicationController != null && replicationController.getSpec() != null && replicationController.getSpec().getSelector() != null) {
            labels.putAll(replicationController.getSpec().getSelector());
        }
        return labels;
    }

    @Override
    protected List<Container> getContainers(ReplicationController value) {
        return value.getSpec().getTemplate().getSpec().getContainers();
    }
}

