/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_0.dsl.internal.core.v1;

import io.fabric8.kubernetes.api.model.v6_0.DeleteOptions;
import io.fabric8.kubernetes.api.model.v6_0.HasMetadata;
import io.fabric8.kubernetes.api.model.v6_0.Pod;
import io.fabric8.kubernetes.api.model.v6_0.PodList;
import io.fabric8.kubernetes.api.model.v6_0.policy.v1.Eviction;
import io.fabric8.kubernetes.api.model.v6_0.policy.v1beta1.EvictionBuilder;
import io.fabric8.kubernetes.api.model.v6_0.policy.v1beta1.EvictionFluent;
import io.fabric8.kubernetes.clnt.v6_0.Client;
import io.fabric8.kubernetes.clnt.v6_0.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v6_0.LocalPortForward;
import io.fabric8.kubernetes.clnt.v6_0.OperationInfo;
import io.fabric8.kubernetes.clnt.v6_0.PortForward;
import io.fabric8.kubernetes.clnt.v6_0.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_0.dsl.CopyOrReadable;
import io.fabric8.kubernetes.clnt.v6_0.dsl.ExecListenable;
import io.fabric8.kubernetes.clnt.v6_0.dsl.ExecListener;
import io.fabric8.kubernetes.clnt.v6_0.dsl.ExecWatch;
import io.fabric8.kubernetes.clnt.v6_0.dsl.Execable;
import io.fabric8.kubernetes.clnt.v6_0.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v6_0.dsl.Loggable;
import io.fabric8.kubernetes.clnt.v6_0.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v6_0.dsl.PrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_0.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_0.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_0.dsl.TtyExecErrorChannelable;
import io.fabric8.kubernetes.clnt.v6_0.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.clnt.v6_0.dsl.TtyExecOutputErrorable;
import io.fabric8.kubernetes.clnt.v6_0.dsl.TtyExecable;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.ExecWebSocketListener;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.LogWatchCallback;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.OperationContext;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.PortForwarderWebsocket;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.uploadable.PodUpload;
import io.fabric8.kubernetes.clnt.v6_0.http.HttpClient;
import io.fabric8.kubernetes.clnt.v6_0.http.HttpRequest;
import io.fabric8.kubernetes.clnt.v6_0.http.WebSocket;
import io.fabric8.kubernetes.clnt.v6_0.lib.FilenameUtils;
import io.fabric8.kubernetes.clnt.v6_0.utils.URLUtils;
import io.fabric8.kubernetes.clnt.v6_0.utils.Utils;
import io.fabric8.kubernetes.clnt.v6_0.utils.internal.Base64;
import io.fabric8.kubernetes.clnt.v6_0.utils.internal.OptionalDependencyWrapper;
import io.fabric8.kubernetes.clnt.v6_0.utils.internal.PodOperationUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class PodOperationsImpl
extends HasMetadataOperation<Pod, PodList, PodResource>
implements PodResource,
CopyOrReadable {
    public static final int HTTP_TOO_MANY_REQUESTS = 429;
    private static final Integer DEFAULT_POD_LOG_WAIT_TIMEOUT = 5;
    private static final String[] EMPTY_COMMAND = new String[]{"/bin/sh", "-i"};
    private final PodOperationContext podOperationContext;

    public PodOperationsImpl(Client client) {
        this(new PodOperationContext(), HasMetadataOperationsImpl.defaultContext(client));
    }

    public PodOperationsImpl(PodOperationContext context, OperationContext superContext) {
        super(superContext.withPlural("pods"), Pod.class, PodList.class);
        this.podOperationContext = context;
    }

    @Override
    public PodOperationsImpl newInstance(OperationContext context) {
        return new PodOperationsImpl(this.podOperationContext, context);
    }

    public PodOperationContext getContext() {
        return this.podOperationContext;
    }

    protected <T> T doGetLog(Class<T> type) {
        try {
            URL url = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), this.podOperationContext.getLogParameters()}));
            return this.handleRawGet(url, type);
        }
        catch (IOException ioException) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("doGetLog"), (Throwable)ioException);
        }
    }

    public String getLog() {
        return this.doGetLog(String.class);
    }

    public Reader getLogReader() {
        return this.doGetLog(Reader.class);
    }

    public InputStream getLogInputStream() {
        return this.doGetLog(InputStream.class);
    }

    public String getLog(boolean isPretty) {
        return new PodOperationsImpl(this.getContext().withPrettyOutput(isPretty), this.context).getLog();
    }

    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    private void checkForPiped(Object object) {
        if (object instanceof PipedOutputStream || object instanceof PipedInputStream) {
            throw new KubernetesClientException("Piped streams should not be used");
        }
    }

    public LogWatch watchLog(OutputStream out) {
        this.checkForPiped(out);
        try {
            PodOperationUtil.waitUntilReadyBeforeFetchingLogs(this, this.getContext().getLogWaitTimeout() != null ? this.getContext().getLogWaitTimeout() : DEFAULT_POD_LOG_WAIT_TIMEOUT);
            URL url = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), this.getContext().getLogParameters() + "&follow=true"}));
            LogWatchCallback callback = new LogWatchCallback(out, this.context.getExecutor());
            return callback.callAndWait(this.httpClient, url);
        }
        catch (IOException ioException) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("watchLog"), (Throwable)ioException);
        }
    }

    public Loggable withLogWaitTimeout(Integer logWaitTimeout) {
        return new PodOperationsImpl(this.getContext().withLogWaitTimeout(logWaitTimeout), this.context);
    }

    public PortForward portForward(int port, ReadableByteChannel in, WritableByteChannel out) {
        try {
            return new PortForwarderWebsocket(this.httpClient, this.context.getExecutor()).forward(this.getResourceUrl(), port, in, out);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    public LocalPortForward portForward(int port) {
        try {
            return new PortForwarderWebsocket(this.httpClient, this.context.getExecutor()).forward(this.getResourceUrl(), port);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    public LocalPortForward portForward(int port, int localPort) {
        try {
            return new PortForwarderWebsocket(this.httpClient, this.context.getExecutor()).forward(this.getResourceUrl(), port, localPort);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    public LocalPortForward portForward(int port, InetAddress localInetAddress, int localPort) {
        try {
            return new PortForwarderWebsocket(this.httpClient, this.context.getExecutor()).forward(this.getResourceUrl(), port, localInetAddress, localPort);
        }
        catch (MalformedURLException ex) {
            throw KubernetesClientException.launderThrowable((Throwable)ex);
        }
    }

    public boolean evict() {
        io.fabric8.kubernetes.api.model.v6_0.policy.v1beta1.Eviction eviction = ((EvictionBuilder)((EvictionBuilder)((EvictionFluent.MetadataNested)((EvictionFluent.MetadataNested)new EvictionBuilder().withNewMetadata().withName(this.getName())).withNamespace(this.getNamespace())).endMetadata()).withDeleteOptions(new DeleteOptions())).build();
        return this.handleEvict(eviction);
    }

    public boolean evict(Eviction eviction) {
        return this.handleEvict(eviction);
    }

    private boolean handleEvict(HasMetadata eviction) {
        try {
            if (Utils.isNullOrEmpty((String)eviction.getMetadata().getNamespace())) {
                throw new KubernetesClientException("Namespace not specified, but operation requires it.");
            }
            if (Utils.isNullOrEmpty((String)eviction.getMetadata().getName())) {
                throw new KubernetesClientException("Name not specified, but operation requires it.");
            }
            URL requestUrl = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "eviction"}));
            HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().post("application/json", JSON_MAPPER.writeValueAsString((Object)eviction)).url(requestUrl);
            this.handleResponse(requestBuilder, null);
            return true;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 429) {
                throw e;
            }
            return false;
        }
        catch (IOException exception) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("evict"), (Throwable)exception);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("evict"), (Throwable)interruptedException);
        }
    }

    public PodOperationsImpl inContainer(String containerId) {
        return new PodOperationsImpl(this.getContext().withContainerId(containerId), this.context);
    }

    public ExecWatch exec(String ... command) {
        String[] actualCommands = command.length >= 1 ? command : EMPTY_COMMAND;
        try {
            URL url = this.getURLWithCommandParams(actualCommands);
            HttpClient clone = this.httpClient.newBuilder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
            ExecWebSocketListener execWebSocketListener = new ExecWebSocketListener(this.getContext(), this.context.getExecutor());
            CompletableFuture startedFuture = clone.newWebSocketBuilder().subprotocol("v4.channel.k8s.io").uri(url.toURI()).buildAsync((WebSocket.Listener)execWebSocketListener);
            startedFuture.whenComplete((w, t) -> {
                if (t != null) {
                    execWebSocketListener.onError((WebSocket)w, (Throwable)t);
                }
            });
            Utils.waitUntilReadyOrFail((Future)startedFuture, (long)this.config.getWebsocketTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
            return execWebSocketListener;
        }
        catch (Throwable t2) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("exec"), (Throwable)t2);
        }
    }

    URL getURLWithCommandParams(String[] commands) throws MalformedURLException {
        String url = URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "exec"});
        URLUtils.URLBuilder httpUrlBuilder = new URLUtils.URLBuilder(url);
        for (String cmd : commands) {
            httpUrlBuilder.addQueryParameter("command", cmd);
        }
        this.getContext().addQueryParameters(httpUrlBuilder);
        return httpUrlBuilder.build();
    }

    public PodOperationsImpl file(String file) {
        return new PodOperationsImpl(this.getContext().withFile(file), this.context);
    }

    public PodOperationsImpl dir(String dir) {
        return new PodOperationsImpl(this.getContext().withDir(dir), this.context);
    }

    public boolean copy(Path destination) {
        try {
            if (Utils.isNotNullOrEmpty((String)this.getContext().getFile())) {
                this.copyFile(this.getContext().getFile(), destination.toFile());
                return true;
            }
            if (Utils.isNotNullOrEmpty((String)this.getContext().getDir())) {
                this.copyDir(this.getContext().getDir(), destination.toFile());
                return true;
            }
            throw new IllegalStateException("No file or dir has been specified");
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public boolean upload(InputStream inputStream) {
        return OptionalDependencyWrapper.wrapRunWithOptionalDependency(() -> {
            try {
                return PodUpload.uploadFileData(this, inputStream);
            }
            catch (Exception ex) {
                throw KubernetesClientException.launderThrowable((Throwable)ex);
            }
        }, "TarArchiveOutputStream is provided by commons-compress");
    }

    public boolean upload(Path path) {
        return OptionalDependencyWrapper.wrapRunWithOptionalDependency(() -> {
            try {
                return PodUpload.upload(this, path);
            }
            catch (Exception ex) {
                throw KubernetesClientException.launderThrowable((Throwable)ex);
            }
        }, "TarArchiveOutputStream is provided by commons-compress");
    }

    public InputStream read() {
        try {
            if (Utils.isNotNullOrEmpty((String)this.getContext().getFile())) {
                return this.readFile(this.getContext().getFile());
            }
            if (Utils.isNotNullOrEmpty((String)this.getContext().getDir())) {
                return this.readTar(this.getContext().getDir());
            }
            throw new IllegalStateException("No file or dir has been specified");
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    private String[] readFileCommand(String source) {
        return new String[]{"sh", "-c", String.format("cat %s | base64", PodOperationsImpl.shellQuote(source))};
    }

    private InputStream readFile(String source) {
        return this.read(this.readFileCommand(source));
    }

    private void copyFile(String source, File target) {
        File destination = target;
        if (!(destination.exists() || destination.getParentFile().exists() || destination.getParentFile().mkdirs())) {
            throw KubernetesClientException.launderThrowable((Throwable)new IOException("Failed to create directory: " + destination.getParentFile()));
        }
        if (destination.isDirectory()) {
            String[] parts = source.split("\\/|\\\\");
            String filename = parts[parts.length - 1];
            destination = destination.toPath().resolve(filename).toFile();
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destination));){
            this.readTo(new Base64.OutputStream(out, 0), this.readFileCommand(source)).get();
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public InputStream readTar(String source) {
        return this.read("sh", "-c", "tar -cf - " + PodOperationsImpl.shellQuote(source) + "|base64");
    }

    private InputStream read(String ... command) {
        final ExecWatch watch = this.redirectingOutput().exec(command);
        return new Base64.InputStream(watch.getOutput(), 0){

            @Override
            public void close() throws IOException {
                watch.close();
                super.close();
            }
        };
    }

    private Future<?> readTo(OutputStream out, String ... cmd) {
        ExecWatch w = this.writingOutput(out).exec(cmd);
        CompletableFuture result = w.exitCode();
        result.whenComplete((i, t) -> {
            try {
                out.close();
            }
            catch (Exception e) {
                result.obtrudeException(e);
            }
            w.close();
        });
        return result;
    }

    private void copyDir(final String source, final File target) throws Exception {
        try {
            new Runnable(){

                @Override
                public void run() {
                    File destination = target;
                    if (!destination.isDirectory() && !destination.mkdirs()) {
                        throw KubernetesClientException.launderThrowable((Throwable)new IOException("Failed to create directory: " + destination));
                    }
                    try (InputStream is = PodOperationsImpl.this.readTar(source);
                         TarArchiveInputStream tis = new TarArchiveInputStream(is);){
                        TarArchiveEntry entry = tis.getNextTarEntry();
                        while (entry != null) {
                            if (tis.canReadEntryData((ArchiveEntry)entry)) {
                                String normalizedEntryName = FilenameUtils.normalize((String)entry.getName());
                                if (normalizedEntryName == null) {
                                    throw new IOException("Tar entry '" + entry.getName() + "' has an invalid name");
                                }
                                File f = new File(destination, normalizedEntryName);
                                if (entry.isDirectory()) {
                                    if (!f.isDirectory() && !f.mkdirs()) {
                                        throw new IOException("Failed to create directory: " + f);
                                    }
                                } else {
                                    File parent = f.getParentFile();
                                    if (!parent.isDirectory() && !parent.mkdirs()) {
                                        throw new IOException("Failed to create directory: " + f);
                                    }
                                    Files.copy((InputStream)tis, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                }
                            }
                            entry = tis.getNextEntry();
                        }
                    }
                    catch (Exception e) {
                        throw KubernetesClientException.launderThrowable((Throwable)e);
                    }
                }
            }.run();
        }
        catch (NoClassDefFoundError e) {
            throw new KubernetesClientException("TarArchiveInputStream class is provided by commons-compress, an optional dependency. To use the read/copy functionality you must explicitly add this dependency to the classpath.");
        }
    }

    public TtyExecOutputErrorable readingInput(InputStream in) {
        this.checkForPiped(in);
        return new PodOperationsImpl(this.getContext().withIn(in), this.context);
    }

    public PodOperationsImpl redirectingInput() {
        return this.redirectingInput(null);
    }

    public PodOperationsImpl redirectingInput(Integer bufferSize) {
        return new PodOperationsImpl(this.getContext().toBuilder().redirectingIn(true).bufferSize(bufferSize).build(), this.context);
    }

    public TtyExecErrorable writingOutput(OutputStream out) {
        this.checkForPiped(out);
        return new PodOperationsImpl(this.getContext().toBuilder().output(new PodOperationContext.StreamContext(out)).build(), this.context);
    }

    public TtyExecErrorable redirectingOutput() {
        return new PodOperationsImpl(this.getContext().toBuilder().output(new PodOperationContext.StreamContext()).build(), this.context);
    }

    public TtyExecErrorChannelable writingError(OutputStream err) {
        this.checkForPiped(err);
        return new PodOperationsImpl(this.getContext().toBuilder().error(new PodOperationContext.StreamContext(err)).build(), this.context);
    }

    public TtyExecErrorChannelable redirectingError() {
        return new PodOperationsImpl(this.getContext().toBuilder().error(new PodOperationContext.StreamContext()).build(), this.context);
    }

    public TtyExecable writingErrorChannel(OutputStream errChannel) {
        this.checkForPiped(errChannel);
        return new PodOperationsImpl(this.getContext().toBuilder().errorChannel(new PodOperationContext.StreamContext(errChannel)).build(), this.context);
    }

    public TtyExecable redirectingErrorChannel() {
        return new PodOperationsImpl(this.getContext().toBuilder().errorChannel(new PodOperationContext.StreamContext()).build(), this.context);
    }

    public ExecListenable withTTY() {
        return new PodOperationsImpl(this.getContext().withTty(true), this.context);
    }

    public Loggable withPrettyOutput() {
        return new PodOperationsImpl(this.getContext().withPrettyOutput(true), this.context);
    }

    public PrettyLoggable tailingLines(int withTailingLines) {
        return new PodOperationsImpl(this.getContext().withTailingLines(withTailingLines), this.context);
    }

    public TailPrettyLoggable sinceTime(String sinceTimestamp) {
        return new PodOperationsImpl(this.getContext().withSinceTimestamp(sinceTimestamp), this.context);
    }

    public TailPrettyLoggable sinceSeconds(int sinceSeconds) {
        return new PodOperationsImpl(this.getContext().withSinceSeconds(sinceSeconds), this.context);
    }

    public TimeTailPrettyLoggable terminated() {
        return new PodOperationsImpl(this.getContext().withTerminatedStatus(true), this.context);
    }

    public Execable usingListener(ExecListener execListener) {
        return new PodOperationsImpl(this.getContext().withExecListener(execListener), this.context);
    }

    public BytesLimitTerminateTimeTailPrettyLoggable limitBytes(int limitBytes) {
        return new PodOperationsImpl(this.getContext().withLimitBytes(limitBytes), this.context);
    }

    public BytesLimitTerminateTimeTailPrettyLoggable usingTimestamps() {
        return new PodOperationsImpl(this.getContext().withTimestamps(true), this.context);
    }

    public static String shellQuote(String value) {
        return "'" + value.replace("'", "'\\\\''") + "'";
    }

    public PodOperationsImpl terminateOnError() {
        return new PodOperationsImpl(this.getContext().toBuilder().terminateOnError(true).build(), this.context);
    }
}

