/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_0.dsl.internal;

import io.fabric8.kubernetes.api.model.v6_0.HasMetadata;
import io.fabric8.kubernetes.api.model.v6_0.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v6_0.ListOptions;
import io.fabric8.kubernetes.api.model.v6_0.Status;
import io.fabric8.kubernetes.clnt.v6_0.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v6_0.Watcher;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.OperationSupport;
import io.fabric8.kubernetes.clnt.v6_0.dsl.internal.WatcherWebSocketListener;
import io.fabric8.kubernetes.clnt.v6_0.http.HttpClient;
import io.fabric8.kubernetes.clnt.v6_0.http.HttpResponse;
import io.fabric8.kubernetes.clnt.v6_0.http.WebSocket;
import io.fabric8.kubernetes.clnt.v6_0.http.WebSocketHandshakeException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchConnectionManager<T extends HasMetadata, L extends KubernetesResourceList<T>>
extends AbstractWatchManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(WatchConnectionManager.class);
    protected WatcherWebSocketListener<T> listener;
    private CompletableFuture<WebSocket> websocketFuture;
    private WebSocket websocket;
    private volatile boolean ready;

    static void closeWebSocket(WebSocket webSocket) {
        if (webSocket != null) {
            logger.debug("Closing websocket {}", (Object)webSocket);
            try {
                if (!webSocket.sendClose(1000, null)) {
                    logger.debug("Websocket already closed {}", (Object)webSocket);
                }
            }
            catch (IllegalStateException e) {
                logger.error("invalid code for websocket: {} {}", e.getClass(), (Object)e.getMessage());
            }
        }
    }

    public WatchConnectionManager(HttpClient client, BaseOperation<T, L, ?> baseOperation, ListOptions listOptions, Watcher<T> watcher, int reconnectInterval, int reconnectLimit, long websocketTimeout, int maxIntervalExponent) throws MalformedURLException {
        super(watcher, baseOperation, listOptions, reconnectLimit, reconnectInterval, maxIntervalExponent, () -> client.newBuilder().readTimeout(websocketTimeout, TimeUnit.MILLISECONDS).build());
    }

    public WatchConnectionManager(HttpClient client, BaseOperation<T, L, ?> baseOperation, ListOptions listOptions, Watcher<T> watcher, int reconnectInterval, int reconnectLimit, long websocketTimeout) throws MalformedURLException {
        this(client, baseOperation, listOptions, watcher, reconnectInterval, reconnectLimit, websocketTimeout, 5);
    }

    @Override
    protected synchronized void closeRequest() {
        WatchConnectionManager.closeWebSocket(this.websocket);
        if (this.websocketFuture != null) {
            this.websocketFuture.whenComplete((w, t) -> {
                if (w != null) {
                    WatchConnectionManager.closeWebSocket(w);
                }
            });
            this.websocketFuture = null;
        }
    }

    synchronized WatcherWebSocketListener<T> getListener() {
        return this.listener;
    }

    public CompletableFuture<WebSocket> getWebsocketFuture() {
        return this.websocketFuture;
    }

    @Override
    protected void start(URL url, Map<String, String> headers) {
        this.listener = new WatcherWebSocketListener(this);
        WebSocket.Builder builder = this.client.newWebSocketBuilder();
        headers.forEach((arg_0, arg_1) -> ((WebSocket.Builder)builder).header(arg_0, arg_1));
        builder.uri(URI.create(url.toString()));
        this.websocketFuture = builder.buildAsync(this.listener).handle((w, t) -> {
            if (t != null) {
                if (t instanceof WebSocketHandshakeException) {
                    WebSocketHandshakeException wshe = (WebSocketHandshakeException)t;
                    HttpResponse response = wshe.getResponse();
                    int code = response.code();
                    Status status = OperationSupport.createStatus(response);
                    if (200 == code || 503 == code) {
                        throw OperationSupport.requestFailure(this.client.newHttpRequestBuilder().url(url).build(), status, "Received " + code + " on websocket");
                    }
                    logger.warn("Exec Failure: HTTP {}, Status: {} - {}", new Object[]{code, status.getCode(), status.getMessage()});
                    t = OperationSupport.requestFailure(this.client.newHttpRequestBuilder().url(url).build(), status);
                }
                if (this.ready) {
                    this.listener.onError((WebSocket)w, (Throwable)t);
                }
                throw KubernetesClientException.launderThrowable((Throwable)t);
            }
            if (w != null) {
                this.ready = true;
                this.websocket = w;
            }
            return w;
        });
    }
}

