/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_0.dsl.internal;

import io.fabric8.kubernetes.clnt.v6_0.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v6_0.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v6_0.http.HttpClient;
import io.fabric8.kubernetes.clnt.v6_0.http.HttpRequest;
import io.fabric8.kubernetes.clnt.v6_0.utils.internal.SerialExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogWatchCallback
implements LogWatch,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogWatchCallback.class);
    private OutputStream out;
    private WritableByteChannel outChannel;
    private volatile InputStream output;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile Optional<HttpClient.AsyncBody> asyncBody = Optional.empty();
    private final SerialExecutor serialExecutor;

    public LogWatchCallback(OutputStream out, Executor executor) {
        this.out = out;
        if (out != null) {
            this.outChannel = Channels.newChannel(out);
        }
        this.serialExecutor = new SerialExecutor(executor);
    }

    @Override
    public void close() {
        this.cleanUp();
    }

    private void cleanUp() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.asyncBody.ifPresent(HttpClient.AsyncBody::cancel);
        this.serialExecutor.shutdownNow();
    }

    public LogWatchCallback callAndWait(HttpClient client, URL url) {
        HttpRequest request = client.newHttpRequestBuilder().url(url).build();
        HttpClient clone = client.newBuilder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
        if (this.out == null) {
            ((CompletableFuture)clone.sendAsync(request, InputStream.class).whenComplete((r, e) -> {
                if (e != null) {
                    this.onFailure((Throwable)e);
                }
                if (r != null) {
                    this.output = (InputStream)r.body();
                }
            })).join();
        } else {
            clone.consumeBytes(request, (buffers, a) -> CompletableFuture.runAsync(() -> {
                for (ByteBuffer byteBuffer : buffers) {
                    try {
                        this.outChannel.write(byteBuffer);
                    }
                    catch (IOException e1) {
                        throw KubernetesClientException.launderThrowable((Throwable)e1);
                    }
                }
            }, this.serialExecutor).whenComplete((v, t) -> {
                if (t != null) {
                    a.cancel();
                    this.onFailure((Throwable)t);
                } else if (!this.closed.get()) {
                    a.consume();
                } else {
                    a.cancel();
                }
            })).whenComplete((a, e) -> {
                if (e != null) {
                    this.onFailure((Throwable)e);
                }
                if (a != null) {
                    this.asyncBody = Optional.of(a.body());
                    ((HttpClient.AsyncBody)a.body()).consume();
                    ((HttpClient.AsyncBody)a.body()).done().whenComplete((v, t) -> {
                        if (t != null) {
                            this.onFailure((Throwable)t);
                        } else {
                            this.cleanUp();
                        }
                    });
                }
            });
        }
        return this;
    }

    public InputStream getOutput() {
        return this.output;
    }

    public void onFailure(Throwable u) {
        if (this.closed.get()) {
            return;
        }
        LOGGER.error("Log Callback Failure.", u);
        this.cleanUp();
    }
}

