/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_0.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_0.apiextensions.v1beta1.CustomResourceDefinitionNames;
import io.fabric8.kubernetes.api.model.v6_0.apiextensions.v1beta1.CustomResourceDefinitionNamesFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CustomResourceDefinitionNamesFluentImpl<A extends CustomResourceDefinitionNamesFluent<A>>
extends BaseFluent<A>
implements CustomResourceDefinitionNamesFluent<A> {
    private List<String> categories = new ArrayList<String>();
    private String kind;
    private String listKind;
    private String plural;
    private List<String> shortNames = new ArrayList<String>();
    private String singular;
    private Map<String, Object> additionalProperties;

    public CustomResourceDefinitionNamesFluentImpl() {
    }

    public CustomResourceDefinitionNamesFluentImpl(CustomResourceDefinitionNames instance) {
        this.withCategories(instance.getCategories());
        this.withKind(instance.getKind());
        this.withListKind(instance.getListKind());
        this.withPlural(instance.getPlural());
        this.withShortNames(instance.getShortNames());
        this.withSingular(instance.getSingular());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToCategories(Integer index, String item) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        this.categories.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCategories(Integer index, String item) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        this.categories.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCategories(String ... items) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        for (String item : items) {
            this.categories.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCategories(Collection<String> items) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        for (String item : items) {
            this.categories.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCategories(String ... items) {
        for (String item : items) {
            if (this.categories == null) continue;
            this.categories.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCategories(Collection<String> items) {
        for (String item : items) {
            if (this.categories == null) continue;
            this.categories.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCategories() {
        return this.categories;
    }

    @Override
    public String getCategory(Integer index) {
        return this.categories.get(index);
    }

    @Override
    public String getFirstCategory() {
        return this.categories.get(0);
    }

    @Override
    public String getLastCategory() {
        return this.categories.get(this.categories.size() - 1);
    }

    @Override
    public String getMatchingCategory(Predicate<String> predicate) {
        for (String item : this.categories) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCategory(Predicate<String> predicate) {
        for (String item : this.categories) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCategories(List<String> categories) {
        if (categories != null) {
            this.categories = new ArrayList<String>();
            for (String item : categories) {
                this.addToCategories(item);
            }
        } else {
            this.categories = null;
        }
        return (A)this;
    }

    @Override
    public A withCategories(String ... categories) {
        if (this.categories != null) {
            this.categories.clear();
        }
        if (categories != null) {
            for (String item : categories) {
                this.addToCategories(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCategories() {
        return this.categories != null && !this.categories.isEmpty();
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public String getListKind() {
        return this.listKind;
    }

    @Override
    public A withListKind(String listKind) {
        this.listKind = listKind;
        return (A)this;
    }

    @Override
    public Boolean hasListKind() {
        return this.listKind != null;
    }

    @Override
    public String getPlural() {
        return this.plural;
    }

    @Override
    public A withPlural(String plural) {
        this.plural = plural;
        return (A)this;
    }

    @Override
    public Boolean hasPlural() {
        return this.plural != null;
    }

    @Override
    public A addToShortNames(Integer index, String item) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        this.shortNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToShortNames(Integer index, String item) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        this.shortNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToShortNames(String ... items) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.shortNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToShortNames(Collection<String> items) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.shortNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromShortNames(String ... items) {
        for (String item : items) {
            if (this.shortNames == null) continue;
            this.shortNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromShortNames(Collection<String> items) {
        for (String item : items) {
            if (this.shortNames == null) continue;
            this.shortNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getShortNames() {
        return this.shortNames;
    }

    @Override
    public String getShortName(Integer index) {
        return this.shortNames.get(index);
    }

    @Override
    public String getFirstShortName() {
        return this.shortNames.get(0);
    }

    @Override
    public String getLastShortName() {
        return this.shortNames.get(this.shortNames.size() - 1);
    }

    @Override
    public String getMatchingShortName(Predicate<String> predicate) {
        for (String item : this.shortNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingShortName(Predicate<String> predicate) {
        for (String item : this.shortNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withShortNames(List<String> shortNames) {
        if (shortNames != null) {
            this.shortNames = new ArrayList<String>();
            for (String item : shortNames) {
                this.addToShortNames(item);
            }
        } else {
            this.shortNames = null;
        }
        return (A)this;
    }

    @Override
    public A withShortNames(String ... shortNames) {
        if (this.shortNames != null) {
            this.shortNames.clear();
        }
        if (shortNames != null) {
            for (String item : shortNames) {
                this.addToShortNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasShortNames() {
        return this.shortNames != null && !this.shortNames.isEmpty();
    }

    @Override
    public String getSingular() {
        return this.singular;
    }

    @Override
    public A withSingular(String singular) {
        this.singular = singular;
        return (A)this;
    }

    @Override
    public Boolean hasSingular() {
        return this.singular != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomResourceDefinitionNamesFluentImpl that = (CustomResourceDefinitionNamesFluentImpl)o;
        if (this.categories != null ? !this.categories.equals(that.categories) : that.categories != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.listKind != null ? !this.listKind.equals(that.listKind) : that.listKind != null) {
            return false;
        }
        if (this.plural != null ? !this.plural.equals(that.plural) : that.plural != null) {
            return false;
        }
        if (this.shortNames != null ? !this.shortNames.equals(that.shortNames) : that.shortNames != null) {
            return false;
        }
        if (this.singular != null ? !this.singular.equals(that.singular) : that.singular != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.categories, this.kind, this.listKind, this.plural, this.shortNames, this.singular, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.categories != null && !this.categories.isEmpty()) {
            sb.append("categories:");
            sb.append(this.categories + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.listKind != null) {
            sb.append("listKind:");
            sb.append(this.listKind + ",");
        }
        if (this.plural != null) {
            sb.append("plural:");
            sb.append(this.plural + ",");
        }
        if (this.shortNames != null && !this.shortNames.isEmpty()) {
            sb.append("shortNames:");
            sb.append(this.shortNames + ",");
        }
        if (this.singular != null) {
            sb.append("singular:");
            sb.append(this.singular + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

