/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_0;

import io.fabric8.kubernetes.api.builder.v6_0.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_0.ServiceReference;
import io.fabric8.kubernetes.api.model.v6_0.ServiceReferenceFluent;
import io.fabric8.kubernetes.api.model.v6_0.ServiceReferenceFluentImpl;

public class ServiceReferenceBuilder
extends ServiceReferenceFluentImpl<ServiceReferenceBuilder>
implements VisitableBuilder<ServiceReference, ServiceReferenceBuilder> {
    ServiceReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceReferenceBuilder() {
        this(false);
    }

    public ServiceReferenceBuilder(Boolean validationEnabled) {
        this(new ServiceReference(), validationEnabled);
    }

    public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceReference(), validationEnabled);
    }

    public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent, ServiceReference instance) {
        this(fluent, instance, false);
    }

    public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent, ServiceReference instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withPort(instance.getPort());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ServiceReferenceBuilder(ServiceReference instance) {
        this(instance, (Boolean)false);
    }

    public ServiceReferenceBuilder(ServiceReference instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withPort(instance.getPort());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ServiceReference build() {
        ServiceReference buildable = new ServiceReference(this.fluent.getName(), this.fluent.getNamespace(), this.fluent.getPort());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

