/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_0;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.kubernetes.api.model.v6_0.Capabilities;
import io.fabric8.kubernetes.api.model.v6_0.CapabilitiesBuilder;
import io.fabric8.kubernetes.api.model.v6_0.CapabilitiesFluentImpl;
import io.fabric8.kubernetes.api.model.v6_0.SELinuxOptions;
import io.fabric8.kubernetes.api.model.v6_0.SELinuxOptionsBuilder;
import io.fabric8.kubernetes.api.model.v6_0.SELinuxOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.v6_0.SeccompProfile;
import io.fabric8.kubernetes.api.model.v6_0.SeccompProfileBuilder;
import io.fabric8.kubernetes.api.model.v6_0.SeccompProfileFluentImpl;
import io.fabric8.kubernetes.api.model.v6_0.SecurityContext;
import io.fabric8.kubernetes.api.model.v6_0.SecurityContextFluent;
import io.fabric8.kubernetes.api.model.v6_0.WindowsSecurityContextOptions;
import io.fabric8.kubernetes.api.model.v6_0.WindowsSecurityContextOptionsBuilder;
import io.fabric8.kubernetes.api.model.v6_0.WindowsSecurityContextOptionsFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class SecurityContextFluentImpl<A extends SecurityContextFluent<A>>
extends BaseFluent<A>
implements SecurityContextFluent<A> {
    private Boolean allowPrivilegeEscalation;
    private CapabilitiesBuilder capabilities;
    private Boolean privileged;
    private String procMount;
    private Boolean readOnlyRootFilesystem;
    private Long runAsGroup;
    private Boolean runAsNonRoot;
    private Long runAsUser;
    private SELinuxOptionsBuilder seLinuxOptions;
    private SeccompProfileBuilder seccompProfile;
    private WindowsSecurityContextOptionsBuilder windowsOptions;
    private Map<String, Object> additionalProperties;

    public SecurityContextFluentImpl() {
    }

    public SecurityContextFluentImpl(SecurityContext instance) {
        this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
        this.withCapabilities(instance.getCapabilities());
        this.withPrivileged(instance.getPrivileged());
        this.withProcMount(instance.getProcMount());
        this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        this.withRunAsGroup(instance.getRunAsGroup());
        this.withRunAsNonRoot(instance.getRunAsNonRoot());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxOptions(instance.getSeLinuxOptions());
        this.withSeccompProfile(instance.getSeccompProfile());
        this.withWindowsOptions(instance.getWindowsOptions());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Boolean getAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    @Override
    public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        return (A)this;
    }

    @Override
    public Boolean hasAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation != null;
    }

    @Override
    @Deprecated
    public Capabilities getCapabilities() {
        return this.capabilities != null ? this.capabilities.build() : null;
    }

    @Override
    public Capabilities buildCapabilities() {
        return this.capabilities != null ? this.capabilities.build() : null;
    }

    @Override
    public A withCapabilities(Capabilities capabilities) {
        this._visitables.get("capabilities").remove(this.capabilities);
        if (capabilities != null) {
            this.capabilities = new CapabilitiesBuilder(capabilities);
            this._visitables.get("capabilities").add(this.capabilities);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCapabilities() {
        return this.capabilities != null;
    }

    @Override
    public SecurityContextFluent.CapabilitiesNested<A> withNewCapabilities() {
        return new CapabilitiesNestedImpl();
    }

    @Override
    public SecurityContextFluent.CapabilitiesNested<A> withNewCapabilitiesLike(Capabilities item) {
        return new CapabilitiesNestedImpl(item);
    }

    @Override
    public SecurityContextFluent.CapabilitiesNested<A> editCapabilities() {
        return this.withNewCapabilitiesLike(this.getCapabilities());
    }

    @Override
    public SecurityContextFluent.CapabilitiesNested<A> editOrNewCapabilities() {
        return this.withNewCapabilitiesLike(this.getCapabilities() != null ? this.getCapabilities() : new CapabilitiesBuilder().build());
    }

    @Override
    public SecurityContextFluent.CapabilitiesNested<A> editOrNewCapabilitiesLike(Capabilities item) {
        return this.withNewCapabilitiesLike(this.getCapabilities() != null ? this.getCapabilities() : item);
    }

    @Override
    public Boolean getPrivileged() {
        return this.privileged;
    }

    @Override
    public A withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return (A)this;
    }

    @Override
    public Boolean hasPrivileged() {
        return this.privileged != null;
    }

    @Override
    public String getProcMount() {
        return this.procMount;
    }

    @Override
    public A withProcMount(String procMount) {
        this.procMount = procMount;
        return (A)this;
    }

    @Override
    public Boolean hasProcMount() {
        return this.procMount != null;
    }

    @Override
    public Boolean getReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    @Override
    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem != null;
    }

    @Override
    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    @Override
    public A withRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
        return (A)this;
    }

    @Override
    public Boolean hasRunAsGroup() {
        return this.runAsGroup != null;
    }

    @Override
    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    @Override
    public A withRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return (A)this;
    }

    @Override
    public Boolean hasRunAsNonRoot() {
        return this.runAsNonRoot != null;
    }

    @Override
    public Long getRunAsUser() {
        return this.runAsUser;
    }

    @Override
    public A withRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return (A)this;
    }

    @Override
    public Boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    @Override
    @Deprecated
    public SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions != null ? this.seLinuxOptions.build() : null;
    }

    @Override
    public SELinuxOptions buildSeLinuxOptions() {
        return this.seLinuxOptions != null ? this.seLinuxOptions.build() : null;
    }

    @Override
    public A withSeLinuxOptions(SELinuxOptions seLinuxOptions) {
        this._visitables.get("seLinuxOptions").remove(this.seLinuxOptions);
        if (seLinuxOptions != null) {
            this.seLinuxOptions = new SELinuxOptionsBuilder(seLinuxOptions);
            this._visitables.get("seLinuxOptions").add(this.seLinuxOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeLinuxOptions() {
        return this.seLinuxOptions != null;
    }

    @Override
    public A withNewSeLinuxOptions(String level, String role, String type, String user) {
        return this.withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }

    @Override
    public SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions() {
        return new SeLinuxOptionsNestedImpl();
    }

    @Override
    public SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item) {
        return new SeLinuxOptionsNestedImpl(item);
    }

    @Override
    public SecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions());
    }

    @Override
    public SecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions() != null ? this.getSeLinuxOptions() : new SELinuxOptionsBuilder().build());
    }

    @Override
    public SecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SELinuxOptions item) {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions() != null ? this.getSeLinuxOptions() : item);
    }

    @Override
    @Deprecated
    public SeccompProfile getSeccompProfile() {
        return this.seccompProfile != null ? this.seccompProfile.build() : null;
    }

    @Override
    public SeccompProfile buildSeccompProfile() {
        return this.seccompProfile != null ? this.seccompProfile.build() : null;
    }

    @Override
    public A withSeccompProfile(SeccompProfile seccompProfile) {
        this._visitables.get("seccompProfile").remove(this.seccompProfile);
        if (seccompProfile != null) {
            this.seccompProfile = new SeccompProfileBuilder(seccompProfile);
            this._visitables.get("seccompProfile").add(this.seccompProfile);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeccompProfile() {
        return this.seccompProfile != null;
    }

    @Override
    public A withNewSeccompProfile(String localhostProfile, String type) {
        return this.withSeccompProfile(new SeccompProfile(localhostProfile, type));
    }

    @Override
    public SecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfile() {
        return new SeccompProfileNestedImpl();
    }

    @Override
    public SecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfileLike(SeccompProfile item) {
        return new SeccompProfileNestedImpl(item);
    }

    @Override
    public SecurityContextFluent.SeccompProfileNested<A> editSeccompProfile() {
        return this.withNewSeccompProfileLike(this.getSeccompProfile());
    }

    @Override
    public SecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfile() {
        return this.withNewSeccompProfileLike(this.getSeccompProfile() != null ? this.getSeccompProfile() : new SeccompProfileBuilder().build());
    }

    @Override
    public SecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfileLike(SeccompProfile item) {
        return this.withNewSeccompProfileLike(this.getSeccompProfile() != null ? this.getSeccompProfile() : item);
    }

    @Override
    @Deprecated
    public WindowsSecurityContextOptions getWindowsOptions() {
        return this.windowsOptions != null ? this.windowsOptions.build() : null;
    }

    @Override
    public WindowsSecurityContextOptions buildWindowsOptions() {
        return this.windowsOptions != null ? this.windowsOptions.build() : null;
    }

    @Override
    public A withWindowsOptions(WindowsSecurityContextOptions windowsOptions) {
        this._visitables.get("windowsOptions").remove(this.windowsOptions);
        if (windowsOptions != null) {
            this.windowsOptions = new WindowsSecurityContextOptionsBuilder(windowsOptions);
            this._visitables.get("windowsOptions").add(this.windowsOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasWindowsOptions() {
        return this.windowsOptions != null;
    }

    @Override
    public A withNewWindowsOptions(String gmsaCredentialSpec, String gmsaCredentialSpecName, Boolean hostProcess, String runAsUserName) {
        return this.withWindowsOptions(new WindowsSecurityContextOptions(gmsaCredentialSpec, gmsaCredentialSpecName, hostProcess, runAsUserName));
    }

    @Override
    public SecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptions() {
        return new WindowsOptionsNestedImpl();
    }

    @Override
    public SecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptionsLike(WindowsSecurityContextOptions item) {
        return new WindowsOptionsNestedImpl(item);
    }

    @Override
    public SecurityContextFluent.WindowsOptionsNested<A> editWindowsOptions() {
        return this.withNewWindowsOptionsLike(this.getWindowsOptions());
    }

    @Override
    public SecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptions() {
        return this.withNewWindowsOptionsLike(this.getWindowsOptions() != null ? this.getWindowsOptions() : new WindowsSecurityContextOptionsBuilder().build());
    }

    @Override
    public SecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptionsLike(WindowsSecurityContextOptions item) {
        return this.withNewWindowsOptionsLike(this.getWindowsOptions() != null ? this.getWindowsOptions() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityContextFluentImpl that = (SecurityContextFluentImpl)o;
        if (this.allowPrivilegeEscalation != null ? !this.allowPrivilegeEscalation.equals(that.allowPrivilegeEscalation) : that.allowPrivilegeEscalation != null) {
            return false;
        }
        if (this.capabilities != null ? !this.capabilities.equals(that.capabilities) : that.capabilities != null) {
            return false;
        }
        if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) {
            return false;
        }
        if (this.procMount != null ? !this.procMount.equals(that.procMount) : that.procMount != null) {
            return false;
        }
        if (this.readOnlyRootFilesystem != null ? !this.readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) : that.readOnlyRootFilesystem != null) {
            return false;
        }
        if (this.runAsGroup != null ? !this.runAsGroup.equals(that.runAsGroup) : that.runAsGroup != null) {
            return false;
        }
        if (this.runAsNonRoot != null ? !this.runAsNonRoot.equals(that.runAsNonRoot) : that.runAsNonRoot != null) {
            return false;
        }
        if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) {
            return false;
        }
        if (this.seLinuxOptions != null ? !this.seLinuxOptions.equals(that.seLinuxOptions) : that.seLinuxOptions != null) {
            return false;
        }
        if (this.seccompProfile != null ? !this.seccompProfile.equals(that.seccompProfile) : that.seccompProfile != null) {
            return false;
        }
        if (this.windowsOptions != null ? !this.windowsOptions.equals(that.windowsOptions) : that.windowsOptions != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allowPrivilegeEscalation, this.capabilities, this.privileged, this.procMount, this.readOnlyRootFilesystem, this.runAsGroup, this.runAsNonRoot, this.runAsUser, this.seLinuxOptions, this.seccompProfile, this.windowsOptions, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowPrivilegeEscalation != null) {
            sb.append("allowPrivilegeEscalation:");
            sb.append(this.allowPrivilegeEscalation + ",");
        }
        if (this.capabilities != null) {
            sb.append("capabilities:");
            sb.append(this.capabilities + ",");
        }
        if (this.privileged != null) {
            sb.append("privileged:");
            sb.append(this.privileged + ",");
        }
        if (this.procMount != null) {
            sb.append("procMount:");
            sb.append(this.procMount + ",");
        }
        if (this.readOnlyRootFilesystem != null) {
            sb.append("readOnlyRootFilesystem:");
            sb.append(this.readOnlyRootFilesystem + ",");
        }
        if (this.runAsGroup != null) {
            sb.append("runAsGroup:");
            sb.append(this.runAsGroup + ",");
        }
        if (this.runAsNonRoot != null) {
            sb.append("runAsNonRoot:");
            sb.append(this.runAsNonRoot + ",");
        }
        if (this.runAsUser != null) {
            sb.append("runAsUser:");
            sb.append(this.runAsUser + ",");
        }
        if (this.seLinuxOptions != null) {
            sb.append("seLinuxOptions:");
            sb.append(this.seLinuxOptions + ",");
        }
        if (this.seccompProfile != null) {
            sb.append("seccompProfile:");
            sb.append(this.seccompProfile + ",");
        }
        if (this.windowsOptions != null) {
            sb.append("windowsOptions:");
            sb.append(this.windowsOptions + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withAllowPrivilegeEscalation() {
        return this.withAllowPrivilegeEscalation(true);
    }

    @Override
    public A withPrivileged() {
        return this.withPrivileged(true);
    }

    @Override
    public A withReadOnlyRootFilesystem() {
        return this.withReadOnlyRootFilesystem(true);
    }

    @Override
    public A withRunAsNonRoot() {
        return this.withRunAsNonRoot(true);
    }

    class WindowsOptionsNestedImpl<N>
    extends WindowsSecurityContextOptionsFluentImpl<SecurityContextFluent.WindowsOptionsNested<N>>
    implements SecurityContextFluent.WindowsOptionsNested<N>,
    Nested<N> {
        WindowsSecurityContextOptionsBuilder builder;

        WindowsOptionsNestedImpl(WindowsSecurityContextOptions item) {
            this.builder = new WindowsSecurityContextOptionsBuilder(this, item);
        }

        WindowsOptionsNestedImpl() {
            this.builder = new WindowsSecurityContextOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecurityContextFluentImpl.this.withWindowsOptions(this.builder.build());
        }

        @Override
        public N endWindowsOptions() {
            return this.and();
        }
    }

    class SeccompProfileNestedImpl<N>
    extends SeccompProfileFluentImpl<SecurityContextFluent.SeccompProfileNested<N>>
    implements SecurityContextFluent.SeccompProfileNested<N>,
    Nested<N> {
        SeccompProfileBuilder builder;

        SeccompProfileNestedImpl(SeccompProfile item) {
            this.builder = new SeccompProfileBuilder(this, item);
        }

        SeccompProfileNestedImpl() {
            this.builder = new SeccompProfileBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecurityContextFluentImpl.this.withSeccompProfile(this.builder.build());
        }

        @Override
        public N endSeccompProfile() {
            return this.and();
        }
    }

    class SeLinuxOptionsNestedImpl<N>
    extends SELinuxOptionsFluentImpl<SecurityContextFluent.SeLinuxOptionsNested<N>>
    implements SecurityContextFluent.SeLinuxOptionsNested<N>,
    Nested<N> {
        SELinuxOptionsBuilder builder;

        SeLinuxOptionsNestedImpl(SELinuxOptions item) {
            this.builder = new SELinuxOptionsBuilder(this, item);
        }

        SeLinuxOptionsNestedImpl() {
            this.builder = new SELinuxOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecurityContextFluentImpl.this.withSeLinuxOptions(this.builder.build());
        }

        @Override
        public N endSeLinuxOptions() {
            return this.and();
        }
    }

    class CapabilitiesNestedImpl<N>
    extends CapabilitiesFluentImpl<SecurityContextFluent.CapabilitiesNested<N>>
    implements SecurityContextFluent.CapabilitiesNested<N>,
    Nested<N> {
        CapabilitiesBuilder builder;

        CapabilitiesNestedImpl(Capabilities item) {
            this.builder = new CapabilitiesBuilder(this, item);
        }

        CapabilitiesNestedImpl() {
            this.builder = new CapabilitiesBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecurityContextFluentImpl.this.withCapabilities(this.builder.build());
        }

        @Override
        public N endCapabilities() {
            return this.and();
        }
    }
}

