/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_0;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.kubernetes.api.model.v6_0.FieldsV1;
import io.fabric8.kubernetes.api.model.v6_0.FieldsV1Builder;
import io.fabric8.kubernetes.api.model.v6_0.FieldsV1FluentImpl;
import io.fabric8.kubernetes.api.model.v6_0.ManagedFieldsEntry;
import io.fabric8.kubernetes.api.model.v6_0.ManagedFieldsEntryFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ManagedFieldsEntryFluentImpl<A extends ManagedFieldsEntryFluent<A>>
extends BaseFluent<A>
implements ManagedFieldsEntryFluent<A> {
    private String apiVersion;
    private String fieldsType;
    private FieldsV1Builder fieldsV1;
    private String manager;
    private String operation;
    private String subresource;
    private String time;
    private Map<String, Object> additionalProperties;

    public ManagedFieldsEntryFluentImpl() {
    }

    public ManagedFieldsEntryFluentImpl(ManagedFieldsEntry instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withFieldsType(instance.getFieldsType());
        this.withFieldsV1(instance.getFieldsV1());
        this.withManager(instance.getManager());
        this.withOperation(instance.getOperation());
        this.withSubresource(instance.getSubresource());
        this.withTime(instance.getTime());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getFieldsType() {
        return this.fieldsType;
    }

    @Override
    public A withFieldsType(String fieldsType) {
        this.fieldsType = fieldsType;
        return (A)this;
    }

    @Override
    public Boolean hasFieldsType() {
        return this.fieldsType != null;
    }

    @Override
    @Deprecated
    public FieldsV1 getFieldsV1() {
        return this.fieldsV1 != null ? this.fieldsV1.build() : null;
    }

    @Override
    public FieldsV1 buildFieldsV1() {
        return this.fieldsV1 != null ? this.fieldsV1.build() : null;
    }

    @Override
    public A withFieldsV1(FieldsV1 fieldsV1) {
        this._visitables.get("fieldsV1").remove(this.fieldsV1);
        if (fieldsV1 != null) {
            this.fieldsV1 = new FieldsV1Builder(fieldsV1);
            this._visitables.get("fieldsV1").add(this.fieldsV1);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFieldsV1() {
        return this.fieldsV1 != null;
    }

    @Override
    public ManagedFieldsEntryFluent.FieldsV1Nested<A> withNewFieldsV1() {
        return new FieldsV1NestedImpl();
    }

    @Override
    public ManagedFieldsEntryFluent.FieldsV1Nested<A> withNewFieldsV1Like(FieldsV1 item) {
        return new FieldsV1NestedImpl(item);
    }

    @Override
    public ManagedFieldsEntryFluent.FieldsV1Nested<A> editFieldsV1() {
        return this.withNewFieldsV1Like(this.getFieldsV1());
    }

    @Override
    public ManagedFieldsEntryFluent.FieldsV1Nested<A> editOrNewFieldsV1() {
        return this.withNewFieldsV1Like(this.getFieldsV1() != null ? this.getFieldsV1() : new FieldsV1Builder().build());
    }

    @Override
    public ManagedFieldsEntryFluent.FieldsV1Nested<A> editOrNewFieldsV1Like(FieldsV1 item) {
        return this.withNewFieldsV1Like(this.getFieldsV1() != null ? this.getFieldsV1() : item);
    }

    @Override
    public String getManager() {
        return this.manager;
    }

    @Override
    public A withManager(String manager) {
        this.manager = manager;
        return (A)this;
    }

    @Override
    public Boolean hasManager() {
        return this.manager != null;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    @Override
    public A withOperation(String operation) {
        this.operation = operation;
        return (A)this;
    }

    @Override
    public Boolean hasOperation() {
        return this.operation != null;
    }

    @Override
    public String getSubresource() {
        return this.subresource;
    }

    @Override
    public A withSubresource(String subresource) {
        this.subresource = subresource;
        return (A)this;
    }

    @Override
    public Boolean hasSubresource() {
        return this.subresource != null;
    }

    @Override
    public String getTime() {
        return this.time;
    }

    @Override
    public A withTime(String time) {
        this.time = time;
        return (A)this;
    }

    @Override
    public Boolean hasTime() {
        return this.time != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagedFieldsEntryFluentImpl that = (ManagedFieldsEntryFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.fieldsType != null ? !this.fieldsType.equals(that.fieldsType) : that.fieldsType != null) {
            return false;
        }
        if (this.fieldsV1 != null ? !this.fieldsV1.equals(that.fieldsV1) : that.fieldsV1 != null) {
            return false;
        }
        if (this.manager != null ? !this.manager.equals(that.manager) : that.manager != null) {
            return false;
        }
        if (this.operation != null ? !this.operation.equals(that.operation) : that.operation != null) {
            return false;
        }
        if (this.subresource != null ? !this.subresource.equals(that.subresource) : that.subresource != null) {
            return false;
        }
        if (this.time != null ? !this.time.equals(that.time) : that.time != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.fieldsType, this.fieldsV1, this.manager, this.operation, this.subresource, this.time, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.fieldsType != null) {
            sb.append("fieldsType:");
            sb.append(this.fieldsType + ",");
        }
        if (this.fieldsV1 != null) {
            sb.append("fieldsV1:");
            sb.append(this.fieldsV1 + ",");
        }
        if (this.manager != null) {
            sb.append("manager:");
            sb.append(this.manager + ",");
        }
        if (this.operation != null) {
            sb.append("operation:");
            sb.append(this.operation + ",");
        }
        if (this.subresource != null) {
            sb.append("subresource:");
            sb.append(this.subresource + ",");
        }
        if (this.time != null) {
            sb.append("time:");
            sb.append(this.time + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class FieldsV1NestedImpl<N>
    extends FieldsV1FluentImpl<ManagedFieldsEntryFluent.FieldsV1Nested<N>>
    implements ManagedFieldsEntryFluent.FieldsV1Nested<N>,
    Nested<N> {
        FieldsV1Builder builder;

        FieldsV1NestedImpl(FieldsV1 item) {
            this.builder = new FieldsV1Builder(this, item);
        }

        FieldsV1NestedImpl() {
            this.builder = new FieldsV1Builder(this);
        }

        @Override
        public N and() {
            return (N)ManagedFieldsEntryFluentImpl.this.withFieldsV1(this.builder.build());
        }

        @Override
        public N endFieldsV1() {
            return this.and();
        }
    }
}

