/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_0;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.kubernetes.api.model.v6_0.LimitRange;
import io.fabric8.kubernetes.api.model.v6_0.LimitRangeBuilder;
import io.fabric8.kubernetes.api.model.v6_0.LimitRangeFluentImpl;
import io.fabric8.kubernetes.api.model.v6_0.LimitRangeList;
import io.fabric8.kubernetes.api.model.v6_0.LimitRangeListFluent;
import io.fabric8.kubernetes.api.model.v6_0.ListMeta;
import io.fabric8.kubernetes.api.model.v6_0.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.v6_0.ListMetaFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class LimitRangeListFluentImpl<A extends LimitRangeListFluent<A>>
extends BaseFluent<A>
implements LimitRangeListFluent<A> {
    private String apiVersion;
    private ArrayList<LimitRangeBuilder> items = new ArrayList();
    private String kind;
    private ListMetaBuilder metadata;
    private Map<String, Object> additionalProperties;

    public LimitRangeListFluentImpl() {
    }

    public LimitRangeListFluentImpl(LimitRangeList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(Integer index, LimitRange item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        LimitRangeBuilder builder = new LimitRangeBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index.intValue() : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index.intValue() : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(Integer index, LimitRange item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        LimitRangeBuilder builder = new LimitRangeBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(LimitRange ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (LimitRange item : items) {
            LimitRangeBuilder builder = new LimitRangeBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<LimitRange> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (LimitRange item : items) {
            LimitRangeBuilder builder = new LimitRangeBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(LimitRange ... items) {
        for (LimitRange item : items) {
            LimitRangeBuilder builder = new LimitRangeBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<LimitRange> items) {
        for (LimitRange item : items) {
            LimitRangeBuilder builder = new LimitRangeBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<LimitRangeBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<LimitRangeBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            LimitRangeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<LimitRange> getItems() {
        return this.items != null ? LimitRangeListFluentImpl.build(this.items) : null;
    }

    @Override
    public List<LimitRange> buildItems() {
        return this.items != null ? LimitRangeListFluentImpl.build(this.items) : null;
    }

    @Override
    public LimitRange buildItem(Integer index) {
        return this.items.get(index).build();
    }

    @Override
    public LimitRange buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public LimitRange buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public LimitRange buildMatchingItem(Predicate<LimitRangeBuilder> predicate) {
        for (LimitRangeBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<LimitRangeBuilder> predicate) {
        for (LimitRangeBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<LimitRange> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList();
            for (LimitRange item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(LimitRange ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (LimitRange item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public LimitRangeListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public LimitRangeListFluent.ItemsNested<A> addNewItemLike(LimitRange item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public LimitRangeListFluent.ItemsNested<A> setNewItemLike(Integer index, LimitRange item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public LimitRangeListFluent.ItemsNested<A> editItem(Integer index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public LimitRangeListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public LimitRangeListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public LimitRangeListFluent.ItemsNested<A> editMatchingItem(Predicate<LimitRangeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ListMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ListMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    @Override
    public LimitRangeListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public LimitRangeListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public LimitRangeListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public LimitRangeListFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ListMetaBuilder().build());
    }

    @Override
    public LimitRangeListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LimitRangeListFluentImpl that = (LimitRangeListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(this.items + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<LimitRangeListFluent.MetadataNested<N>>
    implements LimitRangeListFluent.MetadataNested<N>,
    Nested<N> {
        ListMetaBuilder builder;

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)LimitRangeListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    class ItemsNestedImpl<N>
    extends LimitRangeFluentImpl<LimitRangeListFluent.ItemsNested<N>>
    implements LimitRangeListFluent.ItemsNested<N>,
    Nested<N> {
        LimitRangeBuilder builder;
        Integer index;

        ItemsNestedImpl(Integer index, LimitRange item) {
            this.index = index;
            this.builder = new LimitRangeBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new LimitRangeBuilder(this);
        }

        @Override
        public N and() {
            return (N)LimitRangeListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

