/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_0;

import io.fabric8.kubernetes.api.builder.v6_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_0.Nested;
import io.fabric8.kubernetes.api.model.v6_0.DeleteOptions;
import io.fabric8.kubernetes.api.model.v6_0.DeleteOptionsFluent;
import io.fabric8.kubernetes.api.model.v6_0.Preconditions;
import io.fabric8.kubernetes.api.model.v6_0.PreconditionsBuilder;
import io.fabric8.kubernetes.api.model.v6_0.PreconditionsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DeleteOptionsFluentImpl<A extends DeleteOptionsFluent<A>>
extends BaseFluent<A>
implements DeleteOptionsFluent<A> {
    private String apiVersion;
    private List<String> dryRun = new ArrayList<String>();
    private Long gracePeriodSeconds;
    private String kind;
    private Boolean orphanDependents;
    private PreconditionsBuilder preconditions;
    private String propagationPolicy;
    private Map<String, Object> additionalProperties;

    public DeleteOptionsFluentImpl() {
    }

    public DeleteOptionsFluentImpl(DeleteOptions instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withDryRun(instance.getDryRun());
        this.withGracePeriodSeconds(instance.getGracePeriodSeconds());
        this.withKind(instance.getKind());
        this.withOrphanDependents(instance.getOrphanDependents());
        this.withPreconditions(instance.getPreconditions());
        this.withPropagationPolicy(instance.getPropagationPolicy());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToDryRun(Integer index, String item) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDryRun(Integer index, String item) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDryRun(String ... items) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        for (String item : items) {
            this.dryRun.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDryRun(Collection<String> items) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        for (String item : items) {
            this.dryRun.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDryRun(String ... items) {
        for (String item : items) {
            if (this.dryRun == null) continue;
            this.dryRun.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDryRun(Collection<String> items) {
        for (String item : items) {
            if (this.dryRun == null) continue;
            this.dryRun.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDryRun() {
        return this.dryRun;
    }

    @Override
    public String getDryRun(Integer index) {
        return this.dryRun.get(index);
    }

    @Override
    public String getFirstDryRun() {
        return this.dryRun.get(0);
    }

    @Override
    public String getLastDryRun() {
        return this.dryRun.get(this.dryRun.size() - 1);
    }

    @Override
    public String getMatchingDryRun(Predicate<String> predicate) {
        for (String item : this.dryRun) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDryRun(Predicate<String> predicate) {
        for (String item : this.dryRun) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDryRun(List<String> dryRun) {
        if (dryRun != null) {
            this.dryRun = new ArrayList<String>();
            for (String item : dryRun) {
                this.addToDryRun(item);
            }
        } else {
            this.dryRun = null;
        }
        return (A)this;
    }

    @Override
    public A withDryRun(String ... dryRun) {
        if (this.dryRun != null) {
            this.dryRun.clear();
        }
        if (dryRun != null) {
            for (String item : dryRun) {
                this.addToDryRun(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDryRun() {
        return this.dryRun != null && !this.dryRun.isEmpty();
    }

    @Override
    public Long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    @Override
    public A withGracePeriodSeconds(Long gracePeriodSeconds) {
        this.gracePeriodSeconds = gracePeriodSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasGracePeriodSeconds() {
        return this.gracePeriodSeconds != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public Boolean getOrphanDependents() {
        return this.orphanDependents;
    }

    @Override
    public A withOrphanDependents(Boolean orphanDependents) {
        this.orphanDependents = orphanDependents;
        return (A)this;
    }

    @Override
    public Boolean hasOrphanDependents() {
        return this.orphanDependents != null;
    }

    @Override
    @Deprecated
    public Preconditions getPreconditions() {
        return this.preconditions != null ? this.preconditions.build() : null;
    }

    @Override
    public Preconditions buildPreconditions() {
        return this.preconditions != null ? this.preconditions.build() : null;
    }

    @Override
    public A withPreconditions(Preconditions preconditions) {
        this._visitables.get("preconditions").remove(this.preconditions);
        if (preconditions != null) {
            this.preconditions = new PreconditionsBuilder(preconditions);
            this._visitables.get("preconditions").add(this.preconditions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPreconditions() {
        return this.preconditions != null;
    }

    @Override
    public A withNewPreconditions(String resourceVersion, String uid) {
        return this.withPreconditions(new Preconditions(resourceVersion, uid));
    }

    @Override
    public DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditions() {
        return new PreconditionsNestedImpl();
    }

    @Override
    public DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditionsLike(Preconditions item) {
        return new PreconditionsNestedImpl(item);
    }

    @Override
    public DeleteOptionsFluent.PreconditionsNested<A> editPreconditions() {
        return this.withNewPreconditionsLike(this.getPreconditions());
    }

    @Override
    public DeleteOptionsFluent.PreconditionsNested<A> editOrNewPreconditions() {
        return this.withNewPreconditionsLike(this.getPreconditions() != null ? this.getPreconditions() : new PreconditionsBuilder().build());
    }

    @Override
    public DeleteOptionsFluent.PreconditionsNested<A> editOrNewPreconditionsLike(Preconditions item) {
        return this.withNewPreconditionsLike(this.getPreconditions() != null ? this.getPreconditions() : item);
    }

    @Override
    public String getPropagationPolicy() {
        return this.propagationPolicy;
    }

    @Override
    public A withPropagationPolicy(String propagationPolicy) {
        this.propagationPolicy = propagationPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasPropagationPolicy() {
        return this.propagationPolicy != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteOptionsFluentImpl that = (DeleteOptionsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.dryRun != null ? !this.dryRun.equals(that.dryRun) : that.dryRun != null) {
            return false;
        }
        if (this.gracePeriodSeconds != null ? !this.gracePeriodSeconds.equals(that.gracePeriodSeconds) : that.gracePeriodSeconds != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.orphanDependents != null ? !this.orphanDependents.equals(that.orphanDependents) : that.orphanDependents != null) {
            return false;
        }
        if (this.preconditions != null ? !this.preconditions.equals(that.preconditions) : that.preconditions != null) {
            return false;
        }
        if (this.propagationPolicy != null ? !this.propagationPolicy.equals(that.propagationPolicy) : that.propagationPolicy != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.dryRun, this.gracePeriodSeconds, this.kind, this.orphanDependents, this.preconditions, this.propagationPolicy, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.dryRun != null && !this.dryRun.isEmpty()) {
            sb.append("dryRun:");
            sb.append(this.dryRun + ",");
        }
        if (this.gracePeriodSeconds != null) {
            sb.append("gracePeriodSeconds:");
            sb.append(this.gracePeriodSeconds + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.orphanDependents != null) {
            sb.append("orphanDependents:");
            sb.append(this.orphanDependents + ",");
        }
        if (this.preconditions != null) {
            sb.append("preconditions:");
            sb.append(this.preconditions + ",");
        }
        if (this.propagationPolicy != null) {
            sb.append("propagationPolicy:");
            sb.append(this.propagationPolicy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withOrphanDependents() {
        return this.withOrphanDependents(true);
    }

    class PreconditionsNestedImpl<N>
    extends PreconditionsFluentImpl<DeleteOptionsFluent.PreconditionsNested<N>>
    implements DeleteOptionsFluent.PreconditionsNested<N>,
    Nested<N> {
        PreconditionsBuilder builder;

        PreconditionsNestedImpl(Preconditions item) {
            this.builder = new PreconditionsBuilder(this, item);
        }

        PreconditionsNestedImpl() {
            this.builder = new PreconditionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeleteOptionsFluentImpl.this.withPreconditions(this.builder.build());
        }

        @Override
        public N endPreconditions() {
            return this.and();
        }
    }
}

