/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_0;

import io.fabric8.kubernetes.api.builder.v6_0.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_0.APIGroup;
import io.fabric8.kubernetes.api.model.v6_0.APIGroupFluent;
import io.fabric8.kubernetes.api.model.v6_0.APIGroupFluentImpl;

public class APIGroupBuilder
extends APIGroupFluentImpl<APIGroupBuilder>
implements VisitableBuilder<APIGroup, APIGroupBuilder> {
    APIGroupFluent<?> fluent;
    Boolean validationEnabled;

    public APIGroupBuilder() {
        this(false);
    }

    public APIGroupBuilder(Boolean validationEnabled) {
        this(new APIGroup(), validationEnabled);
    }

    public APIGroupBuilder(APIGroupFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public APIGroupBuilder(APIGroupFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new APIGroup(), validationEnabled);
    }

    public APIGroupBuilder(APIGroupFluent<?> fluent, APIGroup instance) {
        this(fluent, instance, false);
    }

    public APIGroupBuilder(APIGroupFluent<?> fluent, APIGroup instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withPreferredVersion(instance.getPreferredVersion());
        fluent.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
        fluent.withVersions(instance.getVersions());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public APIGroupBuilder(APIGroup instance) {
        this(instance, (Boolean)false);
    }

    public APIGroupBuilder(APIGroup instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withPreferredVersion(instance.getPreferredVersion());
        this.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
        this.withVersions(instance.getVersions());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public APIGroup build() {
        APIGroup buildable = new APIGroup(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getName(), this.fluent.getPreferredVersion(), this.fluent.getServerAddressByClientCIDRs(), this.fluent.getVersions());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

