/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.operator.v1.StorageSpec;
import io.fabric8.openshift.api.model.operator.v1.StorageSpecFluent;
import io.fabric8.openshift.api.model.operator.v1.StorageSpecFluentImpl;
import java.util.Objects;

public class StorageSpecBuilder
extends StorageSpecFluentImpl<StorageSpecBuilder>
implements VisitableBuilder<StorageSpec, StorageSpecBuilder> {
    StorageSpecFluent<?> fluent;
    Boolean validationEnabled;

    public StorageSpecBuilder() {
        this(false);
    }

    public StorageSpecBuilder(Boolean validationEnabled) {
        this(new StorageSpec(), validationEnabled);
    }

    public StorageSpecBuilder(StorageSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public StorageSpecBuilder(StorageSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StorageSpec(), validationEnabled);
    }

    public StorageSpecBuilder(StorageSpecFluent<?> fluent, StorageSpec instance) {
        this(fluent, instance, false);
    }

    public StorageSpecBuilder(StorageSpecFluent<?> fluent, StorageSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLogLevel(instance.getLogLevel());
        fluent.withManagementState(instance.getManagementState());
        fluent.withObservedConfig(instance.getObservedConfig());
        fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
        fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
        this.validationEnabled = validationEnabled;
    }

    public StorageSpecBuilder(StorageSpec instance) {
        this(instance, (Boolean)false);
    }

    public StorageSpecBuilder(StorageSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLogLevel(instance.getLogLevel());
        this.withManagementState(instance.getManagementState());
        this.withObservedConfig(instance.getObservedConfig());
        this.withOperatorLogLevel(instance.getOperatorLogLevel());
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public StorageSpec build() {
        StorageSpec buildable = new StorageSpec(this.fluent.getLogLevel(), this.fluent.getManagementState(), this.fluent.getObservedConfig(), this.fluent.getOperatorLogLevel(), this.fluent.getUnsupportedConfigOverrides());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StorageSpecBuilder that = (StorageSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

