/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_9.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.v5_9.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_9.operatorhub.v1alpha1.ResourceInstance;
import io.fabric8.openshift.api.model.v5_9.operatorhub.v1alpha1.ResourceInstanceFluent;
import io.fabric8.openshift.api.model.v5_9.operatorhub.v1alpha1.ResourceInstanceFluentImpl;
import java.util.Objects;

public class ResourceInstanceBuilder
extends ResourceInstanceFluentImpl<ResourceInstanceBuilder>
implements VisitableBuilder<ResourceInstance, ResourceInstanceBuilder> {
    ResourceInstanceFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceInstanceBuilder() {
        this(false);
    }

    public ResourceInstanceBuilder(Boolean validationEnabled) {
        this(new ResourceInstance(), validationEnabled);
    }

    public ResourceInstanceBuilder(ResourceInstanceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ResourceInstanceBuilder(ResourceInstanceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceInstance(), validationEnabled);
    }

    public ResourceInstanceBuilder(ResourceInstanceFluent<?> fluent, ResourceInstance instance) {
        this(fluent, instance, false);
    }

    public ResourceInstanceBuilder(ResourceInstanceFluent<?> fluent, ResourceInstance instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        this.validationEnabled = validationEnabled;
    }

    public ResourceInstanceBuilder(ResourceInstance instance) {
        this(instance, (Boolean)false);
    }

    public ResourceInstanceBuilder(ResourceInstance instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ResourceInstance build() {
        ResourceInstance buildable = new ResourceInstance(this.fluent.getName(), this.fluent.getNamespace());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceInstanceBuilder that = (ResourceInstanceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

