/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_9.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.v5_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_9.Nested;
import io.fabric8.kubernetes.api.model.v5_9.ListMeta;
import io.fabric8.openshift.api.model.v5_9.operatorhub.v1alpha1.ClusterServiceVersion;
import io.fabric8.openshift.api.model.v5_9.operatorhub.v1alpha1.ClusterServiceVersionBuilder;
import io.fabric8.openshift.api.model.v5_9.operatorhub.v1alpha1.ClusterServiceVersionFluentImpl;
import io.fabric8.openshift.api.model.v5_9.operatorhub.v1alpha1.ClusterServiceVersionList;
import io.fabric8.openshift.api.model.v5_9.operatorhub.v1alpha1.ClusterServiceVersionListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterServiceVersionListFluentImpl<A extends ClusterServiceVersionListFluent<A>>
extends BaseFluent<A>
implements ClusterServiceVersionListFluent<A> {
    private String apiVersion;
    private List<ClusterServiceVersionBuilder> items = new ArrayList<ClusterServiceVersionBuilder>();
    private String kind;
    private ListMeta metadata;

    public ClusterServiceVersionListFluentImpl() {
    }

    public ClusterServiceVersionListFluentImpl(ClusterServiceVersionList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToItems(Integer index, ClusterServiceVersion item) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterServiceVersionBuilder>();
        }
        ClusterServiceVersionBuilder builder = new ClusterServiceVersionBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index.intValue() : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index.intValue() : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(Integer index, ClusterServiceVersion item) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterServiceVersionBuilder>();
        }
        ClusterServiceVersionBuilder builder = new ClusterServiceVersionBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(ClusterServiceVersion ... items) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterServiceVersionBuilder>();
        }
        for (ClusterServiceVersion item : items) {
            ClusterServiceVersionBuilder builder = new ClusterServiceVersionBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<ClusterServiceVersion> items) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterServiceVersionBuilder>();
        }
        for (ClusterServiceVersion item : items) {
            ClusterServiceVersionBuilder builder = new ClusterServiceVersionBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ClusterServiceVersion ... items) {
        for (ClusterServiceVersion item : items) {
            ClusterServiceVersionBuilder builder = new ClusterServiceVersionBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<ClusterServiceVersion> items) {
        for (ClusterServiceVersion item : items) {
            ClusterServiceVersionBuilder builder = new ClusterServiceVersionBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<ClusterServiceVersionBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<ClusterServiceVersionBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            ClusterServiceVersionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClusterServiceVersion> getItems() {
        return ClusterServiceVersionListFluentImpl.build(this.items);
    }

    @Override
    public List<ClusterServiceVersion> buildItems() {
        return ClusterServiceVersionListFluentImpl.build(this.items);
    }

    @Override
    public ClusterServiceVersion buildItem(Integer index) {
        return this.items.get(index).build();
    }

    @Override
    public ClusterServiceVersion buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public ClusterServiceVersion buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public ClusterServiceVersion buildMatchingItem(Predicate<ClusterServiceVersionBuilder> predicate) {
        for (ClusterServiceVersionBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ClusterServiceVersionBuilder> predicate) {
        for (ClusterServiceVersionBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<ClusterServiceVersion> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<ClusterServiceVersionBuilder>();
            for (ClusterServiceVersion item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(ClusterServiceVersion ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (ClusterServiceVersion item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ClusterServiceVersionListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ClusterServiceVersionListFluent.ItemsNested<A> addNewItemLike(ClusterServiceVersion item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ClusterServiceVersionListFluent.ItemsNested<A> setNewItemLike(Integer index, ClusterServiceVersion item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ClusterServiceVersionListFluent.ItemsNested<A> editItem(Integer index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ClusterServiceVersionListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ClusterServiceVersionListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ClusterServiceVersionListFluent.ItemsNested<A> editMatchingItem(Predicate<ClusterServiceVersionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterServiceVersionListFluentImpl that = (ClusterServiceVersionListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends ClusterServiceVersionFluentImpl<ClusterServiceVersionListFluent.ItemsNested<N>>
    implements ClusterServiceVersionListFluent.ItemsNested<N>,
    Nested<N> {
        ClusterServiceVersionBuilder builder;
        Integer index;

        ItemsNestedImpl(Integer index, ClusterServiceVersion item) {
            this.index = index;
            this.builder = new ClusterServiceVersionBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ClusterServiceVersionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterServiceVersionListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

