/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_9.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_9.BaseFluent;
import io.fabric8.openshift.api.model.v5_9.operator.v1.ProjectAccess;
import io.fabric8.openshift.api.model.v5_9.operator.v1.ProjectAccessFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ProjectAccessFluentImpl<A extends ProjectAccessFluent<A>>
extends BaseFluent<A>
implements ProjectAccessFluent<A> {
    private List<String> availableClusterRoles = new ArrayList<String>();

    public ProjectAccessFluentImpl() {
    }

    public ProjectAccessFluentImpl(ProjectAccess instance) {
        this.withAvailableClusterRoles(instance.getAvailableClusterRoles());
    }

    @Override
    public A addToAvailableClusterRoles(Integer index, String item) {
        if (this.availableClusterRoles == null) {
            this.availableClusterRoles = new ArrayList<String>();
        }
        this.availableClusterRoles.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAvailableClusterRoles(Integer index, String item) {
        if (this.availableClusterRoles == null) {
            this.availableClusterRoles = new ArrayList<String>();
        }
        this.availableClusterRoles.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAvailableClusterRoles(String ... items) {
        if (this.availableClusterRoles == null) {
            this.availableClusterRoles = new ArrayList<String>();
        }
        for (String item : items) {
            this.availableClusterRoles.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAvailableClusterRoles(Collection<String> items) {
        if (this.availableClusterRoles == null) {
            this.availableClusterRoles = new ArrayList<String>();
        }
        for (String item : items) {
            this.availableClusterRoles.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAvailableClusterRoles(String ... items) {
        for (String item : items) {
            if (this.availableClusterRoles == null) continue;
            this.availableClusterRoles.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAvailableClusterRoles(Collection<String> items) {
        for (String item : items) {
            if (this.availableClusterRoles == null) continue;
            this.availableClusterRoles.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAvailableClusterRoles() {
        return this.availableClusterRoles;
    }

    @Override
    public String getAvailableClusterRole(Integer index) {
        return this.availableClusterRoles.get(index);
    }

    @Override
    public String getFirstAvailableClusterRole() {
        return this.availableClusterRoles.get(0);
    }

    @Override
    public String getLastAvailableClusterRole() {
        return this.availableClusterRoles.get(this.availableClusterRoles.size() - 1);
    }

    @Override
    public String getMatchingAvailableClusterRole(Predicate<String> predicate) {
        for (String item : this.availableClusterRoles) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAvailableClusterRole(Predicate<String> predicate) {
        for (String item : this.availableClusterRoles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAvailableClusterRoles(List<String> availableClusterRoles) {
        if (availableClusterRoles != null) {
            this.availableClusterRoles = new ArrayList<String>();
            for (String item : availableClusterRoles) {
                this.addToAvailableClusterRoles(item);
            }
        } else {
            this.availableClusterRoles = null;
        }
        return (A)this;
    }

    @Override
    public A withAvailableClusterRoles(String ... availableClusterRoles) {
        if (this.availableClusterRoles != null) {
            this.availableClusterRoles.clear();
        }
        if (availableClusterRoles != null) {
            for (String item : availableClusterRoles) {
                this.addToAvailableClusterRoles(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAvailableClusterRoles() {
        return this.availableClusterRoles != null && !this.availableClusterRoles.isEmpty();
    }

    @Override
    public A addNewAvailableClusterRole(String arg0) {
        return this.addToAvailableClusterRoles(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectAccessFluentImpl that = (ProjectAccessFluentImpl)o;
        return !(this.availableClusterRoles != null ? !this.availableClusterRoles.equals(that.availableClusterRoles) : that.availableClusterRoles != null);
    }

    public int hashCode() {
        return Objects.hash(this.availableClusterRoles, super.hashCode());
    }
}

