/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_9.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_9.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_9.operator.v1.ConfigSpec;
import io.fabric8.openshift.api.model.v5_9.operator.v1.ConfigSpecFluent;
import io.fabric8.openshift.api.model.v5_9.operator.v1.ConfigSpecFluentImpl;
import java.util.Objects;

public class ConfigSpecBuilder
extends ConfigSpecFluentImpl<ConfigSpecBuilder>
implements VisitableBuilder<ConfigSpec, ConfigSpecBuilder> {
    ConfigSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ConfigSpecBuilder() {
        this(false);
    }

    public ConfigSpecBuilder(Boolean validationEnabled) {
        this(new ConfigSpec(), validationEnabled);
    }

    public ConfigSpecBuilder(ConfigSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ConfigSpecBuilder(ConfigSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ConfigSpec(), validationEnabled);
    }

    public ConfigSpecBuilder(ConfigSpecFluent<?> fluent, ConfigSpec instance) {
        this(fluent, instance, false);
    }

    public ConfigSpecBuilder(ConfigSpecFluent<?> fluent, ConfigSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLogLevel(instance.getLogLevel());
        fluent.withManagementState(instance.getManagementState());
        fluent.withObservedConfig(instance.getObservedConfig());
        fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
        fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
        this.validationEnabled = validationEnabled;
    }

    public ConfigSpecBuilder(ConfigSpec instance) {
        this(instance, (Boolean)false);
    }

    public ConfigSpecBuilder(ConfigSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLogLevel(instance.getLogLevel());
        this.withManagementState(instance.getManagementState());
        this.withObservedConfig(instance.getObservedConfig());
        this.withOperatorLogLevel(instance.getOperatorLogLevel());
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ConfigSpec build() {
        ConfigSpec buildable = new ConfigSpec(this.fluent.getLogLevel(), this.fluent.getManagementState(), this.fluent.getObservedConfig(), this.fluent.getOperatorLogLevel(), this.fluent.getUnsupportedConfigOverrides());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigSpecBuilder that = (ConfigSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

