/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_9.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_9.Nested;
import io.fabric8.openshift.api.model.v5_9.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageS3;
import io.fabric8.openshift.api.model.v5_9.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageS3CloudFront;
import io.fabric8.openshift.api.model.v5_9.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageS3CloudFrontBuilder;
import io.fabric8.openshift.api.model.v5_9.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageS3CloudFrontFluentImpl;
import io.fabric8.openshift.api.model.v5_9.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageS3Fluent;
import java.util.Objects;

public class ImageRegistryConfigStorageS3FluentImpl<A extends ImageRegistryConfigStorageS3Fluent<A>>
extends BaseFluent<A>
implements ImageRegistryConfigStorageS3Fluent<A> {
    private String bucket;
    private ImageRegistryConfigStorageS3CloudFrontBuilder cloudFront;
    private Boolean encrypt;
    private String keyID;
    private String region;
    private String regionEndpoint;
    private Boolean virtualHostedStyle;

    public ImageRegistryConfigStorageS3FluentImpl() {
    }

    public ImageRegistryConfigStorageS3FluentImpl(ImageRegistryConfigStorageS3 instance) {
        this.withBucket(instance.getBucket());
        this.withCloudFront(instance.getCloudFront());
        this.withEncrypt(instance.getEncrypt());
        this.withKeyID(instance.getKeyID());
        this.withRegion(instance.getRegion());
        this.withRegionEndpoint(instance.getRegionEndpoint());
        this.withVirtualHostedStyle(instance.getVirtualHostedStyle());
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }

    @Override
    public A withBucket(String bucket) {
        this.bucket = bucket;
        return (A)this;
    }

    @Override
    public Boolean hasBucket() {
        return this.bucket != null;
    }

    @Override
    @Deprecated
    public A withNewBucket(String arg0) {
        return this.withBucket(new String(arg0));
    }

    @Override
    @Deprecated
    public ImageRegistryConfigStorageS3CloudFront getCloudFront() {
        return this.cloudFront != null ? this.cloudFront.build() : null;
    }

    @Override
    public ImageRegistryConfigStorageS3CloudFront buildCloudFront() {
        return this.cloudFront != null ? this.cloudFront.build() : null;
    }

    @Override
    public A withCloudFront(ImageRegistryConfigStorageS3CloudFront cloudFront) {
        this._visitables.get("cloudFront").remove(this.cloudFront);
        if (cloudFront != null) {
            this.cloudFront = new ImageRegistryConfigStorageS3CloudFrontBuilder(cloudFront);
            this._visitables.get("cloudFront").add(this.cloudFront);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCloudFront() {
        return this.cloudFront != null;
    }

    @Override
    public ImageRegistryConfigStorageS3Fluent.CloudFrontNested<A> withNewCloudFront() {
        return new CloudFrontNestedImpl();
    }

    @Override
    public ImageRegistryConfigStorageS3Fluent.CloudFrontNested<A> withNewCloudFrontLike(ImageRegistryConfigStorageS3CloudFront item) {
        return new CloudFrontNestedImpl(item);
    }

    @Override
    public ImageRegistryConfigStorageS3Fluent.CloudFrontNested<A> editCloudFront() {
        return this.withNewCloudFrontLike(this.getCloudFront());
    }

    @Override
    public ImageRegistryConfigStorageS3Fluent.CloudFrontNested<A> editOrNewCloudFront() {
        return this.withNewCloudFrontLike(this.getCloudFront() != null ? this.getCloudFront() : new ImageRegistryConfigStorageS3CloudFrontBuilder().build());
    }

    @Override
    public ImageRegistryConfigStorageS3Fluent.CloudFrontNested<A> editOrNewCloudFrontLike(ImageRegistryConfigStorageS3CloudFront item) {
        return this.withNewCloudFrontLike(this.getCloudFront() != null ? this.getCloudFront() : item);
    }

    @Override
    public Boolean getEncrypt() {
        return this.encrypt;
    }

    @Override
    public A withEncrypt(Boolean encrypt) {
        this.encrypt = encrypt;
        return (A)this;
    }

    @Override
    public Boolean hasEncrypt() {
        return this.encrypt != null;
    }

    @Override
    public String getKeyID() {
        return this.keyID;
    }

    @Override
    public A withKeyID(String keyID) {
        this.keyID = keyID;
        return (A)this;
    }

    @Override
    public Boolean hasKeyID() {
        return this.keyID != null;
    }

    @Override
    @Deprecated
    public A withNewKeyID(String arg0) {
        return this.withKeyID(new String(arg0));
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    @Override
    public Boolean hasRegion() {
        return this.region != null;
    }

    @Override
    @Deprecated
    public A withNewRegion(String arg0) {
        return this.withRegion(new String(arg0));
    }

    @Override
    public String getRegionEndpoint() {
        return this.regionEndpoint;
    }

    @Override
    public A withRegionEndpoint(String regionEndpoint) {
        this.regionEndpoint = regionEndpoint;
        return (A)this;
    }

    @Override
    public Boolean hasRegionEndpoint() {
        return this.regionEndpoint != null;
    }

    @Override
    @Deprecated
    public A withNewRegionEndpoint(String arg0) {
        return this.withRegionEndpoint(new String(arg0));
    }

    @Override
    public Boolean getVirtualHostedStyle() {
        return this.virtualHostedStyle;
    }

    @Override
    public A withVirtualHostedStyle(Boolean virtualHostedStyle) {
        this.virtualHostedStyle = virtualHostedStyle;
        return (A)this;
    }

    @Override
    public Boolean hasVirtualHostedStyle() {
        return this.virtualHostedStyle != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageRegistryConfigStorageS3FluentImpl that = (ImageRegistryConfigStorageS3FluentImpl)o;
        if (this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null) {
            return false;
        }
        if (this.cloudFront != null ? !this.cloudFront.equals(that.cloudFront) : that.cloudFront != null) {
            return false;
        }
        if (this.encrypt != null ? !this.encrypt.equals(that.encrypt) : that.encrypt != null) {
            return false;
        }
        if (this.keyID != null ? !this.keyID.equals(that.keyID) : that.keyID != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(that.region) : that.region != null) {
            return false;
        }
        if (this.regionEndpoint != null ? !this.regionEndpoint.equals(that.regionEndpoint) : that.regionEndpoint != null) {
            return false;
        }
        return !(this.virtualHostedStyle != null ? !this.virtualHostedStyle.equals(that.virtualHostedStyle) : that.virtualHostedStyle != null);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.cloudFront, this.encrypt, this.keyID, this.region, this.regionEndpoint, this.virtualHostedStyle, super.hashCode());
    }

    public class CloudFrontNestedImpl<N>
    extends ImageRegistryConfigStorageS3CloudFrontFluentImpl<ImageRegistryConfigStorageS3Fluent.CloudFrontNested<N>>
    implements ImageRegistryConfigStorageS3Fluent.CloudFrontNested<N>,
    Nested<N> {
        ImageRegistryConfigStorageS3CloudFrontBuilder builder;

        CloudFrontNestedImpl(ImageRegistryConfigStorageS3CloudFront item) {
            this.builder = new ImageRegistryConfigStorageS3CloudFrontBuilder(this, item);
        }

        CloudFrontNestedImpl() {
            this.builder = new ImageRegistryConfigStorageS3CloudFrontBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageRegistryConfigStorageS3FluentImpl.this.withCloudFront(this.builder.build());
        }

        @Override
        public N endCloudFront() {
            return this.and();
        }
    }
}

