/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_9;

import io.fabric8.kubernetes.api.builder.v5_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_9.Nested;
import io.fabric8.openshift.api.model.v5_9.SecretLocalReference;
import io.fabric8.openshift.api.model.v5_9.SecretLocalReferenceBuilder;
import io.fabric8.openshift.api.model.v5_9.SecretLocalReferenceFluentImpl;
import io.fabric8.openshift.api.model.v5_9.WebHookTrigger;
import io.fabric8.openshift.api.model.v5_9.WebHookTriggerFluent;
import java.util.Objects;

public class WebHookTriggerFluentImpl<A extends WebHookTriggerFluent<A>>
extends BaseFluent<A>
implements WebHookTriggerFluent<A> {
    private Boolean allowEnv;
    private String secret;
    private SecretLocalReferenceBuilder secretReference;

    public WebHookTriggerFluentImpl() {
    }

    public WebHookTriggerFluentImpl(WebHookTrigger instance) {
        this.withAllowEnv(instance.getAllowEnv());
        this.withSecret(instance.getSecret());
        this.withSecretReference(instance.getSecretReference());
    }

    @Override
    public Boolean getAllowEnv() {
        return this.allowEnv;
    }

    @Override
    public A withAllowEnv(Boolean allowEnv) {
        this.allowEnv = allowEnv;
        return (A)this;
    }

    @Override
    public Boolean hasAllowEnv() {
        return this.allowEnv != null;
    }

    @Override
    public String getSecret() {
        return this.secret;
    }

    @Override
    public A withSecret(String secret) {
        this.secret = secret;
        return (A)this;
    }

    @Override
    public Boolean hasSecret() {
        return this.secret != null;
    }

    @Override
    @Deprecated
    public A withNewSecret(String arg0) {
        return this.withSecret(new String(arg0));
    }

    @Override
    @Deprecated
    public SecretLocalReference getSecretReference() {
        return this.secretReference != null ? this.secretReference.build() : null;
    }

    @Override
    public SecretLocalReference buildSecretReference() {
        return this.secretReference != null ? this.secretReference.build() : null;
    }

    @Override
    public A withSecretReference(SecretLocalReference secretReference) {
        this._visitables.get("secretReference").remove(this.secretReference);
        if (secretReference != null) {
            this.secretReference = new SecretLocalReferenceBuilder(secretReference);
            this._visitables.get("secretReference").add(this.secretReference);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretReference() {
        return this.secretReference != null;
    }

    @Override
    public A withNewSecretReference(String name) {
        return this.withSecretReference(new SecretLocalReference(name));
    }

    @Override
    public WebHookTriggerFluent.SecretReferenceNested<A> withNewSecretReference() {
        return new SecretReferenceNestedImpl();
    }

    @Override
    public WebHookTriggerFluent.SecretReferenceNested<A> withNewSecretReferenceLike(SecretLocalReference item) {
        return new SecretReferenceNestedImpl(item);
    }

    @Override
    public WebHookTriggerFluent.SecretReferenceNested<A> editSecretReference() {
        return this.withNewSecretReferenceLike(this.getSecretReference());
    }

    @Override
    public WebHookTriggerFluent.SecretReferenceNested<A> editOrNewSecretReference() {
        return this.withNewSecretReferenceLike(this.getSecretReference() != null ? this.getSecretReference() : new SecretLocalReferenceBuilder().build());
    }

    @Override
    public WebHookTriggerFluent.SecretReferenceNested<A> editOrNewSecretReferenceLike(SecretLocalReference item) {
        return this.withNewSecretReferenceLike(this.getSecretReference() != null ? this.getSecretReference() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebHookTriggerFluentImpl that = (WebHookTriggerFluentImpl)o;
        if (this.allowEnv != null ? !this.allowEnv.equals(that.allowEnv) : that.allowEnv != null) {
            return false;
        }
        if (this.secret != null ? !this.secret.equals(that.secret) : that.secret != null) {
            return false;
        }
        return !(this.secretReference != null ? !this.secretReference.equals(that.secretReference) : that.secretReference != null);
    }

    public int hashCode() {
        return Objects.hash(this.allowEnv, this.secret, this.secretReference, super.hashCode());
    }

    public class SecretReferenceNestedImpl<N>
    extends SecretLocalReferenceFluentImpl<WebHookTriggerFluent.SecretReferenceNested<N>>
    implements WebHookTriggerFluent.SecretReferenceNested<N>,
    Nested<N> {
        SecretLocalReferenceBuilder builder;

        SecretReferenceNestedImpl(SecretLocalReference item) {
            this.builder = new SecretLocalReferenceBuilder(this, item);
        }

        SecretReferenceNestedImpl() {
            this.builder = new SecretLocalReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)WebHookTriggerFluentImpl.this.withSecretReference(this.builder.build());
        }

        @Override
        public N endSecretReference() {
            return this.and();
        }
    }
}

