/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_9;

import io.fabric8.kubernetes.api.builder.v5_9.BaseFluent;
import io.fabric8.openshift.api.model.v5_9.TLSProfileSpec;
import io.fabric8.openshift.api.model.v5_9.TLSProfileSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class TLSProfileSpecFluentImpl<A extends TLSProfileSpecFluent<A>>
extends BaseFluent<A>
implements TLSProfileSpecFluent<A> {
    private List<String> ciphers = new ArrayList<String>();
    private String minTLSVersion;

    public TLSProfileSpecFluentImpl() {
    }

    public TLSProfileSpecFluentImpl(TLSProfileSpec instance) {
        this.withCiphers(instance.getCiphers());
        this.withMinTLSVersion(instance.getMinTLSVersion());
    }

    @Override
    public A addToCiphers(Integer index, String item) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        this.ciphers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCiphers(Integer index, String item) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        this.ciphers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCiphers(String ... items) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        for (String item : items) {
            this.ciphers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCiphers(Collection<String> items) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        for (String item : items) {
            this.ciphers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCiphers(String ... items) {
        for (String item : items) {
            if (this.ciphers == null) continue;
            this.ciphers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCiphers(Collection<String> items) {
        for (String item : items) {
            if (this.ciphers == null) continue;
            this.ciphers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCiphers() {
        return this.ciphers;
    }

    @Override
    public String getCipher(Integer index) {
        return this.ciphers.get(index);
    }

    @Override
    public String getFirstCipher() {
        return this.ciphers.get(0);
    }

    @Override
    public String getLastCipher() {
        return this.ciphers.get(this.ciphers.size() - 1);
    }

    @Override
    public String getMatchingCipher(Predicate<String> predicate) {
        for (String item : this.ciphers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCipher(Predicate<String> predicate) {
        for (String item : this.ciphers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCiphers(List<String> ciphers) {
        if (ciphers != null) {
            this.ciphers = new ArrayList<String>();
            for (String item : ciphers) {
                this.addToCiphers(item);
            }
        } else {
            this.ciphers = null;
        }
        return (A)this;
    }

    @Override
    public A withCiphers(String ... ciphers) {
        if (this.ciphers != null) {
            this.ciphers.clear();
        }
        if (ciphers != null) {
            for (String item : ciphers) {
                this.addToCiphers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCiphers() {
        return this.ciphers != null && !this.ciphers.isEmpty();
    }

    @Override
    public A addNewCipher(String arg0) {
        return this.addToCiphers(new String(arg0));
    }

    @Override
    public String getMinTLSVersion() {
        return this.minTLSVersion;
    }

    @Override
    public A withMinTLSVersion(String minTLSVersion) {
        this.minTLSVersion = minTLSVersion;
        return (A)this;
    }

    @Override
    public Boolean hasMinTLSVersion() {
        return this.minTLSVersion != null;
    }

    @Override
    @Deprecated
    public A withNewMinTLSVersion(String arg0) {
        return this.withMinTLSVersion(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TLSProfileSpecFluentImpl that = (TLSProfileSpecFluentImpl)o;
        if (this.ciphers != null ? !this.ciphers.equals(that.ciphers) : that.ciphers != null) {
            return false;
        }
        return !(this.minTLSVersion != null ? !this.minTLSVersion.equals(that.minTLSVersion) : that.minTLSVersion != null);
    }

    public int hashCode() {
        return Objects.hash(this.ciphers, this.minTLSVersion, super.hashCode());
    }
}

