/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_9;

import io.fabric8.kubernetes.api.builder.v5_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_9.Nested;
import io.fabric8.kubernetes.api.model.v5_9.Status;
import io.fabric8.openshift.api.model.v5_9.ImageImportStatus;
import io.fabric8.openshift.api.model.v5_9.ImageImportStatusBuilder;
import io.fabric8.openshift.api.model.v5_9.ImageImportStatusFluentImpl;
import io.fabric8.openshift.api.model.v5_9.RepositoryImportStatus;
import io.fabric8.openshift.api.model.v5_9.RepositoryImportStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class RepositoryImportStatusFluentImpl<A extends RepositoryImportStatusFluent<A>>
extends BaseFluent<A>
implements RepositoryImportStatusFluent<A> {
    private List<String> additionalTags = new ArrayList<String>();
    private List<ImageImportStatusBuilder> images = new ArrayList<ImageImportStatusBuilder>();
    private Status status;

    public RepositoryImportStatusFluentImpl() {
    }

    public RepositoryImportStatusFluentImpl(RepositoryImportStatus instance) {
        this.withAdditionalTags(instance.getAdditionalTags());
        this.withImages(instance.getImages());
        this.withStatus(instance.getStatus());
    }

    @Override
    public A addToAdditionalTags(Integer index, String item) {
        if (this.additionalTags == null) {
            this.additionalTags = new ArrayList<String>();
        }
        this.additionalTags.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAdditionalTags(Integer index, String item) {
        if (this.additionalTags == null) {
            this.additionalTags = new ArrayList<String>();
        }
        this.additionalTags.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAdditionalTags(String ... items) {
        if (this.additionalTags == null) {
            this.additionalTags = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalTags.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAdditionalTags(Collection<String> items) {
        if (this.additionalTags == null) {
            this.additionalTags = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalTags.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalTags(String ... items) {
        for (String item : items) {
            if (this.additionalTags == null) continue;
            this.additionalTags.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAdditionalTags(Collection<String> items) {
        for (String item : items) {
            if (this.additionalTags == null) continue;
            this.additionalTags.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAdditionalTags() {
        return this.additionalTags;
    }

    @Override
    public String getAdditionalTag(Integer index) {
        return this.additionalTags.get(index);
    }

    @Override
    public String getFirstAdditionalTag() {
        return this.additionalTags.get(0);
    }

    @Override
    public String getLastAdditionalTag() {
        return this.additionalTags.get(this.additionalTags.size() - 1);
    }

    @Override
    public String getMatchingAdditionalTag(Predicate<String> predicate) {
        for (String item : this.additionalTags) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAdditionalTag(Predicate<String> predicate) {
        for (String item : this.additionalTags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAdditionalTags(List<String> additionalTags) {
        if (additionalTags != null) {
            this.additionalTags = new ArrayList<String>();
            for (String item : additionalTags) {
                this.addToAdditionalTags(item);
            }
        } else {
            this.additionalTags = null;
        }
        return (A)this;
    }

    @Override
    public A withAdditionalTags(String ... additionalTags) {
        if (this.additionalTags != null) {
            this.additionalTags.clear();
        }
        if (additionalTags != null) {
            for (String item : additionalTags) {
                this.addToAdditionalTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalTags() {
        return this.additionalTags != null && !this.additionalTags.isEmpty();
    }

    @Override
    public A addNewAdditionalTag(String arg0) {
        return this.addToAdditionalTags(new String(arg0));
    }

    @Override
    public A addToImages(Integer index, ImageImportStatus item) {
        if (this.images == null) {
            this.images = new ArrayList<ImageImportStatusBuilder>();
        }
        ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
        this._visitables.get("images").add(index >= 0 ? index.intValue() : this._visitables.get("images").size(), builder);
        this.images.add(index >= 0 ? index.intValue() : this.images.size(), builder);
        return (A)this;
    }

    @Override
    public A setToImages(Integer index, ImageImportStatus item) {
        if (this.images == null) {
            this.images = new ArrayList<ImageImportStatusBuilder>();
        }
        ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get("images").size()) {
            this._visitables.get("images").add(builder);
        } else {
            this._visitables.get("images").set(index, builder);
        }
        if (index < 0 || index >= this.images.size()) {
            this.images.add(builder);
        } else {
            this.images.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImages(ImageImportStatus ... items) {
        if (this.images == null) {
            this.images = new ArrayList<ImageImportStatusBuilder>();
        }
        for (ImageImportStatus item : items) {
            ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImages(Collection<ImageImportStatus> items) {
        if (this.images == null) {
            this.images = new ArrayList<ImageImportStatusBuilder>();
        }
        for (ImageImportStatus item : items) {
            ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImages(ImageImportStatus ... items) {
        for (ImageImportStatus item : items) {
            ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
            this._visitables.get("images").remove(builder);
            if (this.images == null) continue;
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImages(Collection<ImageImportStatus> items) {
        for (ImageImportStatus item : items) {
            ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
            this._visitables.get("images").remove(builder);
            if (this.images == null) continue;
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromImages(Predicate<ImageImportStatusBuilder> predicate) {
        if (this.images == null) {
            return (A)this;
        }
        Iterator<ImageImportStatusBuilder> each = this.images.iterator();
        Object visitables = this._visitables.get("images");
        while (each.hasNext()) {
            ImageImportStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageImportStatus> getImages() {
        return RepositoryImportStatusFluentImpl.build(this.images);
    }

    @Override
    public List<ImageImportStatus> buildImages() {
        return RepositoryImportStatusFluentImpl.build(this.images);
    }

    @Override
    public ImageImportStatus buildImage(Integer index) {
        return this.images.get(index).build();
    }

    @Override
    public ImageImportStatus buildFirstImage() {
        return this.images.get(0).build();
    }

    @Override
    public ImageImportStatus buildLastImage() {
        return this.images.get(this.images.size() - 1).build();
    }

    @Override
    public ImageImportStatus buildMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
        for (ImageImportStatusBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
        for (ImageImportStatusBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImages(List<ImageImportStatus> images) {
        if (this.images != null) {
            this._visitables.get("images").removeAll(this.images);
        }
        if (images != null) {
            this.images = new ArrayList<ImageImportStatusBuilder>();
            for (ImageImportStatus item : images) {
                this.addToImages(item);
            }
        } else {
            this.images = null;
        }
        return (A)this;
    }

    @Override
    public A withImages(ImageImportStatus ... images) {
        if (this.images != null) {
            this.images.clear();
        }
        if (images != null) {
            for (ImageImportStatus item : images) {
                this.addToImages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImages() {
        return this.images != null && !this.images.isEmpty();
    }

    @Override
    public RepositoryImportStatusFluent.ImagesNested<A> addNewImage() {
        return new ImagesNestedImpl();
    }

    @Override
    public RepositoryImportStatusFluent.ImagesNested<A> addNewImageLike(ImageImportStatus item) {
        return new ImagesNestedImpl(-1, item);
    }

    @Override
    public RepositoryImportStatusFluent.ImagesNested<A> setNewImageLike(Integer index, ImageImportStatus item) {
        return new ImagesNestedImpl(index, item);
    }

    @Override
    public RepositoryImportStatusFluent.ImagesNested<A> editImage(Integer index) {
        if (this.images.size() <= index) {
            throw new RuntimeException("Can't edit images. Index exceeds size.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public RepositoryImportStatusFluent.ImagesNested<A> editFirstImage() {
        if (this.images.size() == 0) {
            throw new RuntimeException("Can't edit first images. The list is empty.");
        }
        return this.setNewImageLike(0, this.buildImage(0));
    }

    @Override
    public RepositoryImportStatusFluent.ImagesNested<A> editLastImage() {
        int index = this.images.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last images. The list is empty.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public RepositoryImportStatusFluent.ImagesNested<A> editMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.images.size(); ++i) {
            if (!predicate.test(this.images.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching images. No match found.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public A withStatus(Status status) {
        this.status = status;
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryImportStatusFluentImpl that = (RepositoryImportStatusFluentImpl)o;
        if (this.additionalTags != null ? !this.additionalTags.equals(that.additionalTags) : that.additionalTags != null) {
            return false;
        }
        if (this.images != null ? !this.images.equals(that.images) : that.images != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.additionalTags, this.images, this.status, super.hashCode());
    }

    public class ImagesNestedImpl<N>
    extends ImageImportStatusFluentImpl<RepositoryImportStatusFluent.ImagesNested<N>>
    implements RepositoryImportStatusFluent.ImagesNested<N>,
    Nested<N> {
        ImageImportStatusBuilder builder;
        Integer index;

        ImagesNestedImpl(Integer index, ImageImportStatus item) {
            this.index = index;
            this.builder = new ImageImportStatusBuilder(this, item);
        }

        ImagesNestedImpl() {
            this.index = -1;
            this.builder = new ImageImportStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)RepositoryImportStatusFluentImpl.this.setToImages(this.index, this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }
}

