/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_9;

import io.fabric8.kubernetes.api.builder.v5_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_9.Nested;
import io.fabric8.kubernetes.api.model.v5_9.ListMeta;
import io.fabric8.openshift.api.model.v5_9.Network;
import io.fabric8.openshift.api.model.v5_9.NetworkBuilder;
import io.fabric8.openshift.api.model.v5_9.NetworkFluentImpl;
import io.fabric8.openshift.api.model.v5_9.NetworkList;
import io.fabric8.openshift.api.model.v5_9.NetworkListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class NetworkListFluentImpl<A extends NetworkListFluent<A>>
extends BaseFluent<A>
implements NetworkListFluent<A> {
    private String apiVersion;
    private List<NetworkBuilder> items = new ArrayList<NetworkBuilder>();
    private String kind;
    private ListMeta metadata;

    public NetworkListFluentImpl() {
    }

    public NetworkListFluentImpl(NetworkList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToItems(Integer index, Network item) {
        if (this.items == null) {
            this.items = new ArrayList<NetworkBuilder>();
        }
        NetworkBuilder builder = new NetworkBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index.intValue() : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index.intValue() : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(Integer index, Network item) {
        if (this.items == null) {
            this.items = new ArrayList<NetworkBuilder>();
        }
        NetworkBuilder builder = new NetworkBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(Network ... items) {
        if (this.items == null) {
            this.items = new ArrayList<NetworkBuilder>();
        }
        for (Network item : items) {
            NetworkBuilder builder = new NetworkBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<Network> items) {
        if (this.items == null) {
            this.items = new ArrayList<NetworkBuilder>();
        }
        for (Network item : items) {
            NetworkBuilder builder = new NetworkBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(Network ... items) {
        for (Network item : items) {
            NetworkBuilder builder = new NetworkBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<Network> items) {
        for (Network item : items) {
            NetworkBuilder builder = new NetworkBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<NetworkBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<NetworkBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            NetworkBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Network> getItems() {
        return NetworkListFluentImpl.build(this.items);
    }

    @Override
    public List<Network> buildItems() {
        return NetworkListFluentImpl.build(this.items);
    }

    @Override
    public Network buildItem(Integer index) {
        return this.items.get(index).build();
    }

    @Override
    public Network buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public Network buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public Network buildMatchingItem(Predicate<NetworkBuilder> predicate) {
        for (NetworkBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<NetworkBuilder> predicate) {
        for (NetworkBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<Network> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<NetworkBuilder>();
            for (Network item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(Network ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (Network item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public NetworkListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public NetworkListFluent.ItemsNested<A> addNewItemLike(Network item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public NetworkListFluent.ItemsNested<A> setNewItemLike(Integer index, Network item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public NetworkListFluent.ItemsNested<A> editItem(Integer index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public NetworkListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public NetworkListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public NetworkListFluent.ItemsNested<A> editMatchingItem(Predicate<NetworkBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkListFluentImpl that = (NetworkListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends NetworkFluentImpl<NetworkListFluent.ItemsNested<N>>
    implements NetworkListFluent.ItemsNested<N>,
    Nested<N> {
        NetworkBuilder builder;
        Integer index;

        ItemsNestedImpl(Integer index, Network item) {
            this.index = index;
            this.builder = new NetworkBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new NetworkBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

