/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_9;

import io.fabric8.kubernetes.api.builder.v5_9.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_9.InfrastructureStatus;
import io.fabric8.openshift.api.model.v5_9.InfrastructureStatusFluent;
import io.fabric8.openshift.api.model.v5_9.InfrastructureStatusFluentImpl;
import java.util.Objects;

public class InfrastructureStatusBuilder
extends InfrastructureStatusFluentImpl<InfrastructureStatusBuilder>
implements VisitableBuilder<InfrastructureStatus, InfrastructureStatusBuilder> {
    InfrastructureStatusFluent<?> fluent;
    Boolean validationEnabled;

    public InfrastructureStatusBuilder() {
        this(false);
    }

    public InfrastructureStatusBuilder(Boolean validationEnabled) {
        this(new InfrastructureStatus(), validationEnabled);
    }

    public InfrastructureStatusBuilder(InfrastructureStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public InfrastructureStatusBuilder(InfrastructureStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new InfrastructureStatus(), validationEnabled);
    }

    public InfrastructureStatusBuilder(InfrastructureStatusFluent<?> fluent, InfrastructureStatus instance) {
        this(fluent, instance, false);
    }

    public InfrastructureStatusBuilder(InfrastructureStatusFluent<?> fluent, InfrastructureStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiServerInternalURI(instance.getApiServerInternalURI());
        fluent.withApiServerURL(instance.getApiServerURL());
        fluent.withControlPlaneTopology(instance.getControlPlaneTopology());
        fluent.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain());
        fluent.withInfrastructureName(instance.getInfrastructureName());
        fluent.withInfrastructureTopology(instance.getInfrastructureTopology());
        fluent.withPlatform(instance.getPlatform());
        fluent.withPlatformStatus(instance.getPlatformStatus());
        this.validationEnabled = validationEnabled;
    }

    public InfrastructureStatusBuilder(InfrastructureStatus instance) {
        this(instance, (Boolean)false);
    }

    public InfrastructureStatusBuilder(InfrastructureStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiServerInternalURI(instance.getApiServerInternalURI());
        this.withApiServerURL(instance.getApiServerURL());
        this.withControlPlaneTopology(instance.getControlPlaneTopology());
        this.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain());
        this.withInfrastructureName(instance.getInfrastructureName());
        this.withInfrastructureTopology(instance.getInfrastructureTopology());
        this.withPlatform(instance.getPlatform());
        this.withPlatformStatus(instance.getPlatformStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public InfrastructureStatus build() {
        InfrastructureStatus buildable = new InfrastructureStatus(this.fluent.getApiServerInternalURI(), this.fluent.getApiServerURL(), this.fluent.getControlPlaneTopology(), this.fluent.getEtcdDiscoveryDomain(), this.fluent.getInfrastructureName(), this.fluent.getInfrastructureTopology(), this.fluent.getPlatform(), this.fluent.getPlatformStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InfrastructureStatusBuilder that = (InfrastructureStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

