/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_9;

import io.fabric8.kubernetes.api.builder.v5_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_9.Nested;
import io.fabric8.kubernetes.api.model.v5_9.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_9.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_9.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v5_9.Image;
import io.fabric8.openshift.api.model.v5_9.ImageBuilder;
import io.fabric8.openshift.api.model.v5_9.ImageFluentImpl;
import io.fabric8.openshift.api.model.v5_9.ImageStreamImage;
import io.fabric8.openshift.api.model.v5_9.ImageStreamImageFluent;
import java.util.Objects;

public class ImageStreamImageFluentImpl<A extends ImageStreamImageFluent<A>>
extends BaseFluent<A>
implements ImageStreamImageFluent<A> {
    private String apiVersion;
    private ImageBuilder image;
    private String kind;
    private ObjectMetaBuilder metadata;

    public ImageStreamImageFluentImpl() {
    }

    public ImageStreamImageFluentImpl(ImageStreamImage instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withImage(instance.getImage());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    @Deprecated
    public Image getImage() {
        return this.image != null ? this.image.build() : null;
    }

    @Override
    public Image buildImage() {
        return this.image != null ? this.image.build() : null;
    }

    @Override
    public A withImage(Image image) {
        this._visitables.get("image").remove(this.image);
        if (image != null) {
            this.image = new ImageBuilder(image);
            this._visitables.get("image").add(this.image);
        }
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public ImageStreamImageFluent.ImageNested<A> withNewImage() {
        return new ImageNestedImpl();
    }

    @Override
    public ImageStreamImageFluent.ImageNested<A> withNewImageLike(Image item) {
        return new ImageNestedImpl(item);
    }

    @Override
    public ImageStreamImageFluent.ImageNested<A> editImage() {
        return this.withNewImageLike(this.getImage());
    }

    @Override
    public ImageStreamImageFluent.ImageNested<A> editOrNewImage() {
        return this.withNewImageLike(this.getImage() != null ? this.getImage() : new ImageBuilder().build());
    }

    @Override
    public ImageStreamImageFluent.ImageNested<A> editOrNewImageLike(Image item) {
        return this.withNewImageLike(this.getImage() != null ? this.getImage() : item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ImageStreamImageFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ImageStreamImageFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ImageStreamImageFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ImageStreamImageFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ImageStreamImageFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageStreamImageFluentImpl that = (ImageStreamImageFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.image, this.kind, this.metadata, super.hashCode());
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ImageStreamImageFluent.MetadataNested<N>>
    implements ImageStreamImageFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamImageFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ImageNestedImpl<N>
    extends ImageFluentImpl<ImageStreamImageFluent.ImageNested<N>>
    implements ImageStreamImageFluent.ImageNested<N>,
    Nested<N> {
        ImageBuilder builder;

        ImageNestedImpl(Image item) {
            this.builder = new ImageBuilder(this, item);
        }

        ImageNestedImpl() {
            this.builder = new ImageBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamImageFluentImpl.this.withImage(this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }
}

