/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_9.utils;

import io.fabric8.kubernetes.api.model.v5_9.ContainerState;
import io.fabric8.kubernetes.api.model.v5_9.ContainerStatus;
import io.fabric8.kubernetes.api.model.v5_9.Pod;
import io.fabric8.kubernetes.clnt.v5_9.internal.readiness.Readiness;
import java.util.Collections;
import java.util.List;

public class PodStatusUtil {
    private static final String POD_RUNNING = "Running";
    private static final String POD_INITIALIZING = "PodInitializing";
    private static final String CONTAINER_COMPLETED = "Completed";

    private PodStatusUtil() {
    }

    public static boolean isRunning(Pod pod) {
        if (PodStatusUtil.isInStatus(POD_RUNNING, pod)) {
            return true;
        }
        if (PodStatusUtil.hasDeletionTimestamp(pod) || PodStatusUtil.isInitializing(pod)) {
            return false;
        }
        if (PodStatusUtil.hasRunningContainer(pod)) {
            return !PodStatusUtil.hasCompletedContainer(pod) || Readiness.isPodReady(pod);
        }
        return false;
    }

    private static boolean isInStatus(String expected, Pod pod) {
        if (pod == null || pod.getStatus() == null || expected == null) {
            return false;
        }
        return expected.equals(pod.getStatus().getPhase()) || expected.equals(pod.getStatus().getReason());
    }

    private static boolean hasDeletionTimestamp(Pod pod) {
        if (pod == null) {
            return false;
        }
        return pod.getMetadata() != null && pod.getMetadata().getDeletionTimestamp() != null;
    }

    public static boolean isInitializing(Pod pod) {
        if (pod == null) {
            return false;
        }
        return pod.getStatus().getInitContainerStatuses().stream().anyMatch(PodStatusUtil::isInitializing);
    }

    private static boolean isInitializing(ContainerStatus status) {
        if (status == null) {
            return true;
        }
        ContainerState state = status.getState();
        if (state == null) {
            return true;
        }
        if (PodStatusUtil.isTerminated(state)) {
            return PodStatusUtil.hasNonNullExitCode(state);
        }
        if (PodStatusUtil.isWaiting(state)) {
            return !PodStatusUtil.isWaitingInitializing(state);
        }
        return true;
    }

    private static boolean isTerminated(ContainerState state) {
        return state == null || state.getTerminated() != null;
    }

    private static boolean hasNonNullExitCode(ContainerState state) {
        return state.getTerminated() != null && state.getTerminated().getExitCode() != 0;
    }

    private static boolean isWaiting(ContainerState state) {
        return state == null || state.getWaiting() != null;
    }

    private static boolean isWaitingInitializing(ContainerState state) {
        return state != null && state.getWaiting() != null && POD_INITIALIZING.equals(state.getWaiting().getReason());
    }

    private static boolean hasRunningContainer(Pod pod) {
        return PodStatusUtil.getContainerStatus(pod).stream().anyMatch(PodStatusUtil::isRunning);
    }

    private static boolean isRunning(ContainerStatus status) {
        return status.getReady() != null && status.getState() != null && status.getState().getRunning() != null;
    }

    private static boolean hasCompletedContainer(Pod pod) {
        return PodStatusUtil.getContainerStatus(pod).stream().anyMatch(PodStatusUtil::isCompleted);
    }

    private static boolean isCompleted(ContainerStatus status) {
        return status.getState() != null && status.getState().getTerminated() != null && CONTAINER_COMPLETED.equals(status.getState().getTerminated().getReason());
    }

    public static List<ContainerStatus> getContainerStatus(Pod pod) {
        if (pod == null || pod.getStatus() == null) {
            return Collections.emptyList();
        }
        return pod.getStatus().getContainerStatuses();
    }
}

