/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_9.utils;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KubernetesVersionFactory {
    private KubernetesVersionFactory() {
    }

    public static Version create(String versionValue) {
        Version version = KubernetesVersion.FACTORY.create(versionValue);
        if (version == null) {
            version = NonKubernetesVersion.FACTORY.create(versionValue);
        }
        return version;
    }

    protected static abstract class Version
    implements Comparable<Version> {
        protected final String full;

        protected Version(String full) {
            this.full = full;
        }

        public abstract boolean isKubernetes();

        public String getFull() {
            return this.full;
        }

        public String toString() {
            return this.full;
        }
    }

    public static class NonKubernetesVersion
    extends Version {
        public static final VersionFactory<NonKubernetesVersion> FACTORY = version -> {
            if (version == null) {
                return null;
            }
            return new NonKubernetesVersion(version);
        };

        private NonKubernetesVersion(String version) {
            super(version);
        }

        @Override
        public boolean isKubernetes() {
            return false;
        }

        @Override
        public int compareTo(Version other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof KubernetesVersion) {
                return -1;
            }
            if (other instanceof NonKubernetesVersion) {
                return this.full.compareTo(other.full) * -1;
            }
            return -1;
        }
    }

    public static class KubernetesVersion
    extends Version {
        public static final VersionFactory<KubernetesVersion> FACTORY = new VersionFactory<KubernetesVersion>(){
            private final Pattern versionPattern = Pattern.compile("v([0-9]+)((alpha|beta)([0-9]+)?)*");

            @Override
            public KubernetesVersion create(String version) {
                if (version == null) {
                    return null;
                }
                Matcher matcher = this.versionPattern.matcher(version);
                if (!matcher.matches()) {
                    return null;
                }
                Integer majorValue = this.getInt(matcher.group(1));
                String qualifierValue = matcher.group(3);
                Integer minorValue = this.getInt(matcher.group(4));
                return new KubernetesVersion(majorValue, qualifierValue, minorValue, version);
            }

            private Integer getInt(String value) {
                if (value == null) {
                    return null;
                }
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        };
        private final Integer major;
        private final Optional<String> qualifier;
        private final Optional<Integer> minor;

        private KubernetesVersion(Integer major, String qualifier, Integer minor, String version) {
            super(version);
            this.major = major;
            this.qualifier = Optional.ofNullable(qualifier);
            this.minor = Optional.ofNullable(minor);
        }

        public Integer getMajor() {
            return this.major;
        }

        public Optional<String> getQualifier() {
            return this.qualifier;
        }

        public Optional<Integer> getMinor() {
            return this.minor;
        }

        public boolean isStable() {
            return this.qualifier.orElse(null) == null;
        }

        @Override
        public boolean isKubernetes() {
            return true;
        }

        @Override
        public int compareTo(Version other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof NonKubernetesVersion) {
                return 1;
            }
            if (!(other instanceof KubernetesVersion)) {
                return 1;
            }
            KubernetesVersion otherKube = (KubernetesVersion)other;
            if (this.qualifier.isPresent()) {
                if (!otherKube.qualifier.isPresent()) {
                    return -1;
                }
                int qualifierComparison = this.qualifier.get().compareTo((String)otherKube.qualifier.orElse(null));
                if (qualifierComparison != 0) {
                    return qualifierComparison;
                }
                int majorComparison = this.compareMajor(otherKube);
                if (majorComparison != 0) {
                    return majorComparison;
                }
                return this.compareMinor(otherKube);
            }
            if (!otherKube.qualifier.isPresent()) {
                return this.compareMajor(otherKube);
            }
            return 1;
        }

        private int compareMajor(KubernetesVersion other) {
            return this.major.compareTo(other.major);
        }

        private int compareMinor(KubernetesVersion other) {
            if (this.minor.isPresent()) {
                if (!other.minor.isPresent()) {
                    return 1;
                }
                return this.minor.get().compareTo((Integer)other.minor.orElse(null));
            }
            if (!other.minor.isPresent()) {
                return 0;
            }
            return -1;
        }
    }

    public static interface VersionFactory<T extends Version> {
        public T create(String var1);
    }
}

